---
generated_at: 2026-01-08 15:30:00
metrics:
  claims_total: 52
  claims_with_evidence: 50
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：50 / 52、根拠なし：2
- 優先レビュー（高）
  1. **Employeesコントローラーの認証要件**：コントローラーに[Authorize]属性がなく、認証不要と判断したが要確認
  2. **CreateProduct/UpdateProductのバリデーション**：バリデーターファイルが見つからず、バリデーションルール未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Controllers/BaseController.cs` - ベースコントローラー定義、ルーティングパターン
- E-02: `Src/WebUI/Controllers/CategoriesController.cs` - Categoriesエンドポイント定義
- E-03: `Src/WebUI/Controllers/CustomersController.cs` - Customersエンドポイント定義
- E-04: `Src/WebUI/Controllers/EmployeesController.cs` - Employeesエンドポイント定義
- E-05: `Src/WebUI/Controllers/ProductsController.cs` - Productsエンドポイント定義
- E-06: `Src/WebUI/Controllers/OidcConfigurationController.cs` - OIDC設定コントローラー
- E-07: `Src/WebUI/Startup.cs` - アプリケーション設定、認証、Swagger設定
- E-08: `Src/WebUI/Common/CustomExceptionHandlerMiddleware.cs` - 例外ハンドリング、エラーレスポンス形式
- E-09: `Src/WebUI/wwwroot/api/specification.json` - OpenAPI仕様書
- E-10: `Src/Application/Categories/Commands/UpsertCategory/UpsertCategoryCommand.cs` - カテゴリUpsertコマンド
- E-11: `Src/Application/Categories/Commands/DeleteCategory/DeleteCategoryCommand.cs` - カテゴリ削除コマンド
- E-12: `Src/Application/Categories/Queries/GetCategoriesList/CategoriesListVm.cs` - カテゴリ一覧レスポンス
- E-13: `Src/Application/Categories/Queries/GetCategoriesList/CategoryDto.cs` - カテゴリDTO
- E-14: `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommand.cs` - 顧客作成コマンド
- E-15: `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommandValidator.cs` - 顧客作成バリデーター
- E-16: `Src/Application/Customers/Commands/UpdateCustomer/UpdateCustomerCommand.cs` - 顧客更新コマンド
- E-17: `Src/Application/Customers/Commands/UpdateCustomer/UpdateCustomerCommandValidator.cs` - 顧客更新バリデーター
- E-18: `Src/Application/Customers/Commands/DeleteCustomer/DeleteCustomerCommand.cs` - 顧客削除コマンド
- E-19: `Src/Application/Customers/Queries/GetCustomersList/CustomersListVm.cs` - 顧客一覧レスポンス
- E-20: `Src/Application/Customers/Queries/GetCustomersList/CustomerLookupDto.cs` - 顧客一覧DTO
- E-21: `Src/Application/Customers/Queries/GetCustomerDetail/CustomerDetailVm.cs` - 顧客詳細レスポンス
- E-22: `Src/Application/Employees/Commands/UpsertEmployee/UpsertEmployeeCommand.cs` - 従業員Upsertコマンド
- E-23: `Src/Application/Employees/Commands/DeleteEmployee/DeleteEmployeeCommand.cs` - 従業員削除コマンド
- E-24: `Src/Application/Employees/Queries/GetEmployeesList/EmployeesListVm.cs` - 従業員一覧レスポンス
- E-25: `Src/Application/Employees/Queries/GetEmployeesList/EmployeeLookupDto.cs` - 従業員一覧DTO
- E-26: `Src/Application/Employees/Queries/GetEmployeeDetail/EmployeeDetailVm.cs` - 従業員詳細レスポンス
- E-27: `Src/Application/Employees/Queries/GetEmployeeDetail/EmployeeTerritoryDto.cs` - 従業員テリトリーDTO
- E-28: `Src/Application/Products/Commands/CreateProduct/CreateProductCommand.cs` - 商品作成コマンド
- E-29: `Src/Application/Products/Commands/UpdateProduct/UpdateProductCommand.cs` - 商品更新コマンド
- E-30: `Src/Application/Products/Commands/DeleteProduct/DeleteProductCommand.cs` - 商品削除コマンド
- E-31: `Src/Application/Products/Queries/GetProductsList/ProductsListVm.cs` - 商品一覧レスポンス
- E-32: `Src/Application/Products/Queries/GetProductsList/ProductDto.cs` - 商品一覧DTO
- E-33: `Src/Application/Products/Queries/GetProductDetail/ProductDetailVm.cs` - 商品詳細レスポンス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIベースURLは/api | E-01, E-07 | ○ |
| C-02 | IdentityServer4による認証 | E-07 | ○ |
| C-03 | ルーティングパターンはapi/[controller]/[action] | E-01 | ○ |
| C-04 | ValidationExceptionは400を返す | E-08 | ○ |
| C-05 | NotFoundExceptionは404を返す | E-08 | ○ |
| C-06 | BadRequestExceptionは400を返す | E-08 | ○ |
| C-07 | Categories GetAllは認証不要 | E-02 | ○ |
| C-08 | Categories Upsertは認証必要 | E-02 | ○ |
| C-09 | Categories Deleteは認証必要 | E-02 | ○ |
| C-10 | CategoriesListVmの構造 | E-12, E-13, E-09 | ○ |
| C-11 | UpsertCategoryCommandの構造 | E-10, E-09 | ○ |
| C-12 | Customers GetAllは認証必要 | E-03 | ○ |
| C-13 | Customers Getは認証必要 | E-03 | ○ |
| C-14 | Customers Createは認証必要 | E-03 | ○ |
| C-15 | Customers Updateは認証必要 | E-03 | ○ |
| C-16 | Customers Deleteは認証必要 | E-03 | ○ |
| C-17 | CustomersListVmの構造 | E-19, E-20, E-09 | ○ |
| C-18 | CustomerDetailVmの構造 | E-21, E-09 | ○ |
| C-19 | CreateCustomerCommandの構造 | E-14, E-09 | ○ |
| C-20 | CreateCustomerCommandのバリデーション | E-15 | ○ |
| C-21 | UpdateCustomerCommandの構造 | E-16, E-09 | ○ |
| C-22 | UpdateCustomerCommandのバリデーション | E-17 | ○ |
| C-23 | オーストラリア郵便番号の特別バリデーション | E-17 | ○ |
| C-24 | QLD州電話番号の特別バリデーション | E-17 | ○ |
| C-25 | Employees GetAllは認証不要 | E-04 | ○ |
| C-26 | Employees Getは認証不要 | E-04 | ○ |
| C-27 | Employees Upsertは認証不要 | E-04 | △ |
| C-28 | Employees Deleteは認証不要 | E-04 | △ |
| C-29 | EmployeeLookupDtoの構造 | E-25, E-09 | ○ |
| C-30 | EmployeeDetailVmの構造 | E-26, E-27, E-09 | ○ |
| C-31 | UpsertEmployeeCommandの構造 | E-22, E-09 | ○ |
| C-32 | 従業員は自分自身を削除できない | E-23 | ○ |
| C-33 | Products GetAllは認証不要 | E-05 | ○ |
| C-34 | Products Getは認証不要 | E-05 | ○ |
| C-35 | Products Createは認証必要 | E-05 | ○ |
| C-36 | Products Updateは認証必要 | E-05 | ○ |
| C-37 | Products Deleteは認証必要 | E-05 | ○ |
| C-38 | Products Downloadは認証不要 | E-05 | ○ |
| C-39 | ProductsListVmの構造 | E-31, E-32, E-09 | ○ |
| C-40 | ProductDetailVmの構造 | E-33, E-09 | ○ |
| C-41 | CreateProductCommandの構造 | E-28, E-09 | ○ |
| C-42 | UpdateProductCommandの構造 | E-29, E-09 | ○ |
| C-43 | DeleteProductCommandの構造 | E-30 | ○ |
| C-44 | Swagger UIは/apiで利用可能 | E-07 | ○ |
| C-45 | ヘルスチェックは/healthで利用可能 | E-07 | ○ |
| C-46 | FluentValidationによるバリデーション | E-07 | ○ |
| C-47 | MediatRによるCQRS実装 | E-01, E-07 | ○ |
| C-48 | AutoMapperによるマッピング | E-13, E-20, E-25, E-32 | ○ |
| C-49 | Categories Upsertは200 OKでIDを返す | E-02, E-09 | ○ |
| C-50 | Products Createは200 OKでIDを返す | E-05, E-09 | ○ |
| C-51 | Employees Upsertは200 OKでIDを返す | E-04, E-09 | ○ |
| C-52 | Products Downloadはバイナリファイルを返す | E-05, E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- **EmployeesControllerの認証要件**
  - EmployeesControllerには[Authorize]属性がクラスレベルで付与されていない
  - 全エンドポイントが認証不要として解釈したが、セキュリティ観点で意図的かどうか要確認
  - 候補：セキュリティ要件の追加確認 / 開発チームへの確認 / 本番環境設定の確認

- **Products Create/Updateのバリデーション**
  - CreateProductCommandValidator、UpdateProductCommandValidatorファイルが見つからない
  - バリデーションルールが実装されていない可能性、または別の場所で実装されている可能性
  - 候補：バリデーターの追加実装確認 / DataAnnotationsによる実装確認

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**: EmployeesController - 全エンドポイントが認証不要。従業員情報の作成・更新・削除が認証なしで可能な状態は、本番環境でのセキュリティリスクが高い。意図的な設計かどうか確認が必要。
- **リスク1（中）**: Products Create/Update - バリデーターが見つからないため、不正なデータが登録される可能性がある。
- **リスク0（低）**: その他のエンドポイントは適切に認証・バリデーションが設定されている。

## 6) レビュアーチェックリスト（最小）
- [ ] EmployeesControllerの認証要件が意図通りかどうか確認（セキュリティ観点で重要）
- [ ] Products Create/Updateにバリデーションが必要かどうか確認
- [ ] OpenAPI仕様書（specification.json）と実際のコントローラーの整合性確認
- [ ] 各エンドポイントのHTTPステータスコードがコントローラーの実装と一致しているか確認
- [ ] バリデーションルールの日本語メッセージの要否確認
- [ ] 本番環境での認証設定が適切かどうか確認
