# Northwind Traders

## 概要

Northwind Tradersは、.NET Coreを使用したClean Architectureの実装を示すサンプルアプリケーションです。クラシックなNorthwindデータベースをベースに、商品管理、顧客管理、従業員管理、注文管理などの機能を提供する業務システムのデモンストレーションプロジェクトです。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| カテゴリ管理 | 商品カテゴリの一覧表示、作成・更新（Upsert）、削除 |
| 顧客管理 | 顧客の一覧表示、詳細表示、作成、更新、削除 |
| 従業員管理 | 従業員の一覧表示、詳細表示、作成・更新（Upsert）、削除 |
| 商品管理 | 商品の一覧表示、詳細表示、作成、更新、削除、CSVダウンロード |
| 認証・認可 | ASP.NET Core IdentityとIdentityServerを使用したユーザー認証 |
| API | RESTful APIとSwagger UIによるAPIドキュメント |

## 技術スタック

### コア

- フレームワーク: ASP.NET Core 3.0
- 言語: C# / TypeScript
- データベース: SQL Server（Entity Framework Core 3.0）
- フロントエンド: Angular 8.2
- 認証: ASP.NET Core Identity + IdentityServer

### 主要ライブラリ

#### バックエンド
- MediatR 7.0.0 - CQRSパターン実装（コマンド/クエリの分離）
- AutoMapper 9.0.0 - オブジェクトマッピング
- FluentValidation 8.5.0 - バリデーション
- Entity Framework Core 3.0.0 - ORM
- NSwag - OpenAPI/Swagger生成
- CsvHelper 12.1.2 - CSVファイル処理

#### フロントエンド
- Angular 8.2.5 - SPAフレームワーク
- ngx-bootstrap 5.1.1 - UIコンポーネント
- oidc-client 1.9.1 - OpenID Connect認証
- RxJS 6.5.3 - リアクティブプログラミング

## ディレクトリ構成

```
NorthwindTraders/
├── Src/
│   ├── Domain/                    # ドメイン層（エンティティ、値オブジェクト）
│   │   ├── Common/               # 共通クラス（ValueObject, AuditableEntity）
│   │   ├── Entities/             # ドメインエンティティ
│   │   ├── Exceptions/           # ドメイン例外
│   │   └── ValueObjects/         # 値オブジェクト
│   │
│   ├── Application/               # アプリケーション層（ユースケース）
│   │   ├── Common/               # 共通処理
│   │   │   ├── Behaviours/       # MediatRパイプライン
│   │   │   ├── Exceptions/       # アプリケーション例外
│   │   │   ├── Interfaces/       # インターフェース定義
│   │   │   ├── Mappings/         # AutoMapper設定
│   │   │   └── Models/           # 共通モデル
│   │   ├── Categories/           # カテゴリ機能（Commands/Queries）
│   │   ├── Customers/            # 顧客機能（Commands/Queries）
│   │   ├── Employees/            # 従業員機能（Commands/Queries）
│   │   ├── Products/             # 商品機能（Commands/Queries）
│   │   ├── Notifications/        # 通知機能
│   │   └── System/               # システムコマンド（サンプルデータ投入）
│   │
│   ├── Infrastructure/            # インフラストラクチャ層
│   │   ├── Files/                # ファイル処理（CSV生成）
│   │   └── Identity/             # 認証・認可
│   │
│   ├── Persistence/               # 永続化層
│   │   ├── Configurations/       # EF Core設定
│   │   └── Migrations/           # マイグレーション
│   │
│   ├── Common/                    # 共通ライブラリ
│   │
│   └── WebUI/                     # プレゼンテーション層
│       ├── Controllers/          # APIコントローラー
│       ├── Areas/Identity/       # 認証関連ページ
│       ├── ClientApp/            # Angularフロントエンド
│       └── Services/             # Webサービス
│
├── Tests/
│   ├── Domain.UnitTests/          # ドメイン層単体テスト
│   ├── Application.UnitTests/     # アプリケーション層単体テスト
│   ├── Persistence.IntegrationTests/  # 永続化層統合テスト
│   └── WebUI.IntegrationTests/    # WebUI統合テスト
│
├── Docs/                          # ドキュメント
├── Northwind.sln                  # ソリューションファイル
├── global.json                    # .NET SDKバージョン設定
└── azure-pipelines.yml            # Azure DevOps CI/CD設定
```

## セットアップ

### 必要条件

- .NET Core SDK 3.0.100以上
- Node.js（Angular CLIの実行に必要）
- SQL Server（LocalDBまたはフルバージョン）
- Visual Studio 2019またはVisual Studio Code

### インストール手順

1. リポジトリをクローン
   ```bash
   git clone https://github.com/jasontaylordev/NorthwindTraders.git
   cd NorthwindTraders
   ```

2. データベースのマイグレーション実行
   ```bash
   dotnet ef database update -p Src/Persistence -s Src/WebUI
   ```

3. フロントエンドの依存関係インストール
   ```bash
   cd Src/WebUI/ClientApp
   npm install
   cd ../../..
   ```

4. アプリケーションの起動
   ```bash
   dotnet run -p Src/WebUI
   ```

5. ブラウザで以下のURLにアクセス
   - アプリケーション: https://localhost:5001
   - Swagger UI: https://localhost:5001/api

## 開発

### ビルド

```bash
dotnet build
```

### テスト実行

```bash
dotnet test
```

### フロントエンド開発

```bash
cd Src/WebUI/ClientApp
npm start    # 開発サーバー起動（http://localhost:4200）
npm test     # 単体テスト実行
npm run e2e  # E2Eテスト実行
npm run lint # Lintチェック
```

### CI/CD

Azure Pipelinesを使用したCI/CDが設定されています（`azure-pipelines.yml`）。
- トリガー: masterブランチへのプッシュ
- ビルド環境: ubuntu-latest
- 出力: 自己完結型のWin-x86アプリケーション
