---
generated_at: 2026-01-07 21:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **インストール手順**：実際の動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md`（プロジェクトルートの既存README）
- E-02: `global.json`（.NET SDKバージョン設定）
- E-03: `Northwind.sln`（ソリューションファイル）
- E-04: `Src/WebUI/WebUI.csproj`（WebUIプロジェクト設定）
- E-05: `Src/Application/Application.csproj`（Applicationプロジェクト設定）
- E-06: `Src/Infrastructure/Infrastructure.csproj`（Infrastructureプロジェクト設定）
- E-07: `Src/Persistence/Persistence.csproj`（Persistenceプロジェクト設定）
- E-08: `Src/Domain/Domain.csproj`（Domainプロジェクト設定）
- E-09: `Src/WebUI/ClientApp/package.json`（Angular依存関係）
- E-10: `Src/WebUI/Startup.cs`（ASP.NET Core設定）
- E-11: `azure-pipelines.yml`（CI/CD設定）
- E-12: `Src/Application/README.md`（Application層説明）
- E-13: `Src/Domain/README.md`（Domain層説明）
- E-14: `Src/Infrastructure/README.md`（Infrastructure層説明）
- E-15: `Src/WebUI/Controllers/`（コントローラー群）
- E-16: ディレクトリ構造（lsコマンドによる確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | .NET Core 3.0を使用したClean Architecture実装 | E-01, E-02, E-04 | ○ |
| C-02 | .NET Core SDK 3.0.100を使用 | E-02 | ○ |
| C-03 | ASP.NET Core 3.0フレームワーク | E-04 | ○ |
| C-04 | Angular 8.2フロントエンド | E-09 | ○ |
| C-05 | Entity Framework Core 3.0使用 | E-04, E-05 | ○ |
| C-06 | MediatR 7.0.0使用（CQRSパターン） | E-05 | ○ |
| C-07 | AutoMapper 9.0.0使用 | E-05 | ○ |
| C-08 | FluentValidation 8.5.0使用 | E-04, E-05 | ○ |
| C-09 | NSwag使用（Swagger生成） | E-04, E-10 | ○ |
| C-10 | CsvHelper 12.1.2使用 | E-06 | ○ |
| C-11 | ngx-bootstrap 5.1.1使用 | E-09 | ○ |
| C-12 | oidc-client 1.9.1使用 | E-09 | ○ |
| C-13 | カテゴリ管理機能（CRUD） | E-15 | ○ |
| C-14 | 顧客管理機能（CRUD） | E-15 | ○ |
| C-15 | 商品管理機能（CRUD + CSVダウンロード） | E-15 | ○ |
| C-16 | 従業員管理機能 | E-15, E-16 | ○ |
| C-17 | IdentityServerによる認証 | E-04, E-06, E-10 | ○ |
| C-18 | Domain層の構造（Entities, ValueObjects等） | E-13, E-16 | ○ |
| C-19 | Application層の構造（Commands/Queries分離） | E-12, E-16 | ○ |
| C-20 | Infrastructure層の構造 | E-14, E-16 | ○ |
| C-21 | Persistence層の構造（EF Core設定） | E-16 | ○ |
| C-22 | WebUI層の構造（Controllers, ClientApp） | E-16 | ○ |
| C-23 | テストプロジェクトの存在 | E-03, E-16 | ○ |
| C-24 | Azure Pipelines CI/CD設定 | E-11 | ○ |
| C-25 | masterブランチトリガー | E-11 | ○ |
| C-26 | ubuntu-latestでビルド | E-11 | ○ |
| C-27 | フロントエンドnpmコマンド | E-09 | ○ |
| C-28 | インストール手順（動作確認） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- インストール手順は実際のセットアップ手順を示していますが、アーカイブプロジェクトのため最新環境での動作確認が必要
  - 候補：実際のビルド・実行テスト / 依存パッケージの互換性確認 / データベース接続設定の確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 技術スタック情報（csprojファイルで明確に確認可能）
- **0: 低リスク** - ディレクトリ構成（実際のファイル構造と一致）
- **0: 低リスク** - 主要機能（コントローラーとコマンド/クエリで確認）
- **1: 中リスク** - セットアップ手順（アーカイブプロジェクトのため動作保証なし）

## 6) レビュアーチェックリスト（最小）
- [ ] .NET Core 3.0は現在サポート終了しているため、実際に使用する場合はアップグレードを検討
- [ ] インストール手順は参考情報として記載されているが、実際の環境では依存関係の互換性問題が発生する可能性あり
- [ ] Angular 8.2も古いバージョンのため、セキュリティアップデートの適用を推奨
- [ ] プロジェクトはアーカイブ済みであり、本番利用には最新版（Clean Architecture Solution Template）の使用を検討
