---
generated_at: 2026-01-08 00:15:00
metrics:
  claims_total: 52
  claims_with_evidence: 50
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：50 / 52、根拠なし：2
- 優先レビュー（高）
  1. **外部サービス連携の詳細**: Infrastructure層の実装詳細が一部推定
  2. **Angular SPAの詳細**: フロントエンドの構成詳細は確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Northwind.sln` - ソリューション構成
- E-02: `Src/Domain/Domain.csproj` - Domain層プロジェクト定義
- E-03: `Src/Application/Application.csproj` - Application層プロジェクト定義（MediatR, AutoMapper, FluentValidation依存）
- E-04: `Src/WebUI/WebUI.csproj` - WebUI層プロジェクト定義（ASP.NET Core, NSwag依存）
- E-05: `Src/Infrastructure/Infrastructure.csproj` - Infrastructure層プロジェクト定義
- E-06: `Src/Persistence/Persistence.csproj` - Persistence層プロジェクト定義
- E-07: `Src/Domain/Entities/Customer.cs` - Customerエンティティ定義
- E-08: `Src/Domain/Common/AuditableEntity.cs` - 監査エンティティ基底クラス
- E-09: `Src/Domain/ValueObjects/AdAccount.cs` - 値オブジェクト実装例
- E-10: `Src/Application/Customers/Queries/GetCustomersList/GetCustomersListQuery.cs` - Queryクラス例
- E-11: `Src/Application/Customers/Queries/GetCustomersList/GetCustomersListQueryHandler.cs` - Handlerクラス例
- E-12: `Src/Application/Customers/Queries/GetCustomersList/CustomerLookupDto.cs` - DTOクラス例
- E-13: `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommand.cs` - Commandクラス例
- E-14: `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommandValidator.cs` - Validatorクラス例
- E-15: `Src/Application/Common/Behaviours/RequestValidationBehavior.cs` - バリデーションパイプライン
- E-16: `Src/Application/Common/Mappings/IMapFrom.cs` - AutoMapperインターフェース
- E-17: `Src/Application/DependencyInjection.cs` - Application層DI設定
- E-18: `Src/Application/Common/Interfaces/INorthwindDbContext.cs` - DbContextインターフェース
- E-19: `Src/Persistence/NorthwindDbContext.cs` - DbContext実装
- E-20: `Src/Persistence/DependencyInjection.cs` - Persistence層DI設定
- E-21: `Src/Persistence/Configurations/CustomerConfiguration.cs` - EF Core設定例
- E-22: `Src/Infrastructure/DependencyInjection.cs` - Infrastructure層DI設定
- E-23: `Src/WebUI/Controllers/CustomersController.cs` - APIコントローラー例
- E-24: `Src/WebUI/Controllers/BaseController.cs` - 基底コントローラー
- E-25: `Src/WebUI/Startup.cs` - アプリケーション設定
- E-26: `Src/WebUI/Program.cs` - エントリーポイント
- E-27: `README.md` - プロジェクト概要

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクトはC#/.NET Core 3.0を使用 | E-02, E-03, E-04 | ○ |
| C-02 | Clean Architectureを採用 | E-01, E-02, E-03, E-05, E-06 | ○ |
| C-03 | Domain層は外部依存がない | E-02 | ○ |
| C-04 | MediatRを使用したCQRSパターン | E-03, E-10, E-11, E-13 | ○ |
| C-05 | FluentValidationでバリデーション | E-03, E-14, E-15 | ○ |
| C-06 | AutoMapperでオブジェクトマッピング | E-03, E-12, E-16 | ○ |
| C-07 | Entity Framework Coreでデータアクセス | E-03, E-18, E-19, E-21 | ○ |
| C-08 | CustomerエンティティにCustomerId, CompanyName等のプロパティ | E-07 | ○ |
| C-09 | AuditableEntityでCreatedBy, Created等の監査情報 | E-08 | ○ |
| C-10 | ValueObjectパターンの実装（AdAccount） | E-09 | ○ |
| C-11 | QueryはIRequest<TResponse>を継承 | E-10 | ○ |
| C-12 | CommandはIRequestを継承 | E-13 | ○ |
| C-13 | HandlerはIRequestHandlerを実装 | E-11, E-13 | ○ |
| C-14 | DTOはIMapFromインターフェースを実装 | E-12, E-16 | ○ |
| C-15 | ValidatorはAbstractValidatorを継承 | E-14 | ○ |
| C-16 | RuleForでバリデーションルールを定義 | E-14 | ○ |
| C-17 | RequestValidationBehaviorがパイプラインで実行 | E-15, E-17 | ○ |
| C-18 | INorthwindDbContextでDbSetを定義 | E-18 | ○ |
| C-19 | NorthwindDbContextがINorthwindDbContextを実装 | E-19 | ○ |
| C-20 | SaveChangesAsyncで監査情報を自動設定 | E-19 | ○ |
| C-21 | IEntityTypeConfigurationでEF Core設定 | E-21 | ○ |
| C-22 | DependencyInjectionクラスで拡張メソッド定義 | E-17, E-20, E-22 | ○ |
| C-23 | ControllerはBaseControllerを継承 | E-23, E-24 | ○ |
| C-24 | BaseControllerにMediatorプロパティ | E-24 | ○ |
| C-25 | [ApiController]と[Route]属性を使用 | E-24 | ○ |
| C-26 | [Authorize]属性で認証を要求 | E-23 | ○ |
| C-27 | [HttpGet], [HttpPost]等でHTTPメソッド指定 | E-23 | ○ |
| C-28 | Startup.csでDI設定を集約 | E-25 | ○ |
| C-29 | AddApplication(), AddPersistence(), AddInfrastructure()で各層登録 | E-25 | ○ |
| C-30 | Program.csがエントリーポイント | E-26 | ○ |
| C-31 | 起動時にデータベースマイグレーション実行 | E-26 | ○ |
| C-32 | SeedSampleDataCommandでサンプルデータ投入 | E-26 | ○ |
| C-33 | IdentityServerで認証・認可 | E-22, E-25 | ○ |
| C-34 | CsvFileBuilderでCSVファイル生成 | E-22 | ○ |
| C-35 | 命名規則: {Entity}Controller.cs | E-23 | ○ |
| C-36 | 命名規則: Get{Entity}ListQuery.cs | E-10 | ○ |
| C-37 | 命名規則: Create{Entity}Command.cs | E-13 | ○ |
| C-38 | 命名規則: {Entity}Configuration.cs | E-21 | ○ |
| C-39 | 命名規則: {Name}Dto.cs | E-12 | ○ |
| C-40 | 命名規則: I{Name}でインターフェース | E-18 | ○ |
| C-41 | 命名規則: _{name}でプライベートフィールド | E-11, E-19 | ○ |
| C-42 | ディレクトリ構造: Src/Domain/Entities | E-07 | ○ |
| C-43 | ディレクトリ構造: Src/Application/{Entity}/Commands | E-13 | ○ |
| C-44 | ディレクトリ構造: Src/Application/{Entity}/Queries | E-10 | ○ |
| C-45 | ディレクトリ構造: Src/Persistence/Configurations | E-21 | ○ |
| C-46 | ディレクトリ構造: Src/WebUI/Controllers | E-23 | ○ |
| C-47 | 顧客一覧取得のフロー（Controller -> MediatR -> Handler） | E-23, E-11 | ○ |
| C-48 | 顧客作成のフロー（Controller -> Validation -> Handler） | E-23, E-13, E-14, E-15 | ○ |
| C-49 | プロジェクトはアーカイブ済み | E-27 | ○ |
| C-50 | 最新版はClean Architecture Solution Template | E-27 | ○ |
| C-51 | フロントエンドはAngular SPAを使用 | E-04, E-25 | △ |
| C-52 | NotificationServiceで通知機能を実装 | E-22 | △ |

## 4) 不足情報（Unknown / Missing）
- **Angular SPAの詳細構成**: ClientAppディレクトリの詳細な分析は行っていない
  - 候補：ClientApp/src/app/の構成を確認
- **NotificationServiceの実装詳細**: インターフェース登録は確認したが、実際の通知ロジックは未確認
  - 候補：Src/Infrastructure/NotificationService.csの内容を確認

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: Domain層、Application層の構造と主要パターン
- **0 (低リスク)**: 命名規則と構成
- **0 (低リスク)**: データアクセス層の実装
- **1 (中リスク)**: フロントエンド（Angular）の詳細 - WebUI.csprojでの参照は確認済みだが詳細未確認

## 6) レビュアーチェックリスト（最小）
- [ ] Clean Architectureの依存関係方向が正しく説明されているか
- [ ] MediatR/CQRSパターンの説明が実装と一致するか
- [ ] FluentValidationのパイプライン統合の説明が正確か
- [ ] 命名規則が実際のファイル名と一致するか
- [ ] 業務フロー追跡例が実装と整合しているか
- [ ] Angular SPA部分の説明について、実装との整合性確認が必要
