# インフラ構成図

## 1. システム全体構成図

```
+------------------------------------------------------------------+
|                        Azure Cloud                                 |
+------------------------------------------------------------------+
|                                                                    |
|  +------------------------+    +-----------------------------+     |
|  |   Azure DevOps         |    |    Azure App Service        |     |
|  |                        |    |                             |     |
|  |  +------------------+  |    |  +----------------------+   |     |
|  |  | Azure Pipelines  |------>|  | Northwind.WebUI      |   |     |
|  |  | (CI/CD)          |  |    |  | (ASP.NET Core 3.0)   |   |     |
|  |  +------------------+  |    |  +----------+-----------+   |     |
|  |                        |    |             |               |     |
|  +------------------------+    |             | HTTPS/443     |     |
|                                |             |               |     |
|                                +-----------------------------+     |
|                                              |                     |
|                                              |                     |
|                                +-------------v--------------+      |
|                                |    Azure SQL Database       |      |
|                                |                             |      |
|                                |  +----------------------+   |      |
|                                |  | NorthwindTraders DB  |   |      |
|                                |  | - Business Data      |   |      |
|                                |  | - Identity Data      |   |      |
|                                |  +----------------------+   |      |
|                                |                             |      |
|                                +-----------------------------+      |
|                                                                    |
+------------------------------------------------------------------+
                                   |
                                   | HTTPS/443
                                   v
+------------------------------------------------------------------+
|                         Clients                                   |
|                                                                   |
|   +-------------------+   +-------------------+   +------------+  |
|   |  Web Browser      |   |  Mobile Browser   |   | API Client |  |
|   |  (Angular SPA)    |   |  (Angular SPA)    |   | (REST API) |  |
|   +-------------------+   +-------------------+   +------------+  |
|                                                                   |
+------------------------------------------------------------------+
```

---

## 2. アプリケーションアーキテクチャ

```
+------------------------------------------------------------------+
|                    Northwind Traders Application                  |
+------------------------------------------------------------------+
|                                                                    |
|  +---------------------+  Presentation Layer                       |
|  |                     |                                           |
|  |      WebUI          |  ASP.NET Core 3.0 Web Application        |
|  |                     |  - Controllers (REST API)                 |
|  |  +---------------+  |  - Razor Pages                            |
|  |  | Angular SPA   |  |  - Static Files                           |
|  |  | (ClientApp)   |  |  - Health Checks                          |
|  |  +---------------+  |  - Swagger/OpenAPI                        |
|  |                     |                                           |
|  +----------+----------+                                           |
|             |                                                      |
|             | DI                                                   |
|             v                                                      |
|  +---------------------+  Infrastructure Layer                     |
|  |                     |                                           |
|  |   Infrastructure    |  - IdentityServer4 (Authentication)       |
|  |                     |  - ASP.NET Core Identity                  |
|  |                     |  - Notification Service                   |
|  |                     |  - CSV File Builder                       |
|  |                     |  - DateTime Service                       |
|  +----------+----------+                                           |
|             |                                                      |
|  +----------v----------+                                           |
|  |                     |                                           |
|  |    Persistence      |  - Entity Framework Core                  |
|  |                     |  - NorthwindDbContext                     |
|  |                     |  - ApplicationDbContext (Identity)        |
|  |                     |  - Migrations                             |
|  +----------+----------+                                           |
|             |                                                      |
|             | DI                                                   |
|             v                                                      |
|  +---------------------+  Application Layer                        |
|  |                     |                                           |
|  |    Application      |  - MediatR (CQRS)                         |
|  |                     |  - AutoMapper                             |
|  |                     |  - FluentValidation                       |
|  |                     |  - Business Logic                         |
|  +----------+----------+                                           |
|             |                                                      |
|             | Reference                                            |
|             v                                                      |
|  +---------------------+  Domain Layer                             |
|  |                     |                                           |
|  |      Domain         |  - Entities                               |
|  |                     |  - Value Objects                          |
|  |                     |  - Domain Events                          |
|  |                     |  - Domain Logic                           |
|  +---------------------+                                           |
|                                                                    |
|  +---------------------+  Shared                                   |
|  |      Common         |  - IDateTime Interface                    |
|  +---------------------+                                           |
|                                                                    |
+------------------------------------------------------------------+
```

---

## 3. データフロー図

```
+--------+         +-------------+         +------------------+
| Client |  HTTPS  |   WebUI     |         |   Database       |
| (SPA)  |-------->| (Kestrel)   |         | (SQL Server)     |
+--------+         +------+------+         +--------+---------+
    ^                     |                         ^
    |                     |                         |
    |                     v                         |
    |              +------+------+                  |
    |              |  MediatR    |                  |
    |              |  (CQRS)     |                  |
    |              +------+------+                  |
    |                     |                         |
    |                     v                         |
    |              +------+------+                  |
    |              | Application |                  |
    |              |   Layer     |                  |
    |              +------+------+                  |
    |                     |                         |
    |                     v                         |
    |              +------+------+                  |
    |              |   EF Core   |----------------->|
    |              | DbContext   |<-----------------|
    |              +-------------+                  |
    |                                               |
    +<---------- JSON Response ---------------------+
```

### 3.1 リクエスト処理フロー

```
1. クライアントリクエスト
   |
   v
2. Kestrel Web Server (HTTPS)
   |
   v
3. Middleware Pipeline
   |
   +-- Exception Handling
   +-- Health Checks (/health)
   +-- HTTPS Redirection
   +-- Static Files
   +-- Authentication
   +-- Authorization
   |
   v
4. Controller / API Endpoint
   |
   v
5. MediatR Send (Command/Query)
   |
   v
6. Handler (Business Logic)
   |
   v
7. Entity Framework Core
   |
   v
8. SQL Server Database
   |
   v
9. Response (JSON)
```

---

## 4. 認証フロー

```
+--------+                  +-------------+                  +---------------+
| Client |                  |   WebUI     |                  | IdentityServer|
| (SPA)  |                  |             |                  |     4         |
+---+----+                  +------+------+                  +-------+-------+
    |                              |                                 |
    | 1. Access Protected Resource |                                 |
    |----------------------------->|                                 |
    |                              |                                 |
    | 2. Redirect to Login         |                                 |
    |<-----------------------------|                                 |
    |                              |                                 |
    | 3. Authorization Request     |                                 |
    |-------------------------------------------------------------->|
    |                              |                                 |
    | 4. Login Page                |                                 |
    |<--------------------------------------------------------------|
    |                              |                                 |
    | 5. User Credentials          |                                 |
    |-------------------------------------------------------------->|
    |                              |                                 |
    | 6. Authorization Code        |                                 |
    |<--------------------------------------------------------------|
    |                              |                                 |
    | 7. Token Request (Code)      |                                 |
    |-------------------------------------------------------------->|
    |                              |                                 |
    | 8. Access Token + ID Token   |                                 |
    |<--------------------------------------------------------------|
    |                              |                                 |
    | 9. API Request with Token    |                                 |
    |----------------------------->|                                 |
    |                              | 10. Validate Token              |
    |                              |-------------------------------->|
    |                              |                                 |
    |                              | 11. Token Valid                 |
    |                              |<--------------------------------|
    |                              |                                 |
    | 12. API Response             |                                 |
    |<-----------------------------|                                 |
    |                              |                                 |
```

---

## 5. CI/CD パイプライン図

```
+------------------------------------------------------------------+
|                      Azure DevOps Pipeline                        |
+------------------------------------------------------------------+
|                                                                    |
|  +-------------------+                                             |
|  |   Source Code     |                                             |
|  |   (GitHub/Azure   |                                             |
|  |    Repos)         |                                             |
|  +--------+----------+                                             |
|           |                                                        |
|           | Trigger: push to master                                |
|           v                                                        |
|  +-------------------+                                             |
|  |   Build Agent     |  ubuntu-latest                              |
|  |                   |                                             |
|  +--------+----------+                                             |
|           |                                                        |
|           v                                                        |
|  +-------------------+                                             |
|  | 1. Install SDK    |  .NET Core 3.0.100                          |
|  +--------+----------+                                             |
|           |                                                        |
|           v                                                        |
|  +-------------------+                                             |
|  | 2. Build          |  dotnet build --configuration Release       |
|  +--------+----------+                                             |
|           |                                                        |
|           v                                                        |
|  +-------------------+                                             |
|  | 3. Publish        |  dotnet publish                             |
|  |                   |  --self-contained                           |
|  |                   |  --runtime win-x86                          |
|  +--------+----------+                                             |
|           |                                                        |
|           v                                                        |
|  +-------------------+                                             |
|  | 4. Create Artifact|  ZIP Package                                |
|  +--------+----------+                                             |
|           |                                                        |
|           v                                                        |
|  +-------------------+                                             |
|  | 5. Publish        |  Artifact: 'Drop'                           |
|  |    Artifact       |                                             |
|  +-------------------+                                             |
|                                                                    |
+------------------------------------------------------------------+
           |
           | Deploy (Release Pipeline - 要別途設定)
           v
+------------------------------------------------------------------+
|                      Azure App Service                            |
+------------------------------------------------------------------+
```

---

## 6. データベーススキーマ概要

```
+------------------------------------------------------------------+
|                    NorthwindTraders Database                      |
+------------------------------------------------------------------+
|                                                                    |
|  +---------------+     +---------------+     +---------------+     |
|  |  Categories   |     |   Products    |     |  Suppliers    |     |
|  +-------+-------+     +-------+-------+     +-------+-------+     |
|          |                     |                     |             |
|          |      1:N            |       N:1           |             |
|          +-------------------->|<--------------------+             |
|                                |                                   |
|                                |                                   |
|                    +-----------+-----------+                       |
|                    |                       |                       |
|                    v                       v                       |
|            +-------+-------+       +-------+-------+               |
|            |  OrderDetails |       |    Orders     |               |
|            +---------------+       +-------+-------+               |
|                    ^                       |                       |
|                    |         N:1           |                       |
|                    +-----------------------+                       |
|                                            |                       |
|                    +--------+--------------+----------+            |
|                    |        |                         |            |
|                    v        v                         v            |
|            +-------+--+ +---+------+          +-------+-------+    |
|            | Customers| | Employees|          |   Shippers    |    |
|            +----------+ +----+-----+          +---------------+    |
|                              |                                     |
|                              | N:M                                 |
|                              v                                     |
|                    +-------------------+                           |
|                    |EmployeeTerritories|                           |
|                    +---------+---------+                           |
|                              |                                     |
|                              v                                     |
|                    +-------------------+                           |
|                    |   Territories     |                           |
|                    +---------+---------+                           |
|                              |                                     |
|                              | N:1                                 |
|                              v                                     |
|                    +-------------------+                           |
|                    |      Region       |                           |
|                    +-------------------+                           |
|                                                                    |
+------------------------------------------------------------------+
```

---

## 7. ネットワーク構成図

```
+------------------------------------------------------------------+
|                      Internet                                     |
+------------------------------------------------------------------+
                              |
                              | HTTPS (443)
                              v
+------------------------------------------------------------------+
|                      Azure Load Balancer                          |
|                      / Application Gateway                        |
+------------------------------------------------------------------+
                              |
                              | Internal
                              v
+------------------------------------------------------------------+
|                      Virtual Network                              |
+------------------------------------------------------------------+
|                                                                    |
|   +-------------------+        +-------------------+               |
|   |   Subnet: Web     |        |   Subnet: Data    |               |
|   |                   |        |                   |               |
|   | +---------------+ |        | +---------------+ |               |
|   | | App Service   | |        | | Azure SQL     | |               |
|   | | (WebUI)       | |------->| | Database      | |               |
|   | | Port: 443     | |  1433  | | Port: 1433    | |               |
|   | +---------------+ |        | +---------------+ |               |
|   |                   |        |                   |               |
|   +-------------------+        +-------------------+               |
|                                                                    |
+------------------------------------------------------------------+
```

---

## 8. 開発環境構成図

```
+------------------------------------------------------------------+
|                    Developer Workstation                          |
+------------------------------------------------------------------+
|                                                                    |
|  +-------------------+  +-------------------+  +----------------+  |
|  |  Visual Studio    |  |   Node.js         |  | SQL Server     |  |
|  |  2019+            |  |   10.x+           |  | LocalDB        |  |
|  +--------+----------+  +--------+----------+  +-------+--------+  |
|           |                      |                     |           |
|           v                      v                     |           |
|  +-------------------+  +-------------------+          |           |
|  | .NET Core SDK     |  |  Angular CLI      |          |           |
|  | 3.0.100           |  |  8.3.3            |          |           |
|  +--------+----------+  +--------+----------+          |           |
|           |                      |                     |           |
|           +----------------------+                     |           |
|                      |                                 |           |
|                      v                                 |           |
|           +----------+----------+                      |           |
|           |  Northwind.WebUI    |<---------------------+           |
|           |                     |                                  |
|           |  https://localhost: |                                  |
|           |    44376            |                                  |
|           |  http://localhost:  |                                  |
|           |    54608            |                                  |
|           +---------------------+                                  |
|                      |                                             |
|                      | Proxy                                       |
|                      v                                             |
|           +---------------------+                                  |
|           |  Angular Dev Server |                                  |
|           |  http://localhost:  |                                  |
|           |    4200             |                                  |
|           +---------------------+                                  |
|                                                                    |
+------------------------------------------------------------------+
```

---

## 9. テスト環境構成図

```
+------------------------------------------------------------------+
|                      Test Environment                             |
+------------------------------------------------------------------+
|                                                                    |
|  +------------------------+                                        |
|  |   Unit Tests           |                                        |
|  |                        |                                        |
|  |  - Application.        |     In-Memory                          |
|  |    UnitTests           |     Test Database                      |
|  |  - Domain.UnitTests    |                                        |
|  +------------------------+                                        |
|                                                                    |
|  +------------------------+                                        |
|  |   Integration Tests    |                                        |
|  |                        |                                        |
|  |  - WebUI.              |     SQL Server                         |
|  |    IntegrationTests    |---->  LocalDB (Test)                   |
|  |  - Persistence.        |                                        |
|  |    IntegrationTests    |     Test IdentityServer                |
|  +------------------------+     Client Configuration               |
|                                                                    |
|  +------------------------+                                        |
|  |   E2E Tests            |                                        |
|  |                        |                                        |
|  |  - Protractor          |---->  Full Application                 |
|  |  - Angular E2E         |       + Test Database                  |
|  +------------------------+                                        |
|                                                                    |
+------------------------------------------------------------------+
```

---

## 10. 監視・ログ構成図

```
+------------------------------------------------------------------+
|                   Monitoring Architecture                         |
+------------------------------------------------------------------+
|                                                                    |
|  +-------------------+                                             |
|  |   Application     |                                             |
|  +--------+----------+                                             |
|           |                                                        |
|           | Logs/Metrics                                           |
|           v                                                        |
|  +-------------------+     +-------------------+                    |
|  |   Health Check    |     |    Logging        |                    |
|  |   /health         |     |                   |                    |
|  |                   |     |  - Console        |                    |
|  |  - DbContext      |     |  - Debug          |                    |
|  |    Connectivity   |     |  - (App Insights) |                    |
|  +-------------------+     +-------------------+                    |
|                                    |                               |
|                                    v                               |
|                           +-------------------+                    |
|                           | Log Aggregation   |                    |
|                           | (Azure Monitor /  |                    |
|                           |  Application      |                    |
|                           |  Insights)        |                    |
|                           +--------+----------+                    |
|                                    |                               |
|                                    v                               |
|                           +-------------------+                    |
|                           |   Dashboard       |                    |
|                           |   & Alerts        |                    |
|                           +-------------------+                    |
|                                                                    |
+------------------------------------------------------------------+
```

---

## 改訂履歴

| 版 | 日付 | 変更内容 | 作成者 |
|----|------|---------|--------|
| 1.0 | 2026-01-07 | 初版作成 | Claude Code |
