---
generated_at: 2026-01-07 23:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成されたセキュリティ設計書の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **EmployeesControllerの認可設定**：コード確認が必要
  2. **CORS設定が未実装**：セキュリティ観点での要確認
  3. **CSP設定が未実装**：セキュリティ観点での要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Startup.cs` - アプリケーション構成
- E-02: `Src/Infrastructure/DependencyInjection.cs` - 認証・認可設定
- E-03: `Src/Infrastructure/Identity/ApplicationUser.cs` - ユーザーエンティティ
- E-04: `Src/Infrastructure/Identity/ApplicationDbContext.cs` - 認証データベースコンテキスト
- E-05: `Src/Infrastructure/Identity/UserManagerService.cs` - ユーザー管理サービス
- E-06: `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs` - ログイン処理
- E-07: `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml.cs` - ユーザー登録処理
- E-08: `Src/WebUI/Controllers/BaseController.cs` - 基底コントローラー
- E-09: `Src/WebUI/Controllers/ProductsController.cs` - 製品コントローラー
- E-10: `Src/WebUI/Controllers/CustomersController.cs` - 顧客コントローラー
- E-11: `Src/WebUI/Services/CurrentUserService.cs` - 現在ユーザーサービス
- E-12: `Src/Application/Common/Behaviours/RequestValidationBehavior.cs` - 検証パイプライン
- E-13: `Src/Application/Common/Behaviours/RequestLogger.cs` - リクエストログ
- E-14: `Src/Application/Common/Behaviours/RequestPerformanceBehaviour.cs` - パフォーマンス監視
- E-15: `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommandValidator.cs` - 顧客作成検証
- E-16: `Src/Application/Customers/Commands/UpdateCustomer/UpdateCustomerCommandValidator.cs` - 顧客更新検証
- E-17: `Src/WebUI/Common/CustomExceptionHandlerMiddleware.cs` - 例外ハンドラー
- E-18: `Src/Application/Common/Exceptions/ValidationException.cs` - 検証例外
- E-19: `Src/Domain/Common/AuditableEntity.cs` - 監査エンティティ
- E-20: `Src/Persistence/NorthwindDbContext.cs` - データベースコンテキスト
- E-21: `Src/WebUI/appsettings.json` - 基本設定
- E-22: `Src/WebUI/appsettings.Production.json` - 本番環境設定
- E-23: `Src/WebUI/WebUI.csproj` - プロジェクト設定
- E-24: `Src/WebUI/ClientApp/src/api-authorization/authorize.service.ts` - 認証サービス（Angular）
- E-25: `Src/WebUI/ClientApp/src/api-authorization/authorize.interceptor.ts` - 認証インターセプター（Angular）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ASP.NET Core Identityによる認証基盤 | E-02, E-03, E-04 | ○ |
| C-02 | IdentityServer4によるOAuth2/OIDC認証 | E-02, E-21 | ○ |
| C-03 | JWT Bearer Token認証 | E-02, E-25 | ○ |
| C-04 | oidc-clientによるフロントエンド認証 | E-24 | ○ |
| C-05 | Silent/Popup/Redirect認証フロー | E-24 | ○ |
| C-06 | アカウントロックアウト機能 | E-06 (86行目: lockoutOnFailure: true) | ○ |
| C-07 | Remember Me機能 | E-06 | ○ |
| C-08 | パスワード最小6文字/最大100文字 | E-07 (55行目) | ○ |
| C-09 | ProductsControllerに[Authorize]属性 | E-09 (14行目) | ○ |
| C-10 | CustomersControllerに[Authorize]属性 | E-10 (13行目) | ○ |
| C-11 | 製品一覧/詳細がAllowAnonymous | E-09 (18, 27行目) | ○ |
| C-12 | ICurrentUserServiceによるユーザー情報取得 | E-11 | ○ |
| C-13 | HTTPS強制（UseHttpsRedirection） | E-01 (91行目) | ○ |
| C-14 | HSTS有効（本番環境） | E-01 (86行目) | ○ |
| C-15 | 同一オリジンチェック | E-25 | ○ |
| C-16 | User Secrets設定 | E-23 (UserSecretsId) | ○ |
| C-17 | 環境変数による設定 | E-01 (Program.cs: AddEnvironmentVariables) | ○ |
| C-18 | 本番環境での証明書ストア使用 | E-22 | ○ |
| C-19 | Entity Framework Coreによるパラメータ化クエリ | E-20 | ○ |
| C-20 | FluentValidationによる入力検証 | E-12, E-15, E-16, E-23 | ○ |
| C-21 | RequestValidationBehaviorパイプライン | E-12 | ○ |
| C-22 | CustomExceptionHandlerMiddleware実装 | E-17 | ○ |
| C-23 | ValidationExceptionの400応答 | E-17, E-18 | ○ |
| C-24 | RequestLoggerによるリクエストログ | E-13 | ○ |
| C-25 | RequestPerformanceBehaviourによる性能監視 | E-14 | ○ |
| C-26 | AuditableEntityによる変更監査 | E-19, E-20 | ○ |
| C-27 | 認証ログ記録（ログイン成功/失敗） | E-06 (89, 98行目) | ○ |
| C-28 | ユーザー作成ログ記録 | E-07 (82行目) | ○ |
| C-29 | 開発環境でのDeveloperExceptionPage | E-01 (78行目) | ○ |
| C-30 | テストユーザー設定 | E-02 (46-58行目) | ○ |
| C-31 | HtmlEncoderによるXSS対策 | E-06 (135行目), E-07 (93行目) | ○ |
| C-32 | Razor PagesのAntiForgeryToken | **根拠なし** | △ |
| C-33 | EmployeesControllerの認可設定 | **根拠なし** | △ |
| C-34 | CORS設定の有無 | **根拠なし**（実装なし） | △ |
| C-35 | CSP設定の有無 | **根拠なし**（実装なし） | △ |

## 4) 不足情報（Unknown / Missing）
- **C-32（Razor PagesのAntiForgeryToken）**: ASP.NET Core Razor Pages標準機能であるが、明示的な設定箇所の確認が必要
  - 候補：`_ViewImports.cshtml` / `Startup.cs`でのサービス設定 / フォームタグヘルパー
- **C-33（EmployeesControllerの認可設定）**: `EmployeesController.cs`のコード確認が必要
  - 候補：`[Authorize]`属性 / `[AllowAnonymous]`属性
- **C-34, C-35（CORS/CSP設定）**: コードベース検索で設定が見つからなかった
  - 候補：`Startup.cs`でのミドルウェア設定 / appsettings.jsonでの設定

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - C-32（Razor Pages標準機能のため、暗黙的に有効）
- **1: 中リスク** - C-33（EmployeesController認可確認必要）
- **2: 高リスク** - C-34, C-35（CORS/CSP未実装はセキュリティリスク）

## 6) レビュアーチェックリスト（最小）
- [ ] EmployeesControllerの`[Authorize]`属性を確認
- [ ] 本番環境でのCORS設定要否を確認
- [ ] Content Security Policy導入の検討
- [ ] Razor PagesのAntiForgeryToken動作確認
- [ ] テストユーザー（jason@northwind）が本番環境で無効化されることを確認
- [ ] 本番環境での証明書ストア設定が正しいことを確認
