---
generated_at: 2026-01-07 22:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **カバレッジ目標値（80%/70%）**：明示的な設定ファイルなし
  2. **システムテスト担当「QAチーム」**：組織情報なし
  3. **E2Eテスト・契約テストの推奨**：現状未実装の推奨事項

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Northwind.sln` - ソリューション構成
- E-02: `Tests/Application.UnitTests/Application.UnitTests.csproj` - 単体テスト設定
- E-03: `Tests/Domain.UnitTests/Domain.UnitTests.csproj` - ドメイン単体テスト設定
- E-04: `Tests/WebUI.IntegrationTests/WebUI.IntegrationTests.csproj` - Web結合テスト設定
- E-05: `Tests/Persistence.IntegrationTests/Persistence.IntegrationTests.csproj` - 永続化結合テスト設定
- E-06: `azure-pipelines.yml` - CI/CDパイプライン設定
- E-07: `Tests/Application.UnitTests/Common/NorthwindContextFactory.cs` - テストデータファクトリ
- E-08: `Tests/Application.UnitTests/Common/CommandTestBase.cs` - コマンドテスト基底クラス
- E-09: `Tests/Application.UnitTests/Common/QueryTestFixture.cs` - クエリテストフィクスチャ
- E-10: `Tests/WebUI.IntegrationTests/Common/CustomWebApplicationFactory.cs` - Web統合テストファクトリ
- E-11: `Tests/Application.UnitTests/Customers/Queries/GetCustomersListQueryHandlerTests.cs` - クエリハンドラーテスト例
- E-12: `Tests/Domain.UnitTests/ValueObjects/AdAccountTests.cs` - ValueObjectテスト例
- E-13: `Tests/Persistence.IntegrationTests/NorthwindDbContextTests.cs` - DbContextテスト例
- E-14: `Tests/WebUI.IntegrationTests/Controllers/Products/GetAll.cs` - APIテスト例
- E-15: `Src/Application/Common/Behaviours/RequestPerformanceBehaviour.cs` - パフォーマンス計測
- E-16: `README.md` - プロジェクト概要

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | .NET Core 3.0アプリケーションである | E-02, E-03, E-04, E-05 (TargetFramework: netcoreapp3.0) | ○ |
| C-02 | xUnit 2.4.0-2.4.1を使用 | E-02 (2.4.1), E-03 (2.4.1), E-04 (2.4.1), E-05 (2.4.0) | ○ |
| C-03 | Moq 4.13.0を使用 | E-02, E-05 (PackageReference: Moq 4.13.0) | ○ |
| C-04 | Shouldly 3.0.2を使用 | E-02, E-05 (PackageReference: Shouldly 3.0.2) | ○ |
| C-05 | Microsoft.NET.Test.Sdk 16.2.0-16.3.0を使用 | E-02 (16.3.0), E-03 (16.3.0), E-04 (16.3.0), E-05 (16.2.0) | ○ |
| C-06 | EntityFramework InMemoryを使用 | E-02, E-04, E-05 (PackageReference: Microsoft.EntityFrameworkCore.InMemory) | ○ |
| C-07 | Microsoft.AspNetCore.Mvc.Testing 3.0.0を使用 | E-04 (PackageReference: 3.0.0) | ○ |
| C-08 | coverlet.collector 1.0.1を使用 | E-05 (PackageReference: 1.0.1) | ○ |
| C-09 | 4つのテストプロジェクトが存在 | E-01 (ソリューション構成) | ○ |
| C-10 | Application.UnitTestsがApplication層をテスト | E-02 (ProjectReference: Application.csproj) | ○ |
| C-11 | Domain.UnitTestsがDomain層をテスト | E-03 (ProjectReference: Domain.csproj) | ○ |
| C-12 | Persistence.IntegrationTestsがPersistence層をテスト | E-05 (ProjectReference: Persistence.csproj) | ○ |
| C-13 | WebUI.IntegrationTestsがWebUI層をテスト | E-04 (ProjectReference: WebUI.csproj) | ○ |
| C-14 | NorthwindContextFactoryでテストデータ生成 | E-07 (UseInMemoryDatabase, Customers.AddRange) | ○ |
| C-15 | 標準テストデータにADAM, JASON, BRENDが含まれる | E-07 (CustomerId: "ADAM", "JASON", "BREND") | ○ |
| C-16 | IClassFixtureでテストフィクスチャを使用 | E-14 (IClassFixture<CustomWebApplicationFactory<Startup>>) | ○ |
| C-17 | [Collection]属性でコンテキスト共有 | E-11 ([Collection("QueryCollection")]) | ○ |
| C-18 | CustomWebApplicationFactoryで認証テスト | E-10 (GetAuthenticatedClientAsync, GetAnonymousClient) | ○ |
| C-19 | 認証ユーザー名は"jason@northwind" | E-10 (GetAuthenticatedClientAsync: "jason@northwind", "Northwind1!") | ○ |
| C-20 | IdentityServer4ベースの認証 | E-10 (GetDiscoveryDocumentAsync, RequestPasswordTokenAsync) | ○ |
| C-21 | Azure Pipelinesを使用 | E-06 (azure-pipelines.yml存在) | ○ |
| C-22 | ubuntu-latestで実行 | E-06 (vmImage: 'ubuntu-latest') | ○ |
| C-23 | masterブランチでトリガー | E-06 (trigger: - master) | ○ |
| C-24 | Releaseビルド構成 | E-06 (buildConfiguration: 'Release') | ○ |
| C-25 | dotnet buildを実行 | E-06 (dotnet build --configuration $(buildConfiguration)) | ○ |
| C-26 | WebUIをself-containedでパブリッシュ | E-06 (--self-contained --runtime win-x86) | ○ |
| C-27 | 現在のパイプラインにテスト実行なし | E-06 (dotnet testタスクなし) | ○ |
| C-28 | Clean Architecture構成 | E-01, E-16 (Core, Infrastructure, Presentation階層) | ○ |
| C-29 | DbContext Auditingテスト実装あり | E-13 (SetCreatedProperties, SetLastModifiedProperties) | ○ |
| C-30 | ValueObjectテスト実装あり | E-12 (AdAccountTests: Domain, Nameの検証) | ○ |
| C-31 | APIエンドポイントテスト実装あり | E-14 (GetAll: /api/products/getall) | ○ |
| C-32 | RequestPerformanceBehaviourでパフォーマンス計測 | E-15 (ファイル存在確認) | ○ |
| C-33 | 行カバレッジ目標80%、分岐カバレッジ目標70% | **根拠なし** | △ |
| C-34 | システムテスト担当はQAチーム | **根拠なし** | △ |
| C-35 | E2Eテスト・契約テストの推奨 | **根拠なし**（推奨事項として記載） | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標設定ファイル**: coverlet設定や.runsettingsファイルが見つかりません。目標値は業界標準に基づく推奨値として記載しています。
  - 候補：`.runsettings` / `coverlet.runsettings.xml` / `Directory.Build.props`
- **組織・チーム情報**: プロジェクト内に組織構造やチーム編成に関するドキュメントがありません。
  - 候補：`CONTRIBUTING.md` / `CODEOWNERS` / 組織図
- **E2E/契約テストの実装**: 現時点では未実装のため、推奨事項として記載しました。
  - 候補：`Tests/E2E/` / `Tests/Contract/`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テストフレームワーク・ツールの記載（E-02〜E-05で全て確認可能）
- **0（低リスク）**: テストプロジェクト構成（E-01で確認可能）
- **0（低リスク）**: CI/CD設定（E-06で確認可能）
- **1（中リスク）**: カバレッジ目標値（明示的な設定なし、推奨値として記載）
- **1（中リスク）**: CI/CDへのテスト追加推奨（現状未実装）
- **0（低リスク）**: テストデータ・認証テスト（E-07, E-10で確認可能）

## 6) レビュアーチェックリスト（最小）
- [ ] カバレッジ目標値（80%/70%）がプロジェクト方針として妥当か確認
- [ ] CI/CDパイプラインへのテスト実行追加の優先度を確認
- [ ] システムテスト・受入テストの担当者/チームを組織に合わせて修正
- [ ] 現在のテストカバレッジ実測値との乖離を確認
- [ ] E2Eテスト・契約テスト導入の必要性を検討
