# テスト方針書

## 概要

本ドキュメントは、Northwind Tradersプロジェクトにおけるテスト戦略、テストレベル、テストツール、カバレッジ目標、テスト環境、およびCI/CD連携について定義するテスト方針書です。本プロジェクトはClean Architectureに基づいた.NET Core 3.0アプリケーションであり、Domain、Application、Persistence、WebUIの各レイヤーに対して適切なテストを実施します。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々のクラス・メソッドの動作検証。Domain層のValueObject、Application層のQuery/Commandハンドラーの検証 | 開発者 |
| 結合テスト | 複数コンポーネント間の連携検証。Persistence層のDbContext動作、WebUI層のAPIエンドポイント検証 | 開発者 |
| システムテスト | アプリケーション全体の動作検証。E2Eシナリオの確認 | QAチーム |
| 受入テスト | ビジネス要件の充足確認。ユーザーストーリーベースの検証 | プロダクトオーナー/ステークホルダー |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | 各機能が仕様通りに動作することを確認。CRUD操作、クエリ/コマンド処理の検証 | 開発中・PR作成時 |
| 性能テスト | レスポンスタイム、スループットの測定。RequestPerformanceBehaviourによるログ記録 | リリース前 |
| セキュリティテスト | 認証・認可の検証。IdentityServerを使用した認証フロー、APIアクセス制御の確認 | リリース前 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 開発者による単体・結合テスト実行 | InMemoryDatabase、Visual Studio/Rider |
| CI環境 | 自動テスト実行 | Azure Pipelines (ubuntu-latest) |
| テスト環境 | 結合・システムテスト実行 | InMemoryDatabaseを使用したテスト専用環境 |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| xUnit | テストフレームワーク | 2.4.0 - 2.4.1 |
| Moq | モックフレームワーク | 4.13.0 |
| Shouldly | アサーションライブラリ | 3.0.2 |
| Microsoft.NET.Test.Sdk | テスト実行ランナー | 16.2.0 - 16.3.0 |
| Microsoft.EntityFrameworkCore.InMemory | インメモリデータベース | 3.0.0 |
| Microsoft.AspNetCore.Mvc.Testing | Web API結合テスト | 3.0.0 |
| coverlet.collector | コードカバレッジ収集 | 1.0.1 |
| IdentityModel.Client | 認証テスト用クライアント | - |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 80% |
| 分岐カバレッジ | 70% |

### レイヤー別カバレッジ目標

| レイヤー | 行カバレッジ目標 | 備考 |
| --- | --- | --- |
| Domain | 90% | ValueObject、Entityのビジネスロジック |
| Application | 85% | Query/Commandハンドラー、Validator |
| Persistence | 75% | DbContext、Configuration |
| WebUI | 70% | Controller、Middleware |

## テストデータ

### テストデータ準備方針

1. **InMemoryDatabaseの活用**: 単体テスト・結合テストではEntityFramework CoreのInMemoryDatabaseを使用し、テストごとに独立したデータベースインスタンスを生成します。

2. **テストデータファクトリ**: `NorthwindContextFactory`クラスを使用して、標準的なテストデータ（Customers、Orders等）を事前にシードします。

3. **テストフィクスチャ**: xUnitの`IClassFixture`および`[Collection]`属性を使用して、テスト間でコンテキストを共有し、テストの実行効率を向上させます。

4. **認証テストデータ**: `CustomWebApplicationFactory`を使用して、認証済みクライアント（`jason@northwind`）によるAPIテストを実施します。

### 標準テストデータ

- **Customers**: ADAM (Adam Cogan), JASON (Jason Taylor), BREND (Brendan Richards)
- **Orders**: BREND顧客に紐づくサンプルオーダー
- **Products**: Coffee等のサンプル製品データ

## 不具合管理

### 不具合管理プロセス

1. **不具合の発見**: テスト実行時に発見された不具合は、GitHubのIssueとして登録します。

2. **優先度分類**:
   - Critical: アプリケーションが起動しない、データ損失の可能性
   - High: 主要機能が動作しない
   - Medium: 機能は動作するが期待と異なる動作
   - Low: UIの軽微な問題、パフォーマンス改善要望

3. **修正フロー**:
   - Issueに対応するブランチを作成
   - 不具合を再現するテストを作成
   - 修正を実施
   - テストが通過することを確認
   - Pull Requestを作成・レビュー

4. **回帰テスト**: 不具合修正後、関連する機能のテストを再実行し、回帰がないことを確認します。

## CI/CD連携

### Azure Pipelines設定

本プロジェクトでは、Azure Pipelinesを使用してCI/CDパイプラインを構成しています。

**パイプライン構成**:

```yaml
trigger:
- master

pool:
  vmImage: 'ubuntu-latest'

variables:
  buildConfiguration: 'Release'
```

### ビルド・テストステップ

| ステップ | 内容 |
| --- | --- |
| SDK設定 | UseDotNet@2タスクでglobal.jsonに基づいたSDKをインストール |
| ビルド | `dotnet build --configuration Release` |
| パブリッシュ | WebUIプロジェクトをself-contained形式でパブリッシュ |
| アーティファクト | ビルド成果物をDropとして公開 |

### 推奨テスト実行ステップ

現在のパイプラインにはテスト実行ステップが含まれていませんが、以下の追加を推奨します:

```yaml
- task: DotNetCoreCLI@2
  displayName: 'dotnet test'
  inputs:
    command: test
    projects: 'Tests/**/*.csproj'
    arguments: '--configuration $(buildConfiguration) --collect:"XPlat Code Coverage"'

- task: PublishCodeCoverageResults@1
  inputs:
    codeCoverageTool: 'Cobertura'
    summaryFileLocation: '$(Agent.TempDirectory)/**/coverage.cobertura.xml'
```

## テストプロジェクト構成

### 現在のテストプロジェクト

| プロジェクト | 種別 | テスト対象 |
| --- | --- | --- |
| Application.UnitTests | 単体テスト | Application層（Query/Commandハンドラー、Mapping） |
| Domain.UnitTests | 単体テスト | Domain層（ValueObject、Entity） |
| Persistence.IntegrationTests | 結合テスト | Persistence層（DbContext、Auditing） |
| WebUI.IntegrationTests | 結合テスト | WebUI層（APIエンドポイント） |

### テスト実行コマンド

```bash
# 全テスト実行
dotnet test

# 単体テストのみ
dotnet test Tests/Application.UnitTests
dotnet test Tests/Domain.UnitTests

# 結合テストのみ
dotnet test Tests/Persistence.IntegrationTests
dotnet test Tests/WebUI.IntegrationTests

# カバレッジ付き
dotnet test --collect:"XPlat Code Coverage"
```

## 備考

### アーキテクチャとテストの関係

本プロジェクトはClean Architectureに基づいており、各レイヤーの依存関係が明確に分離されています。これにより:

- **Domain層**: 外部依存がなく、純粋な単体テストが可能
- **Application層**: インターフェース経由でのモック注入により、単体テストが容易
- **Persistence層**: InMemoryDatabaseによる結合テストが可能
- **WebUI層**: `WebApplicationFactory`を使用したAPIテストが可能

### 認証・認可テスト

IdentityServer4を使用した認証が実装されており、`CustomWebApplicationFactory`を通じて:
- 匿名クライアント（`GetAnonymousClient`）
- 認証済みクライアント（`GetAuthenticatedClientAsync`）

の両方でAPIテストを実施できます。

### 今後の改善推奨事項

1. **CI/CDへのテスト追加**: 現在のAzure Pipelinesにテスト実行ステップを追加
2. **カバレッジレポート**: CodeCoverage結果の可視化と閾値設定
3. **E2Eテスト**: Selenium/Playwrightを使用したUIテストの追加検討
4. **契約テスト**: APIのバージョニングに備えたContract Testingの導入
