# ER図

## 概要

本ドキュメントは、NorthwindTradersプロジェクトのER図（Entity-Relationship Diagram）をMermaid形式で記載したものです。

## ER図

```mermaid
erDiagram
    Categories {
        int CategoryID PK
        nvarchar CategoryName
        ntext Description
        image Picture
    }

    Customers {
        nvarchar CustomerID PK
        nvarchar CompanyName
        nvarchar ContactName
        nvarchar ContactTitle
        nvarchar Address
        nvarchar City
        nvarchar Region
        nvarchar PostalCode
        nvarchar Country
        nvarchar Phone
        nvarchar Fax
    }

    Employees {
        int EmployeeID PK
        nvarchar UserId
        nvarchar LastName
        nvarchar FirstName
        nvarchar Title
        nvarchar TitleOfCourtesy
        datetime BirthDate
        datetime HireDate
        nvarchar Address
        nvarchar City
        nvarchar Region
        nvarchar PostalCode
        nvarchar Country
        nvarchar HomePhone
        nvarchar Extension
        image Photo
        ntext Notes
        int ReportsTo FK
        nvarchar PhotoPath
        nvarchar CreatedBy
        datetime2 Created
        nvarchar LastModifiedBy
        datetime2 LastModified
    }

    EmployeeTerritories {
        int EmployeeID PK,FK
        nvarchar TerritoryID PK,FK
    }

    OrderDetails {
        int OrderID PK,FK
        int ProductID PK,FK
        money UnitPrice
        smallint Quantity
        real Discount
        nvarchar CreatedBy
        datetime2 Created
        nvarchar LastModifiedBy
        datetime2 LastModified
    }

    Orders {
        int OrderID PK
        nvarchar CustomerID FK
        int EmployeeID FK
        datetime OrderDate
        datetime RequiredDate
        datetime ShippedDate
        int ShipVia FK
        money Freight
        nvarchar ShipName
        nvarchar ShipAddress
        nvarchar ShipCity
        nvarchar ShipRegion
        nvarchar ShipPostalCode
        nvarchar ShipCountry
        nvarchar CreatedBy
        datetime2 Created
        nvarchar LastModifiedBy
        datetime2 LastModified
    }

    Products {
        int ProductID PK
        nvarchar ProductName
        int SupplierID FK
        int CategoryID FK
        nvarchar QuantityPerUnit
        money UnitPrice
        smallint UnitsInStock
        smallint UnitsOnOrder
        smallint ReorderLevel
        bit Discontinued
        nvarchar CreatedBy
        datetime2 Created
        nvarchar LastModifiedBy
        datetime2 LastModified
    }

    Region {
        int RegionID PK
        nvarchar RegionDescription
    }

    Shippers {
        int ShipperID PK
        nvarchar CompanyName
        nvarchar Phone
    }

    Suppliers {
        int SupplierID PK
        nvarchar CompanyName
        nvarchar ContactName
        nvarchar ContactTitle
        nvarchar Address
        nvarchar City
        nvarchar Region
        nvarchar PostalCode
        nvarchar Country
        nvarchar Phone
        nvarchar Fax
        ntext HomePage
    }

    Territories {
        nvarchar TerritoryID PK
        nvarchar TerritoryDescription
        int RegionID FK
    }

    %% リレーションシップ
    Categories ||--o{ Products : "has"
    Suppliers ||--o{ Products : "supplies"

    Customers ||--o{ Orders : "places"
    Employees ||--o{ Orders : "handles"
    Shippers ||--o{ Orders : "ships"

    Orders ||--|{ OrderDetails : "contains"
    Products ||--o{ OrderDetails : "included_in"

    Employees ||--o| Employees : "reports_to"

    Region ||--o{ Territories : "contains"

    Employees ||--|{ EmployeeTerritories : "assigned_to"
    Territories ||--|{ EmployeeTerritories : "assigned_to"
```

## リレーションシップ一覧

| 親テーブル | 子テーブル | リレーション | 説明 |
| --- | --- | --- | --- |
| Categories | Products | 1対多 | 1つのカテゴリに複数の商品が属する |
| Suppliers | Products | 1対多 | 1つの仕入先から複数の商品を仕入れる |
| Customers | Orders | 1対多 | 1人の顧客が複数の注文を行う |
| Employees | Orders | 1対多 | 1人の従業員が複数の注文を担当する |
| Shippers | Orders | 1対多 | 1つの配送業者が複数の注文を配送する |
| Orders | OrderDetails | 1対多 | 1つの注文に複数の明細がある |
| Products | OrderDetails | 1対多 | 1つの商品が複数の注文明細に含まれる |
| Employees | Employees | 自己参照 | 従業員が上司（Manager）を持つ |
| Region | Territories | 1対多 | 1つの地域に複数の担当地域がある |
| Employees | EmployeeTerritories | 1対多 | 1人の従業員に複数の担当地域 |
| Territories | EmployeeTerritories | 1対多 | 1つの担当地域に複数の従業員 |

## 外部キー制約一覧

| 制約名 | テーブル | カラム | 参照テーブル | 参照カラム | 削除動作 |
| --- | --- | --- | --- | --- | --- |
| FK_Employees_Employees | Employees | ReportsTo | Employees | EmployeeID | - |
| FK_EmployeeTerritories_Employees | EmployeeTerritories | EmployeeID | Employees | EmployeeID | ClientSetNull |
| FK_EmployeeTerritories_Territories | EmployeeTerritories | TerritoryID | Territories | TerritoryID | ClientSetNull |
| FK_Order_Details_Orders | Order Details | OrderID | Orders | OrderID | ClientSetNull |
| FK_Order_Details_Products | Order Details | ProductID | Products | ProductID | ClientSetNull |
| FK_Orders_Shippers | Orders | ShipVia | Shippers | ShipperID | - |
| FK_Territories_Region | Territories | RegionID | Region | RegionID | ClientSetNull |

## 補足

### 多対多リレーション

- **Employees - Territories**: EmployeeTerritoriesテーブルを介した多対多リレーション。1人の従業員が複数の担当地域を持ち、1つの担当地域に複数の従業員が割り当てられる。

- **Orders - Products**: OrderDetailsテーブルを介した多対多リレーション。1つの注文に複数の商品が含まれ、1つの商品が複数の注文に含まれる。

### 自己参照リレーション

- **Employees**: ReportsToカラムを使用した自己参照リレーション。従業員の階層構造（上司-部下関係）を表現。
