---
generated_at: 2026-01-07 21:40:00
metrics:
  claims_total: 48
  claims_with_evidence: 48
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：48 / 48、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードから検証済みのため、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/Domain/Entities/Category.cs`
- E-02: `Src/Domain/Entities/Customer.cs`
- E-03: `Src/Domain/Entities/Employee.cs`
- E-04: `Src/Domain/Entities/EmployeeTerritory.cs`
- E-05: `Src/Domain/Entities/Order.cs`
- E-06: `Src/Domain/Entities/OrderDetail.cs`
- E-07: `Src/Domain/Entities/Product.cs`
- E-08: `Src/Domain/Entities/Region.cs`
- E-09: `Src/Domain/Entities/Shipper.cs`
- E-10: `Src/Domain/Entities/Supplier.cs`
- E-11: `Src/Domain/Entities/Territory.cs`
- E-12: `Src/Domain/Common/AuditableEntity.cs`
- E-13: `Src/Persistence/Configurations/CategoryConfiguration.cs`
- E-14: `Src/Persistence/Configurations/CustomerConfiguration.cs`
- E-15: `Src/Persistence/Configurations/EmployeeConfiguration.cs`
- E-16: `Src/Persistence/Configurations/EmployeeTerritoryConfiguration.cs`
- E-17: `Src/Persistence/Configurations/OrderConfiguration.cs`
- E-18: `Src/Persistence/Configurations/OrderDetailConfiguration.cs`
- E-19: `Src/Persistence/Configurations/ProductConfiguration.cs`
- E-20: `Src/Persistence/Configurations/RegionConfiguration.cs`
- E-21: `Src/Persistence/Configurations/ShipperConfiguration.cs`
- E-22: `Src/Persistence/Configurations/SupplierConfiguration.cs`
- E-23: `Src/Persistence/Configurations/TerritoryConfiguration.cs`
- E-24: `Src/Persistence/NorthwindDbContext.cs`
- E-25: `Src/Application/Common/Interfaces/INorthwindDbContext.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### テーブル一覧に関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Categoriesテーブルが存在する | E-01, E-13, E-24 | ○ |
| C-02 | Customersテーブルが存在する | E-02, E-14, E-24 | ○ |
| C-03 | Employeesテーブルが存在する | E-03, E-15, E-24 | ○ |
| C-04 | EmployeeTerritoriesテーブルが存在する | E-04, E-16, E-24 | ○ |
| C-05 | Order Detailsテーブルが存在する | E-06, E-18, E-24 | ○ |
| C-06 | Ordersテーブルが存在する | E-05, E-17, E-24 | ○ |
| C-07 | Productsテーブルが存在する | E-07, E-19, E-24 | ○ |
| C-08 | Regionテーブルが存在する | E-08, E-20, E-24 | ○ |
| C-09 | Shippersテーブルが存在する | E-09, E-21, E-24 | ○ |
| C-10 | Suppliersテーブルが存在する | E-10, E-22, E-24 | ○ |
| C-11 | Territoriesテーブルが存在する | E-11, E-23, E-24 | ○ |

### Categoriesテーブルに関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | CategoryIDが主キーでint型 | E-01, E-13 | ○ |
| C-13 | CategoryNameは必須でnvarchar(15) | E-13 | ○ |
| C-14 | Descriptionはntext型 | E-13 | ○ |
| C-15 | Pictureはimage型 | E-13 | ○ |

### Customersテーブルに関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | CustomerIDは主キーでnvarchar(5)、手動設定 | E-02, E-14 | ○ |
| C-17 | CompanyNameは必須でnvarchar(40) | E-14 | ○ |
| C-18 | 各フィールドの最大長が正しく設定されている | E-14 | ○ |

### Employeesテーブルに関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | EmployeeIDが主キー | E-03, E-15 | ○ |
| C-20 | AuditableEntityを継承している | E-03, E-12 | ○ |
| C-21 | ReportsToで自己参照リレーションがある | E-03, E-15 | ○ |
| C-22 | FK_Employees_Employees制約が存在する | E-15 | ○ |

### EmployeeTerritoriesテーブルに関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | 複合主キー(EmployeeID, TerritoryID) | E-16 | ○ |
| C-24 | 非クラスタ化インデックス | E-16 | ○ |
| C-25 | FK_EmployeeTerritories_Employees制約 | E-16 | ○ |
| C-26 | FK_EmployeeTerritories_Territories制約 | E-16 | ○ |
| C-27 | 削除動作がClientSetNull | E-16 | ○ |

### Order Detailsテーブルに関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | テーブル名が"Order Details" | E-18 | ○ |
| C-29 | 複合主キー(OrderID, ProductID) | E-18 | ○ |
| C-30 | UnitPriceはmoney型 | E-18 | ○ |
| C-31 | Quantityのデフォルト値は1 | E-18 | ○ |
| C-32 | FK_Order_Details_Orders制約 | E-18 | ○ |
| C-33 | FK_Order_Details_Products制約 | E-18 | ○ |

### Ordersテーブルに関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | OrderIDが主キー | E-05, E-17 | ○ |
| C-35 | Freightのデフォルト値は0 | E-17 | ○ |
| C-36 | FK_Orders_Shippers制約 | E-17 | ○ |
| C-37 | AuditableEntityを継承している | E-05, E-12 | ○ |

### Productsテーブルに関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | ProductIDが主キー | E-07, E-19 | ○ |
| C-39 | ProductNameは必須でnvarchar(40) | E-19 | ○ |
| C-40 | 各数値項目のデフォルト値が0 | E-19 | ○ |
| C-41 | AuditableEntityを継承している | E-07, E-12 | ○ |

### その他のテーブルに関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | RegionIDは非クラスタ化インデックスの主キー | E-20 | ○ |
| C-43 | ShipperIDが主キー | E-09, E-21 | ○ |
| C-44 | SupplierIDが主キー | E-10, E-22 | ○ |
| C-45 | TerritoryIDは非クラスタ化インデックスの主キー | E-23 | ○ |
| C-46 | FK_Territories_Region制約 | E-23 | ○ |

### 監査機能に関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | AuditableEntityにCreated, CreatedBy, LastModified, LastModifiedByがある | E-12 | ○ |
| C-48 | NorthwindDbContextのSaveChangesAsyncで監査情報を自動記録 | E-24 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張がソースコードから検証されており、不足情報はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク
  - 全ての設計情報がソースコード（Entityファイル、Configurationファイル）から直接抽出されているため、信頼性は高い

## 6) レビュアーチェックリスト（最小）
- [ ] テーブル一覧が全てのDbSetプロパティと一致しているか確認
- [ ] カラムのデータ型がConfigurationファイルの設定と一致しているか確認
- [ ] 外部キー制約名がConfigurationファイルの設定と一致しているか確認
- [ ] AuditableEntityを継承しているエンティティが正しく記載されているか確認
- [ ] ER図のリレーションシップがEntityファイルのナビゲーションプロパティと一致しているか確認
