# データベース設計書

## 概要

本ドキュメントは、NorthwindTradersプロジェクトのデータベース設計を記載したものです。本システムは、小売業向けの販売管理システムであり、商品、顧客、従業員、注文などの情報を管理します。データベースはEntity Framework Coreを使用してSQL Serverで管理されています。

## テーブル一覧

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| Categories | Category | 商品カテゴリを管理 |
| Customers | Customer | 顧客情報を管理 |
| Employees | Employee | 従業員情報を管理 |
| EmployeeTerritories | EmployeeTerritory | 従業員と担当地域の関連（中間テーブル） |
| Order Details | OrderDetail | 注文明細を管理 |
| Orders | Order | 注文情報を管理 |
| Products | Product | 商品情報を管理 |
| Region | Region | 地域を管理 |
| Shippers | Shipper | 配送業者を管理 |
| Suppliers | Supplier | 仕入先を管理 |
| Territories | Territory | 担当地域を管理 |

## 各テーブル定義

### 1. Categories

商品カテゴリを管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| CategoryID | int | NO | 主キー、自動採番 |
| CategoryName | nvarchar(15) | NO | カテゴリ名 |
| Description | ntext | YES | カテゴリの説明 |
| Picture | image | YES | カテゴリ画像 |

**制約:**
- 主キー: CategoryID

**リレーション:**
- Products: 1対多（1つのカテゴリに複数の商品が属する）

---

### 2. Customers

顧客情報を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| CustomerID | nvarchar(5) | NO | 主キー（手動設定） |
| CompanyName | nvarchar(40) | NO | 会社名 |
| ContactName | nvarchar(30) | YES | 担当者名 |
| ContactTitle | nvarchar(30) | YES | 担当者役職 |
| Address | nvarchar(60) | YES | 住所 |
| City | nvarchar(15) | YES | 市区町村 |
| Region | nvarchar(15) | YES | 地域 |
| PostalCode | nvarchar(10) | YES | 郵便番号 |
| Country | nvarchar(15) | YES | 国 |
| Phone | nvarchar(24) | YES | 電話番号 |
| Fax | nvarchar(24) | YES | FAX番号 |

**制約:**
- 主キー: CustomerID（ValueGeneratedNever）

**リレーション:**
- Orders: 1対多（1つの顧客に複数の注文が紐づく）

---

### 3. Employees

従業員情報を管理するテーブルです。AuditableEntityを継承し、監査情報を持ちます。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| EmployeeID | int | NO | 主キー、自動採番 |
| UserId | nvarchar(max) | YES | ユーザーID（認証用） |
| LastName | nvarchar(20) | NO | 姓 |
| FirstName | nvarchar(10) | NO | 名 |
| Title | nvarchar(30) | YES | 役職 |
| TitleOfCourtesy | nvarchar(25) | YES | 敬称 |
| BirthDate | datetime | YES | 生年月日 |
| HireDate | datetime | YES | 入社日 |
| Address | nvarchar(60) | YES | 住所 |
| City | nvarchar(15) | YES | 市区町村 |
| Region | nvarchar(15) | YES | 地域 |
| PostalCode | nvarchar(10) | YES | 郵便番号 |
| Country | nvarchar(15) | YES | 国 |
| HomePhone | nvarchar(24) | YES | 自宅電話番号 |
| Extension | nvarchar(4) | YES | 内線番号 |
| Photo | image | YES | 写真 |
| Notes | ntext | YES | メモ |
| ReportsTo | int | YES | 上司の従業員ID（自己参照） |
| PhotoPath | nvarchar(255) | YES | 写真のパス |
| CreatedBy | nvarchar(max) | YES | 作成者 |
| Created | datetime2 | NO | 作成日時 |
| LastModifiedBy | nvarchar(max) | YES | 最終更新者 |
| LastModified | datetime2 | YES | 最終更新日時 |

**制約:**
- 主キー: EmployeeID
- 外部キー: FK_Employees_Employees (ReportsTo -> EmployeeID)

**リレーション:**
- Manager (Employee): 自己参照（上司への参照）
- DirectReports (Employee[]): 自己参照（部下への参照）
- EmployeeTerritories: 1対多（1人の従業員に複数の担当地域）
- Orders: 1対多（1人の従業員に複数の注文）

---

### 4. EmployeeTerritories

従業員と担当地域の多対多リレーションを管理する中間テーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| EmployeeID | int | NO | 従業員ID（複合主キー） |
| TerritoryID | nvarchar(20) | NO | 地域ID（複合主キー） |

**制約:**
- 複合主キー: (EmployeeID, TerritoryID)、非クラスタ化インデックス
- 外部キー: FK_EmployeeTerritories_Employees (EmployeeID -> Employees.EmployeeID)
- 外部キー: FK_EmployeeTerritories_Territories (TerritoryID -> Territories.TerritoryID)
- 削除動作: ClientSetNull

**リレーション:**
- Employee: 多対1
- Territory: 多対1

---

### 5. Order Details

注文明細を管理するテーブルです。AuditableEntityを継承し、監査情報を持ちます。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| OrderID | int | NO | 注文ID（複合主キー） |
| ProductID | int | NO | 商品ID（複合主キー） |
| UnitPrice | money | NO | 単価 |
| Quantity | smallint | NO | 数量（デフォルト: 1） |
| Discount | real | NO | 割引率 |
| CreatedBy | nvarchar(max) | YES | 作成者 |
| Created | datetime2 | NO | 作成日時 |
| LastModifiedBy | nvarchar(max) | YES | 最終更新者 |
| LastModified | datetime2 | YES | 最終更新日時 |

**制約:**
- 複合主キー: (OrderID, ProductID)
- 外部キー: FK_Order_Details_Orders (OrderID -> Orders.OrderID)
- 外部キー: FK_Order_Details_Products (ProductID -> Products.ProductID)
- 削除動作: ClientSetNull
- デフォルト値: Quantity = 1

**リレーション:**
- Order: 多対1
- Product: 多対1

---

### 6. Orders

注文情報を管理するテーブルです。AuditableEntityを継承し、監査情報を持ちます。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| OrderID | int | NO | 主キー、自動採番 |
| CustomerID | nvarchar(5) | YES | 顧客ID |
| EmployeeID | int | YES | 担当従業員ID |
| OrderDate | datetime | YES | 注文日 |
| RequiredDate | datetime | YES | 要求納期 |
| ShippedDate | datetime | YES | 出荷日 |
| ShipVia | int | YES | 配送業者ID |
| Freight | money | YES | 運賃（デフォルト: 0） |
| ShipName | nvarchar(40) | YES | 配送先名 |
| ShipAddress | nvarchar(60) | YES | 配送先住所 |
| ShipCity | nvarchar(15) | YES | 配送先市区町村 |
| ShipRegion | nvarchar(15) | YES | 配送先地域 |
| ShipPostalCode | nvarchar(10) | YES | 配送先郵便番号 |
| ShipCountry | nvarchar(15) | YES | 配送先国 |
| CreatedBy | nvarchar(max) | YES | 作成者 |
| Created | datetime2 | NO | 作成日時 |
| LastModifiedBy | nvarchar(max) | YES | 最終更新者 |
| LastModified | datetime2 | YES | 最終更新日時 |

**制約:**
- 主キー: OrderID
- 外部キー: FK_Orders_Shippers (ShipVia -> Shippers.ShipperID)
- デフォルト値: Freight = 0

**リレーション:**
- Customer: 多対1
- Employee: 多対1
- Shipper: 多対1
- OrderDetails: 1対多（1つの注文に複数の明細）

---

### 7. Products

商品情報を管理するテーブルです。AuditableEntityを継承し、監査情報を持ちます。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| ProductID | int | NO | 主キー、自動採番 |
| ProductName | nvarchar(40) | NO | 商品名 |
| SupplierID | int | YES | 仕入先ID |
| CategoryID | int | YES | カテゴリID |
| QuantityPerUnit | nvarchar(20) | YES | 単位あたり数量 |
| UnitPrice | money | YES | 単価（デフォルト: 0） |
| UnitsInStock | smallint | YES | 在庫数（デフォルト: 0） |
| UnitsOnOrder | smallint | YES | 発注中数量（デフォルト: 0） |
| ReorderLevel | smallint | YES | 再発注点（デフォルト: 0） |
| Discontinued | bit | NO | 販売中止フラグ |
| CreatedBy | nvarchar(max) | YES | 作成者 |
| Created | datetime2 | NO | 作成日時 |
| LastModifiedBy | nvarchar(max) | YES | 最終更新者 |
| LastModified | datetime2 | YES | 最終更新日時 |

**制約:**
- 主キー: ProductID
- デフォルト値: UnitPrice = 0, UnitsInStock = 0, UnitsOnOrder = 0, ReorderLevel = 0

**リレーション:**
- Category: 多対1
- Supplier: 多対1
- OrderDetails: 1対多（1つの商品に複数の注文明細）

---

### 8. Region

地域を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| RegionID | int | NO | 主キー（手動設定） |
| RegionDescription | nvarchar(50) | NO | 地域の説明 |

**制約:**
- 主キー: RegionID（非クラスタ化インデックス、ValueGeneratedNever）

**リレーション:**
- Territories: 1対多（1つの地域に複数の担当地域）

---

### 9. Shippers

配送業者を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| ShipperID | int | NO | 主キー、自動採番 |
| CompanyName | nvarchar(40) | NO | 会社名 |
| Phone | nvarchar(24) | YES | 電話番号 |

**制約:**
- 主キー: ShipperID

**リレーション:**
- Orders: 1対多（1つの配送業者に複数の注文）

---

### 10. Suppliers

仕入先を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| SupplierID | int | NO | 主キー、自動採番 |
| CompanyName | nvarchar(40) | NO | 会社名 |
| ContactName | nvarchar(30) | YES | 担当者名 |
| ContactTitle | nvarchar(30) | YES | 担当者役職 |
| Address | nvarchar(60) | YES | 住所 |
| City | nvarchar(15) | YES | 市区町村 |
| Region | nvarchar(15) | YES | 地域 |
| PostalCode | nvarchar(10) | YES | 郵便番号 |
| Country | nvarchar(15) | YES | 国 |
| Phone | nvarchar(24) | YES | 電話番号 |
| Fax | nvarchar(24) | YES | FAX番号 |
| HomePage | ntext | YES | ホームページURL |

**制約:**
- 主キー: SupplierID

**リレーション:**
- Products: 1対多（1つの仕入先に複数の商品）

---

### 11. Territories

担当地域を管理するテーブルです。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| TerritoryID | nvarchar(20) | NO | 主キー（手動設定） |
| TerritoryDescription | nvarchar(50) | NO | 担当地域の説明 |
| RegionID | int | NO | 地域ID |

**制約:**
- 主キー: TerritoryID（非クラスタ化インデックス、ValueGeneratedNever）
- 外部キー: FK_Territories_Region (RegionID -> Region.RegionID)
- 削除動作: ClientSetNull

**リレーション:**
- Region: 多対1
- EmployeeTerritories: 1対多（1つの担当地域に複数の従業員）

## 備考

### 監査機能について

以下のエンティティはAuditableEntityを継承しており、作成者・作成日時・最終更新者・最終更新日時の監査情報を自動的に記録します：
- Employee
- Order
- OrderDetail
- Product

監査情報の記録はNorthwindDbContextのSaveChangesAsyncメソッドで行われ、ICurrentUserServiceとIDateTimeインターフェースを通じて現在のユーザーと日時を取得します。

### データ型について

- **money**: 金額を表す型（UnitPrice、Freight）
- **ntext**: 長いテキストデータ（Description、Notes、HomePage）
- **image**: バイナリ画像データ（Picture、Photo）
- **datetime**: 日時データ（BirthDate、HireDate、OrderDate等）
- **datetime2**: 監査用日時データ（Created、LastModified）

### 主キーの採番方式

- 自動採番（Identity）: CategoryID、EmployeeID、OrderID、ProductID、ShipperID、SupplierID
- 手動設定（ValueGeneratedNever）: CustomerID、RegionID、TerritoryID

### 複合主キー

- EmployeeTerritories: (EmployeeID, TerritoryID)
- Order Details: (OrderID, ProductID)
