---
generated_at: 2026-01-07 21:45:00
metrics:
  claims_total: 4
  claims_with_evidence: 4
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：4 / 4、根拠なし：0
- 優先レビュー（高）
  - 該当なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/Application/System/Commands/SeedSampleData/SeedSampleDataCommand.cs`
- E-02: `Src/Application/System/Commands/SeedSampleData/SampleDataSeeder.cs`
- E-03: `Src/WebUI/Program.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SeedSampleDataバッチ処理が存在する | E-01, E-02 | ○ |
| C-02 | アプリケーション起動時にProgram.csから呼び出される | E-03 (39行目: `await mediator.Send(new SeedSampleDataCommand(), CancellationToken.None);`) | ○ |
| C-03 | 顧客・地域・テリトリ・従業員・カテゴリ・配送業者・仕入先・製品・注文・ユーザーをシードする | E-02 (SeedAllAsync: SeedCustomersAsync, SeedRegionsAsync, SeedTerritoriesAsync, SeedEmployeesAsync, SeedCategoriesAsync, SeedShippersAsync, SeedSuppliersAsync, SeedProductsAsync, SeedOrdersAsync, SeedUsersAsync) | ○ |
| C-04 | 既にデータが存在する場合はスキップする | E-02 (31-34行目: `if (_context.Customers.Any()) { return; }`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。本プロジェクトで確認できたバッチ処理はSeedSampleDataのみです。
- 補足：本プロジェクトはWebアプリケーション（ASP.NET Core + Angular）であり、定期実行されるスケジュールバッチやバックグラウンドワーカーサービスは実装されていません。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に明確な根拠があり、バッチ処理は起動時の初期化処理のみ

## 6) レビュアーチェックリスト（最小）
- [ ] SeedSampleDataが唯一のバッチ処理であることを確認する
- [ ] 他にバックグラウンドサービスやスケジュールタスクが必要な場合は追加を検討する
