# バッチ設計書 1-SeedSampleData

## 概要

本ドキュメントは、Northwind Tradersアプリケーションにおけるサンプルデータ投入バッチ「SeedSampleData」の設計仕様を定義するものです。本バッチは、アプリケーション起動時にデータベースへ初期データを自動投入する機能を担います。

### 本バッチの処理概要

SeedSampleDataバッチは、Northwind Tradersアプリケーションの動作確認・開発・デモンストレーションに必要なサンプルデータを、データベースに自動投入する起動時バッチです。CQRSパターンに基づきMediatRを使用してコマンドとして実装されており、アプリケーションのProgram.csから起動時に一度だけ呼び出されます。

**業務上の目的・背景**：本バッチは、新規環境へのデプロイ時や開発環境のセットアップ時に、アプリケーションの動作検証に必要な一連のマスターデータおよびトランザクションデータを自動的に準備するために存在します。Northwind Tradersは食品販売業務を管理するWebアプリケーションであり、顧客管理、製品管理、注文管理などの業務機能を検証するためには、相互に関連する多数のマスターデータとトランザクションデータが必要です。本バッチにより、手動でのデータ投入作業を省略し、開発効率の向上と環境構築の標準化を実現します。

**バッチの実行タイミング**：アプリケーション起動時（WebHost起動直後）に自動実行されます。Program.csのMain関数内でデータベースマイグレーション（NorthwindDbContext.Database.Migrate()およびApplicationDbContext.Database.Migrate()）完了後、MediatRを通じてSeedSampleDataCommandが発行され、サービス開始前に一度だけ実行されます。

**主要な処理内容**：
1. 顧客（Customers）データの投入：91件の顧客情報（会社名、担当者、住所、電話番号等）を登録
2. 地域（Regions）データの投入：Eastern、Western、Northern、Southernの4つの地域を登録
3. テリトリー（Territories）データの投入：営業担当地域データを登録
4. 従業員（Employees）データの投入：従業員情報と上司-部下の階層構造を登録
5. カテゴリ（Categories）データの投入：Beverages、Condimentsなど8つの商品カテゴリを登録
6. 配送業者（Shippers）データの投入：3社の配送業者情報を登録
7. 仕入先（Suppliers）データの投入：製品の仕入先情報を登録
8. 製品（Products）データの投入：商品マスターデータを登録
9. 注文（Orders）データの投入：注文ヘッダーと注文明細（OrderDetails）データを登録
10. ユーザー（Users）データの投入：従業員に紐づくASP.NET Core Identityユーザーアカウントを作成

**前後の処理との関連**：本バッチはデータベースマイグレーションが完了した後に実行される必要があります。スキーマが確立されていない状態でデータ投入を試みると失敗します。本バッチの完了後、host.Run()によりアプリケーションのWebホストが起動しHTTPリクエストの受付を開始します。

**影響範囲**：本バッチはNorthwindDbContextが管理する全テーブル（Customers、Regions、Territories、Employees、EmployeeTerritories、Categories、Shippers、Suppliers、Products、Orders、OrderDetails）に対してINSERT操作を行います。また、IUserManagerを通じてApplicationDbContext（ASP.NET Core Identity）のユーザーテーブルにもユーザーデータを作成し、Employeesテーブルに対してはUserIdカラムのUPDATEも行います。

## バッチ種別

データ初期化 / マスターデータ投入

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | アプリケーション起動時（1回のみ） |
| 実行時刻 | アプリケーション起動時 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | アプリケーション起動イベント（Program.Main） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベースマイグレーション完了 | NorthwindDbContextおよびApplicationDbContextのマイグレーションが完了していること |
| データベース接続可能 | Entity Frameworkを通じてSQL Server等のデータベースに接続可能な状態であること |
| DIコンテナ設定完了 | INorthwindDbContext、IUserManager、IMediatorがDIコンテナに正しく登録されていること |

### 実行可否判定

Customersテーブルにデータが存在するかどうかで判定します。SampleDataSeeder.SeedAllAsync()の冒頭で`_context.Customers.Any()`を呼び出し、trueを返す場合（既にデータが存在する場合）は即座にreturnして処理を終了します。これにより、重複投入を防止し、既存データを保護します。

```csharp
if (_context.Customers.Any())
{
    return;
}
```

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| request | SeedSampleDataCommand | Yes | - | MediatRコマンドオブジェクト（パラメータプロパティなし） |
| cancellationToken | CancellationToken | No | CancellationToken.None | 処理のキャンセル用トークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ハードコード済みデータ | C#コード | SampleDataSeeder.cs内に定義された静的サンプルデータ（約1.4MBのソースファイル） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Customers | DB | 顧客データ（91件） |
| Region | DB | 地域データ（4件） |
| Territories | DB | テリトリーデータ |
| Employees | DB | 従業員データ |
| EmployeeTerritories | DB | 従業員テリトリー紐付けデータ |
| Categories | DB | カテゴリデータ（8件） |
| Shippers | DB | 配送業者データ（3件） |
| Suppliers | DB | 仕入先データ |
| Products | DB | 製品データ |
| Orders | DB | 注文データ |
| OrderDetails | DB | 注文明細データ |
| AspNetUsers | DB | ユーザーアカウントデータ（Identity経由） |

### 出力ファイル仕様

本バッチではファイル出力は行いません。全てのデータはデータベースに直接投入されます。

## 処理フロー

### 処理シーケンス

```
1. SeedSampleDataCommand受信
   └─ MediatRを通じてSeedSampleDataCommandHandlerが呼び出される
2. SampleDataSeeder初期化
   └─ コンストラクタでINorthwindDbContextとIUserManagerを注入
   └─ 各エンティティ用のDictionary（Employees, Suppliers, Categories, Shippers, Products）を初期化
3. SeedAllAsync実行開始
   └─ データ存在チェック：Customersテーブルにデータが存在するか確認
   └─ 存在する場合は即座にreturnして終了
4. SeedCustomersAsync
   └─ 91件の顧客データをINSERT → SaveChangesAsync
5. SeedRegionsAsync
   └─ 4件の地域データをINSERT → SaveChangesAsync
6. SeedTerritoriesAsync
   └─ テリトリーデータをINSERT → SaveChangesAsync
7. SeedEmployeesAsync
   └─ 従業員データをINSERT（階層構造・テリトリー関連含む） → SaveChangesAsync
8. SeedCategoriesAsync
   └─ 8件のカテゴリデータをINSERT → SaveChangesAsync
9. SeedShippersAsync
   └─ 3件の配送業者データをINSERT → SaveChangesAsync
10. SeedSuppliersAsync
    └─ 仕入先データをINSERT → SaveChangesAsync
11. SeedProductsAsync
    └─ 製品データをINSERT → SaveChangesAsync
12. SeedOrdersAsync
    └─ 注文ヘッダーおよび明細データをINSERT → SaveChangesAsync
13. SeedUsersAsync
    └─ UserId未設定の従業員を取得（DirectReportsもInclude）
    └─ 各従業員に対してIUserManager.CreateUserAsyncでユーザー作成
    └─ 作成されたUserIdをEmployee.UserIdに設定
    └─ SaveChangesAsync
14. 処理完了
    └─ Unit.Valueを返却
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SampleDataSeeder初期化]
    B --> C{Customersにデータ存在?}
    C -->|あり| D[スキップ]
    C -->|なし| E[顧客データ投入]
    E --> F[地域データ投入]
    F --> G[テリトリーデータ投入]
    G --> H[従業員データ投入]
    H --> I[カテゴリデータ投入]
    I --> J[配送業者データ投入]
    J --> K[仕入先データ投入]
    K --> L[製品データ投入]
    L --> M[注文データ投入]
    M --> N[ユーザーデータ投入]
    N --> O[バッチ終了]
    D --> O
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 存在チェック | Customers | SELECT | Any()によるデータ存在確認 |
| SeedCustomersAsync | Customers | INSERT | 顧客マスターデータ投入（91件） |
| SeedRegionsAsync | Region | INSERT | 地域マスターデータ投入（4件） |
| SeedTerritoriesAsync | Territories | INSERT | テリトリーマスターデータ投入 |
| SeedEmployeesAsync | Employees, EmployeeTerritories | INSERT | 従業員データおよび担当地域紐付け投入 |
| SeedCategoriesAsync | Categories | INSERT | カテゴリマスターデータ投入（8件） |
| SeedShippersAsync | Shippers | INSERT | 配送業者マスターデータ投入（3件） |
| SeedSuppliersAsync | Suppliers | INSERT | 仕入先マスターデータ投入 |
| SeedProductsAsync | Products | INSERT | 製品マスターデータ投入 |
| SeedOrdersAsync | Orders, OrderDetails | INSERT | 注文トランザクションデータ投入 |
| SeedUsersAsync | AspNetUsers | INSERT | ユーザーアカウント作成（Identity経由） |
| SeedUsersAsync | Employees | UPDATE | UserIdカラムの紐付け更新 |

### テーブル別操作詳細

#### Customers

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | CustomerId | 5文字のID（ALFKI, ANATR等） | 主キー、文字列型 |
| INSERT | CompanyName | 会社名（例: "Alfreds Futterkiste"） | 必須 |
| INSERT | ContactName | 担当者名（例: "Maria Anders"） | |
| INSERT | ContactTitle | 役職（例: "Sales Representative"） | |
| INSERT | Address | 住所（例: "Obere Str. 57"） | |
| INSERT | City | 市区町村（例: "Berlin"） | |
| INSERT | Region | 地域（例: "BC", null可） | |
| INSERT | PostalCode | 郵便番号（例: "12209"） | |
| INSERT | Country | 国（例: "Germany"） | |
| INSERT | Phone | 電話番号（例: "030-0074321"） | |
| INSERT | Fax | FAX番号（空文字可） | |

#### Region

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | RegionId | 1, 2, 3, 4 | 主キー |
| INSERT | RegionDescription | "Eastern", "Western", "Northern", "Southern" | 地域名 |

#### Employees

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | EmployeeId | 自動採番 | 主キー |
| INSERT | LastName | 姓 | 必須 |
| INSERT | FirstName | 名 | 必須 |
| INSERT | Title | 役職 | |
| INSERT | TitleOfCourtesy | 敬称（Mr., Ms.等） | |
| INSERT | BirthDate | 生年月日 | |
| INSERT | HireDate | 入社日 | |
| INSERT | Address | 住所 | |
| INSERT | City | 市区町村 | |
| INSERT | Region | 地域 | |
| INSERT | PostalCode | 郵便番号 | |
| INSERT | Country | 国 | |
| INSERT | HomePhone | 自宅電話 | |
| INSERT | Extension | 内線番号 | |
| INSERT | Photo | 写真 | バイナリデータ |
| INSERT | Notes | 備考 | |
| INSERT | ReportsTo | 上長EmployeeId | 外部キー（自己参照） |
| UPDATE | UserId | IUserManager.CreateUserAsyncで取得したID | SeedUsersAsyncで更新 |

#### Products

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | ProductId | 自動採番 | 主キー |
| INSERT | ProductName | 製品名 | 必須 |
| INSERT | SupplierId | 仕入先ID | 外部キー |
| INSERT | CategoryId | カテゴリID | 外部キー |
| INSERT | QuantityPerUnit | 単位あたり数量 | |
| INSERT | UnitPrice | 単価 | |
| INSERT | UnitsInStock | 在庫数 | |
| INSERT | UnitsOnOrder | 発注数 | |
| INSERT | ReorderLevel | 再発注レベル | |
| INSERT | Discontinued | 販売終了フラグ | |

#### Orders / OrderDetails

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | OrderId | 自動採番 | 主キー |
| INSERT | CustomerId | 顧客ID | 外部キー |
| INSERT | EmployeeId | 従業員ID | 外部キー |
| INSERT | OrderDate | 注文日 | |
| INSERT | RequiredDate | 希望納期 | |
| INSERT | ShippedDate | 出荷日 | |
| INSERT | ShipVia | 配送業者ID | 外部キー |
| INSERT | Freight | 運賃 | |
| INSERT | ShipName | 送り先名 | |
| INSERT | ShipAddress | 送り先住所 | |
| INSERT | ShipCity | 送り先市区町村 | |
| INSERT | ShipRegion | 送り先地域 | |
| INSERT | ShipPostalCode | 送り先郵便番号 | |
| INSERT | ShipCountry | 送り先国 | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | DbUpdateException | データベース制約違反（外部キー、一意制約等） | ログ出力後、アプリケーション起動を継続 |
| - | SqlException | データベース接続エラー | ログ出力後、アプリケーション起動を継続 |
| - | InvalidOperationException | DIコンテナからのサービス取得失敗 | ログ出力後、アプリケーション起動を継続 |
| - | Exception | その他予期しない例外 | Program.csでキャッチしログ出力後、アプリケーション起動を継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. Program.csのtry-catchブロックで例外をキャッチ
2. ILogger<Program>を使用してエラーログを出力（"An error occurred while migrating or initializing the database."）
3. アプリケーション自体は起動を継続（サンプルデータなしで動作）
4. 手動でのリカバリが必要な場合：
   - データベースの状態を確認（部分的にデータが投入されている可能性あり）
   - 必要に応じてデータベースを初期化（マイグレーションのロールバック）
   - 問題を修正後、アプリケーションを再起動

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各Seedメソッド単位（エンティティ種別ごと） |
| コミットタイミング | 各Seedメソッド終了時（SaveChangesAsync呼び出し時） |
| ロールバック条件 | SaveChangesAsync呼び出し前に例外発生した場合、該当メソッド内の変更のみロールバック |

注意：各エンティティ種別は個別にコミットされるため、途中でエラーが発生した場合、それまでに投入されたデータは保持され、エラー発生以降のデータは投入されません。

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約1000件（全テーブル合計） |
| 目標処理時間 | 10秒以内 |
| メモリ使用量上限 | 100MB |

## 排他制御

- 同時実行は想定していない（アプリケーション起動時に1回のみ実行）
- Customersテーブルの存在チェック（Any()）により、重複投入を防止
- 複数インスタンスが同時起動した場合は、データベースの一意制約により競合が検出される
- テーブルレベルの明示的なロックは使用しない

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 例外発生時 | "An error occurred while migrating or initializing the database." + 例外詳細 |

注意：通常の開始ログ・進捗ログ・終了ログは実装されていません。

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 30秒 | アプリケーションログ |
| エラー発生 | 1件以上 | アプリケーションログ |

## 備考

- 本バッチは主に開発・テスト・デモ目的で使用されるサンプルデータ投入機能です
- 本番環境では、Customersテーブルに本番データが存在するため自動的にスキップされます
- データはSampleDataSeeder.cs内にハードコードされており（ファイルサイズ約1.4MB）、外部ファイルからの読み込みは行いません
- ユーザーアカウントのパスワードは固定値「Northwind1!」が設定されます（セキュリティ上の注意が必要）
- 従業員のユーザー名は「{FirstName}@northwind」形式（小文字）で作成されます
- SampleDataSeederクラスはDictionary（Employees, Suppliers, Categories, Shippers, Products）でエンティティをキャッシュし、後続の処理で参照できるようにしています
- DirectReportsを持つ従業員（マネージャー）に対してマネージャーロールを追加する処理はTODOコメントとして残されており、未実装です
