---
generated_at: 2026-01-07 23:45:00
metrics:
  claims_total: 82
  claims_with_evidence: 82
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Application.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（Application.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：82 / 82、根拠なし：0
- 優先レビュー（高）
  1. なし - 全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

### Common/Behaviours
- E-01: `Src/Application/Common/Behaviours/RequestValidationBehavior.cs`
- E-02: `Src/Application/Common/Behaviours/RequestPerformanceBehaviour.cs`
- E-03: `Src/Application/Common/Behaviours/RequestLogger.cs`

### Common/Models
- E-04: `Src/Application/Common/Models/Result.cs`

### Common/Exceptions
- E-05: `Src/Application/Common/Exceptions/ValidationException.cs`
- E-06: `Src/Application/Common/Exceptions/NotFoundException.cs`
- E-07: `Src/Application/Common/Exceptions/DeleteFailureException.cs`
- E-08: `Src/Application/Common/Exceptions/BadRequestException.cs`

### Common/Mappings
- E-09: `Src/Application/Common/Mappings/MappingProfile.cs`
- E-10: `Src/Application/Common/Mappings/IMapFrom.cs`

### Common/Interfaces
- E-11: `Src/Application/Common/Interfaces/INorthwindDbContext.cs`
- E-12: `Src/Application/Common/Interfaces/IUserManager.cs`
- E-13: `Src/Application/Common/Interfaces/ICsvFileBuilder.cs`
- E-14: `Src/Application/Common/Interfaces/INotificationService.cs`
- E-15: `Src/Application/Common/Interfaces/ICurrentUserService.cs`

### Customers/Commands
- E-16: `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommand.cs`
- E-17: `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommandValidator.cs`
- E-18: `Src/Application/Customers/Commands/CreateCustomer/CustomerCreated.cs`
- E-19: `Src/Application/Customers/Commands/UpdateCustomer/UpdateCustomerCommand.cs`
- E-20: `Src/Application/Customers/Commands/UpdateCustomer/UpdateCustomerCommandValidator.cs`
- E-21: `Src/Application/Customers/Commands/DeleteCustomer/DeleteCustomerCommand.cs`
- E-22: `Src/Application/Customers/Commands/DeleteCustomer/DeleteCustomerCommandHandler.cs`
- E-23: `Src/Application/Customers/Commands/DeleteCustomer/DeleteCustomerCommandValidator.cs`

### Customers/Queries
- E-24: `Src/Application/Customers/Queries/GetCustomersList/GetCustomersListQuery.cs`
- E-25: `Src/Application/Customers/Queries/GetCustomersList/GetCustomersListQueryHandler.cs`
- E-26: `Src/Application/Customers/Queries/GetCustomerDetail/GetCustomerDetailQuery.cs`
- E-27: `Src/Application/Customers/Queries/GetCustomerDetail/GetCustomerDetailQueryHandler.cs`
- E-28: `Src/Application/Customers/Queries/GetCustomerDetail/GetCustomerDetailQueryValidator.cs`

### Categories/Commands
- E-29: `Src/Application/Categories/Commands/UpsertCategory/UpsertCategoryCommand.cs`
- E-30: `Src/Application/Categories/Commands/DeleteCategory/DeleteCategoryCommand.cs`

### Categories/Queries
- E-31: `Src/Application/Categories/Queries/GetCategoriesList/GetCategoriesListQuery.cs`
- E-32: `Src/Application/Categories/Queries/GetCategoriesList/GetCategoriesListQueryHandler.cs`

### Products/Commands
- E-33: `Src/Application/Products/Commands/CreateProduct/CreateProductCommand.cs`
- E-34: `Src/Application/Products/Commands/CreateProduct/CreateProductCommandHandler.cs`
- E-35: `Src/Application/Products/Commands/UpdateProduct/UpdateProductCommand.cs`
- E-36: `Src/Application/Products/Commands/UpdateProduct/UpdateProductCommandHandler.cs`
- E-37: `Src/Application/Products/Commands/DeleteProduct/DeleteProductCommand.cs`
- E-38: `Src/Application/Products/Commands/DeleteProduct/DeleteProductCommandHandler.cs`

### Products/Queries
- E-39: `Src/Application/Products/Queries/GetProductsList/GetProductsListQuery.cs`
- E-40: `Src/Application/Products/Queries/GetProductsList/GetProductsListQueryHandler.cs`
- E-41: `Src/Application/Products/Queries/GetProductDetail/GetProductDetailQuery.cs`
- E-42: `Src/Application/Products/Queries/GetProductDetail/GetProductDetailQueryHandler.cs`
- E-43: `Src/Application/Products/Queries/GetProductsFile/GetProductsFileQuery.cs`
- E-44: `Src/Application/Products/Queries/GetProductsFile/GetProductsFileQueryHandler.cs`

### Employees/Commands
- E-45: `Src/Application/Employees/Commands/UpsertEmployee/UpsertEmployeeCommand.cs`
- E-46: `Src/Application/Employees/Commands/DeleteEmployee/DeleteEmployeeCommand.cs`

### Employees/Queries
- E-47: `Src/Application/Employees/Queries/GetEmployeesList/GetEmployeesListQuery.cs`
- E-48: `Src/Application/Employees/Queries/GetEmployeeDetail/GetEmployeeDetailQuery.cs`

### System/Commands
- E-49: `Src/Application/System/Commands/SeedSampleData/SeedSampleDataCommand.cs`

### DependencyInjection
- E-50: `Src/Application/DependencyInjection.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Common/Behaviours（UT-APP-001〜007）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-APP-001 | RequestValidationBehavior.Handle正常系 | E-01 | ○ |
| UT-APP-002 | RequestValidationBehavior.Handle異常系（ValidationException） | E-01, E-05 | ○ |
| UT-APP-003 | RequestValidationBehavior.Handle境界値（バリデーター0件） | E-01 | ○ |
| UT-APP-004 | RequestPerformanceBehaviour.Handle正常系（500ms以内） | E-02 | ○ |
| UT-APP-005 | RequestPerformanceBehaviour.Handle正常系（500ms超過） | E-02 | ○ |
| UT-APP-006 | RequestPerformanceBehaviour.Handle境界値（500ms） | E-02 | ○ |
| UT-APP-007 | RequestLogger.Process正常系 | E-03 | ○ |

### Common/Models（UT-APP-008〜010）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-APP-008 | Result.Success正常系 | E-04 | ○ |
| UT-APP-009 | Result.Failure正常系 | E-04 | ○ |
| UT-APP-010 | Result.Failure境界値（空リスト） | E-04 | ○ |

### Common/Exceptions（UT-APP-011〜016）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-APP-011 | ValidationException.Constructor正常系 | E-05 | ○ |
| UT-APP-012 | ValidationException.Constructor境界値（空リスト） | E-05 | ○ |
| UT-APP-013 | ValidationException.Constructor正常系（同一PropertyName集約） | E-05 | ○ |
| UT-APP-014 | NotFoundException.Constructor正常系 | E-06 | ○ |
| UT-APP-015 | DeleteFailureException.Constructor正常系 | E-07 | ○ |
| UT-APP-016 | BadRequestException.Constructor正常系 | E-08 | ○ |

### Common/Mappings（UT-APP-017〜018）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-APP-017 | MappingProfile.ApplyMappingsFromAssembly正常系 | E-09 | ○ |
| UT-APP-018 | IMapFrom.Mapping正常系 | E-10 | ○ |

### Customers/Commands/CreateCustomer（UT-APP-019〜029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-APP-019 | CreateCustomerCommand.Handler.Handle正常系 | E-16 | ○ |
| UT-APP-020 | CreateCustomerCommand.Handler.Handle正常系（通知発行） | E-16, E-18 | ○ |
| UT-APP-021 | CreateCustomerCommandValidator.Validate正常系 | E-17 | ○ |
| UT-APP-022 | CreateCustomerCommandValidator.Validate異常系（Id長） | E-17 | ○ |
| UT-APP-023 | CreateCustomerCommandValidator.Validate異常系（Id空） | E-17 | ○ |
| UT-APP-024 | CreateCustomerCommandValidator.Validate異常系（CompanyName空） | E-17 | ○ |
| UT-APP-025 | CreateCustomerCommandValidator.Validate異常系（CompanyName長） | E-17 | ○ |
| UT-APP-026 | CreateCustomerCommandValidator.Validate異常系（PostalCode空） | E-17 | ○ |
| UT-APP-027 | CreateCustomerCommandValidator.Validate境界値（Address60文字） | E-17 | ○ |
| UT-APP-028 | CreateCustomerCommandValidator.Validate異常系（Address61文字） | E-17 | ○ |
| UT-APP-029 | CustomerCreatedHandler.Handle正常系 | E-18 | ○ |

### Customers/Commands/UpdateCustomer（UT-APP-030〜036）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-APP-030 | UpdateCustomerCommand.Handler.Handle正常系 | E-19 | ○ |
| UT-APP-031 | UpdateCustomerCommand.Handler.Handle異常系（NotFoundException） | E-19 | ○ |
| UT-APP-032 | UpdateCustomerCommandValidator.Validate正常系 | E-20 | ○ |
| UT-APP-033 | UpdateCustomerCommandValidator.Validate異常系（オーストラリア郵便番号） | E-20 | ○ |
| UT-APP-034 | UpdateCustomerCommandValidator.Validate正常系（オーストラリア郵便番号4桁） | E-20 | ○ |
| UT-APP-035 | UpdateCustomerCommandValidator.Validate異常系（QLD地域電話番号） | E-20 | ○ |
| UT-APP-036 | UpdateCustomerCommandValidator.Validate正常系（QLD地域07電話番号） | E-20 | ○ |

### Customers/Commands/DeleteCustomer（UT-APP-037〜041）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-APP-037 | DeleteCustomerCommandHandler.Handle正常系 | E-22 | ○ |
| UT-APP-038 | DeleteCustomerCommandHandler.Handle異常系（NotFoundException） | E-22 | ○ |
| UT-APP-039 | DeleteCustomerCommandHandler.Handle異常系（DeleteFailureException） | E-22, E-07 | ○ |
| UT-APP-040 | DeleteCustomerCommandValidator.Validate正常系 | E-23 | ○ |
| UT-APP-041 | DeleteCustomerCommandValidator.Validate異常系（Id空） | E-23 | ○ |

### Customers/Queries（UT-APP-042〜047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-APP-042 | GetCustomersListQueryHandler.Handle正常系 | E-25 | ○ |
| UT-APP-043 | GetCustomersListQueryHandler.Handle境界値（0件） | E-25 | ○ |
| UT-APP-044 | GetCustomerDetailQueryHandler.Handle正常系 | E-27 | ○ |
| UT-APP-045 | GetCustomerDetailQueryHandler.Handle異常系（NotFoundException） | E-27 | ○ |
| UT-APP-046 | GetCustomerDetailQueryValidator.Validate正常系 | E-28 | ○ |
| UT-APP-047 | GetCustomerDetailQueryValidator.Validate異常系（Id空） | E-28 | ○ |

### Categories/Commands（UT-APP-048〜051）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-APP-048 | UpsertCategoryCommandHandler.Handle正常系（新規作成） | E-29 | ○ |
| UT-APP-049 | UpsertCategoryCommandHandler.Handle正常系（更新） | E-29 | ○ |
| UT-APP-050 | DeleteCategoryCommandHandler.Handle正常系 | E-30 | ○ |
| UT-APP-051 | DeleteCategoryCommandHandler.Handle異常系（NotFoundException） | E-30 | ○ |

### Categories/Queries（UT-APP-052〜053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-APP-052 | GetCategoriesListQueryHandler.Handle正常系 | E-32 | ○ |
| UT-APP-053 | GetCategoriesListQueryHandler.Handle境界値（0件） | E-32 | ○ |

### Products/Commands（UT-APP-054〜059）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-APP-054 | CreateProductCommandHandler.Handle正常系 | E-34 | ○ |
| UT-APP-055 | UpdateProductCommandHandler.Handle正常系 | E-36 | ○ |
| UT-APP-056 | UpdateProductCommandHandler.Handle異常系（NotFoundException） | E-36 | ○ |
| UT-APP-057 | DeleteProductCommandHandler.Handle正常系 | E-38 | ○ |
| UT-APP-058 | DeleteProductCommandHandler.Handle異常系（NotFoundException） | E-38 | ○ |
| UT-APP-059 | DeleteProductCommandHandler.Handle異常系（DeleteFailureException） | E-38, E-07 | ○ |

### Products/Queries（UT-APP-060〜067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-APP-060 | GetProductsListQueryHandler.Handle正常系（ソート順） | E-40 | ○ |
| UT-APP-061 | GetProductsListQueryHandler.Handle境界値（0件） | E-40 | ○ |
| UT-APP-062 | GetProductsListQueryHandler.Handle正常系（CreateEnabled） | E-40 | ○ |
| UT-APP-063 | GetProductDetailQueryHandler.Handle正常系 | E-42 | ○ |
| UT-APP-064 | GetProductDetailQueryHandler.Handle異常系（NotFoundException） | E-42 | ○ |
| UT-APP-065 | GetProductsFileQueryHandler.Handle正常系 | E-44 | ○ |
| UT-APP-066 | GetProductsFileQueryHandler.Handle正常系（ファイル名日付） | E-44 | ○ |
| UT-APP-067 | GetProductsFileQueryHandler.Handle正常系（ContentType） | E-44 | ○ |

### Employees/Commands（UT-APP-068〜073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-APP-068 | UpsertEmployeeCommandHandler.Handle正常系（新規作成） | E-45 | ○ |
| UT-APP-069 | UpsertEmployeeCommandHandler.Handle正常系（更新） | E-45 | ○ |
| UT-APP-070 | DeleteEmployeeCommandHandler.Handle正常系 | E-46 | ○ |
| UT-APP-071 | DeleteEmployeeCommandHandler.Handle異常系（NotFoundException） | E-46 | ○ |
| UT-APP-072 | DeleteEmployeeCommandHandler.Handle異常系（自己削除BadRequestException） | E-46, E-08 | ○ |
| UT-APP-073 | DeleteEmployeeCommandHandler.Handle正常系（UserIdあり時ユーザー削除） | E-46, E-12 | ○ |

### Employees/Queries（UT-APP-074〜077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-APP-074 | GetEmployeesListQueryHandler.Handle正常系（ソート順） | E-47 | ○ |
| UT-APP-075 | GetEmployeesListQueryHandler.Handle境界値（0件） | E-47 | ○ |
| UT-APP-076 | GetEmployeeDetailQueryHandler.Handle正常系 | E-48 | ○ |
| UT-APP-077 | GetEmployeeDetailQueryHandler.Handle境界値（存在しない場合null） | E-48 | ○ |

### System/Commands（UT-APP-078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-APP-078 | SeedSampleDataCommandHandler.Handle正常系 | E-49 | ○ |

### DependencyInjection（UT-APP-079〜082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-APP-079 | DependencyInjection.AddApplication正常系（AutoMapper） | E-50 | ○ |
| UT-APP-080 | DependencyInjection.AddApplication正常系（MediatR） | E-50 | ○ |
| UT-APP-081 | DependencyInjection.AddApplication正常系（RequestPerformanceBehaviour） | E-50 | ○ |
| UT-APP-082 | DependencyInjection.AddApplication正常系（RequestValidationBehavior） | E-50 | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの項目は存在しません

### 注意点
- `SampleDataSeeder.cs` は1.4MBと非常に大きなファイルのため、詳細な解析は行っていません（サンプルデータ定義が大量に含まれる）
- `GetEmployeeDetailQuery` では存在しない場合にnullを返却しており、NotFoundExceptionがスローされない実装になっています（UT-APP-077）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて生成されています

### 特に重要なテストケース（高優先度）
1. **バリデーション関連（UT-APP-001〜003, UT-APP-021〜028）** - 入力値検証はセキュリティ上重要
2. **削除時の関連データチェック（UT-APP-039, UT-APP-059）** - データ整合性維持に重要
3. **自己削除禁止（UT-APP-072）** - 権限管理の重要なロジック
4. **NotFoundExceptionスロー（UT-APP-031, UT-APP-038, UT-APP-045, UT-APP-051, UT-APP-056, UT-APP-058, UT-APP-064, UT-APP-071）** - エラーハンドリングの一貫性

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーションルール（長さ制限、必須チェック）がソースコードと一致しているか
- [ ] 例外スローの条件がソースコードの実装と一致しているか
- [ ] 削除時の関連データチェックが適切に定義されているか
- [ ] オーストラリア固有のバリデーション（郵便番号4桁、QLD電話番号）が正確か
- [ ] GetEmployeeDetailQueryHandlerがnullを返す仕様が正しいか確認（他のQueryHandlerはNotFoundExceptionをスロー）
