---
generated_at: 2026-01-07 23:45:00
metrics:
  claims_total: 8
  claims_with_evidence: 7
  claims_without_evidence: 1
confidence_derived: 0.88
---

# 根拠レポート：Common モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：7 / 8、根拠なし：1
- 優先レビュー（高）
  1. **UT-COM-008**：NullReferenceExceptionの挙動について実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/Common/IDateTime.cs` - IDateTimeインターフェース定義
- E-02: `Src/Infrastructure/MachineDateTime.cs` - IDateTimeの実装クラス
- E-03: `Src/Infrastructure/DependencyInjection.cs` - DI登録（Transient）
- E-04: `Src/Persistence/NorthwindDbContext.cs` - IDateTimeの使用箇所（SaveChangesAsync）
- E-05: `Tests/Persistence.IntegrationTests/NorthwindDbContextTests.cs` - 既存テストコード（モック使用例）
- E-06: `Src/Common/Common.csproj` - プロジェクト構成ファイル
- E-07: `Src/Common/README.md` - Commonレイヤーの説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IDateTime.Nowプロパティが現在日時を返却する | E-01, E-02 | ○ |
| C-02 | IDateTimeがモック可能である | E-05 | ○ |
| C-03 | DIコンテナから解決できる | E-03 | ○ |
| C-04 | 年末年始の日時が正しく取得できる | E-02（DateTime.Now使用） | ○ |
| C-05 | うるう年の日時が正しく取得できる | E-02（DateTime.Now使用） | ○ |
| C-06 | NorthwindDbContextでCreated設定に使用される | E-04, E-05 | ○ |
| C-07 | NorthwindDbContextでLastModified設定に使用される | E-04, E-05 | ○ |
| C-08 | IDateTimeがnullの場合の挙動 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-08について：NorthwindDbContextのコンストラクタでnullチェックが行われていないため、実際の挙動は実装次第
  - 候補：例外スロー / デフォルト値設定 / NullReferenceException

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - Commonモジュールは1ファイル（IDateTime.cs）のみで構成されており、インターフェース定義のみのためリスクは低い
- **1: 中リスク** - IDateTimeがnullの場合の防御的プログラミングが実装されていない可能性

## 6) レビュアーチェックリスト（最小）
- [ ] IDateTimeインターフェースの契約がシンプルで適切か確認
- [ ] 既存テスト（NorthwindDbContextTests.cs）のモック使用方法が正しいか確認
- [ ] DIコンテナでのTransient登録が適切か確認（Singleton/Scopedの検討）
- [ ] null許容に関する防御的プログラミングの必要性を検討

---

## 補足情報

### Commonモジュールの構成
- **ファイル数**: 1（IDateTime.cs）
- **名前空間**: `Northwind.Common`
- **役割**: プロジェクト全体で共有されるクロスカッティング関心事（日時取得）

### IDateTimeインターフェースの使用箇所
1. **NorthwindDbContext.SaveChangesAsync**: 監査プロパティ（Created, LastModified）の設定
2. **DI登録**: InfrastructureレイヤーでMachineDateTimeとしてTransient登録

### 既存テストの参考
`Tests/Persistence.IntegrationTests/NorthwindDbContextTests.cs` では、IDateTimeをMoqでモックし、固定日時（`new DateTime(3001, 1, 1)`）を返却するように設定している。これにより、テスト時に日時を制御可能にしている。
