---
generated_at: 2026-01-07 23:45:00
metrics:
  claims_total: 109
  claims_with_evidence: 109
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Domain.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（Domain.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で各項目の根拠を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：109 / 109、根拠なし：0
- 優先レビュー（高）
  1. なし - すべてのテストケースはソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/Domain/Common/ValueObject.cs`
- E-02: `Src/Domain/Common/AuditableEntity.cs`
- E-03: `Src/Domain/ValueObjects/AdAccount.cs`
- E-04: `Src/Domain/Exceptions/AdAccountInvalidException.cs`
- E-05: `Src/Domain/Entities/Category.cs`
- E-06: `Src/Domain/Entities/Customer.cs`
- E-07: `Src/Domain/Entities/Employee.cs`
- E-08: `Src/Domain/Entities/EmployeeTerritory.cs`
- E-09: `Src/Domain/Entities/Order.cs`
- E-10: `Src/Domain/Entities/OrderDetail.cs`
- E-11: `Src/Domain/Entities/Product.cs`
- E-12: `Src/Domain/Entities/Region.cs`
- E-13: `Src/Domain/Entities/Shipper.cs`
- E-14: `Src/Domain/Entities/Supplier.cs`
- E-15: `Src/Domain/Entities/Territory.cs`
- E-16: `Tests/Domain.UnitTests/Common/ValueObjectTests.cs`（既存テスト参照）
- E-17: `Tests/Domain.UnitTests/ValueObjects/AdAccountTests.cs`（既存テスト参照）

## 3) Claims と根拠の対応（レビューの主戦場）

### ValueObject（UT-DOM-001〜016）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ValueObject.EqualOperator - 同一値比較でtrue | E-01, E-16 | ○ |
| C-02 | ValueObject.EqualOperator - 異なる値比較でfalse | E-01, E-16 | ○ |
| C-03 | ValueObject.EqualOperator - 左辺null | E-01 (line 11-14) | ○ |
| C-04 | ValueObject.EqualOperator - 右辺null | E-01 (line 11-14) | ○ |
| C-05 | ValueObject.EqualOperator - 両辺null | E-01 (line 11-14) | ○ |
| C-06 | ValueObject.NotEqualOperator - 異なる値 | E-01 (line 19-22) | ○ |
| C-07 | ValueObject.NotEqualOperator - 同一値 | E-01 (line 19-22) | ○ |
| C-08 | ValueObject.Equals - 同一値 | E-01 (line 26-51), E-16 | ○ |
| C-09 | ValueObject.Equals - null | E-01 (line 28-31) | ○ |
| C-10 | ValueObject.Equals - 異なる型 | E-01 (line 28-31) | ○ |
| C-11〜13 | ValueObject.Equals - 境界値 | E-01 (line 37-49) | ○ |
| C-14〜16 | ValueObject.GetHashCode | E-01 (line 54-59) | ○ |

### AdAccount（UT-DOM-017〜030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | AdAccount.For - 正常パース | E-03 (line 14-29), E-17 | ○ |
| C-18 | AdAccount.For - バックスラッシュなし | E-03, E-04, E-17 | ○ |
| C-19 | AdAccount.For - 空文字 | E-03 (line 18-27) | ○ |
| C-20 | AdAccount.For - null | E-03 (line 18-27) | ○ |
| C-21〜23 | AdAccount.For - 境界値 | E-03 (line 20-22) | ○ |
| C-24 | AdAccount.ToString | E-03 (line 46-49), E-17 | ○ |
| C-25 | implicit operator string | E-03 (line 36-39), E-17 | ○ |
| C-26〜27 | explicit operator AdAccount | E-03 (line 41-44), E-17 | ○ |
| C-28 | AdAccount.GetAtomicValues | E-03 (line 51-55) | ○ |
| C-29〜30 | AdAccount.Equals継承 | E-01, E-03 | ○ |

### AdAccountInvalidException（UT-DOM-031〜032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | 正しいエラーメッセージ | E-04 (line 7-8) | ○ |
| C-32 | 内部例外設定 | E-04 (line 7-8) | ○ |

### AuditableEntity（UT-DOM-033〜037）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | CreatedBy | E-02 (line 7) | ○ |
| C-34 | Created | E-02 (line 9) | ○ |
| C-35 | LastModifiedBy | E-02 (line 11) | ○ |
| C-36〜37 | LastModified | E-02 (line 13) | ○ |

### Category（UT-DOM-038〜043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | コンストラクタ初期化 | E-05 (line 7-10) | ○ |
| C-39〜43 | プロパティ | E-05 (line 12-17) | ○ |

### Customer（UT-DOM-044〜047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | コンストラクタ初期化 | E-06 (line 7-10) | ○ |
| C-45〜47 | プロパティ | E-06 (line 12-24) | ○ |

### Employee（UT-DOM-048〜055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48〜50 | コンストラクタ初期化 | E-07 (line 9-14) | ○ |
| C-51〜55 | プロパティ・リレーション | E-07 (line 16-39) | ○ |

### EmployeeTerritory（UT-DOM-056〜059）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56〜59 | プロパティ・リレーション | E-08 (line 5-10) | ○ |

### Order（UT-DOM-060〜068）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | コンストラクタ初期化 | E-09 (line 9-12) | ○ |
| C-61〜68 | プロパティ・リレーション | E-09 (line 14-32) | ○ |

### OrderDetail（UT-DOM-069〜077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69〜77 | プロパティ・リレーション | E-10 (line 7-15) | ○ |

### Product（UT-DOM-078〜091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | コンストラクタ初期化 | E-11 (line 8-11) | ○ |
| C-79〜91 | プロパティ・リレーション | E-11 (line 13-26) | ○ |

### Region（UT-DOM-092〜095）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | コンストラクタ初期化 | E-12 (line 7-10) | ○ |
| C-93〜95 | プロパティ・リレーション | E-12 (line 12-15) | ○ |

### Shipper（UT-DOM-096〜099）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | コンストラクタ初期化 | E-13 (line 7-10) | ○ |
| C-97〜99 | プロパティ・リレーション | E-13 (line 12-16) | ○ |

### Supplier（UT-DOM-100〜103）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | コンストラクタ初期化 | E-14 (line 7-10) | ○ |
| C-101〜103 | プロパティ・リレーション | E-14 (line 12-25) | ○ |

### Territory（UT-DOM-104〜109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | コンストラクタ初期化 | E-15 (line 7-10) | ○ |
| C-105〜109 | プロパティ・リレーション | E-15 (line 12-17) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースはソースコードに直接対応しています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - Domainレイヤーはシンプルなエンティティとバリューオブジェクトで構成されており、複雑なビジネスロジックは含まれていません
- 既存のテストコード（`Tests/Domain.UnitTests/`）と整合性があります

## 6) レビュアーチェックリスト（最小）
- [ ] ValueObjectの等価比較ロジックのテストケースが網羅されているか
- [ ] AdAccountのパース処理の異常系が十分にカバーされているか
- [ ] 各エンティティのリレーションプロパティが正しく定義されているか
- [ ] Nullable型プロパティの境界値テストが適切か
- [ ] 金額・数量に関わる高優先度テストケースが妥当か
