---
generated_at: 2026-01-07 23:45:00
metrics:
  claims_total: 65
  claims_with_evidence: 65
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Persistence.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・Entity Framework Core設定などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：65 / 65、根拠なし：0
- 優先レビュー（高）
  1. **SaveChangesAsync監査プロパティ**：既存テストコードで検証済み
  2. **Configuration設定**：ソースコードで明確に定義されている
  3. **DependencyInjection設定**：DIパターンの実装を確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `Src/Persistence/NorthwindDbContext.cs` - DbContext実装
- E-02: `Src/Persistence/NorthwindDbContextFactory.cs` - 設計時ファクトリ
- E-03: `Src/Persistence/DesignTimeDbContextFactoryBase.cs` - 設計時ファクトリ基底クラス
- E-04: `Src/Persistence/DependencyInjection.cs` - DI設定
- E-05: `Src/Persistence/Configurations/CategoryConfiguration.cs` - Category設定
- E-06: `Src/Persistence/Configurations/CustomerConfiguration.cs` - Customer設定
- E-07: `Src/Persistence/Configurations/EmployeeConfiguration.cs` - Employee設定
- E-08: `Src/Persistence/Configurations/OrderConfiguration.cs` - Order設定
- E-09: `Src/Persistence/Configurations/OrderDetailConfiguration.cs` - OrderDetail設定
- E-10: `Src/Persistence/Configurations/ProductConfiguration.cs` - Product設定
- E-11: `Src/Persistence/Configurations/RegionConfiguration.cs` - Region設定
- E-12: `Src/Persistence/Configurations/ShipperConfiguration.cs` - Shipper設定
- E-13: `Src/Persistence/Configurations/SupplierConfiguration.cs` - Supplier設定
- E-14: `Src/Persistence/Configurations/TerritoryConfiguration.cs` - Territory設定
- E-15: `Src/Persistence/Configurations/EmployeeTerritoryConfiguration.cs` - EmployeeTerritory設定
- E-16: `Tests/Persistence.IntegrationTests/NorthwindDbContextTests.cs` - 既存テストコード
- E-17: `Tests/Application.UnitTests/Common/NorthwindContextFactory.cs` - テスト用ファクトリ

## 3) Claims と根拠の対応（レビューの主戦場）

### NorthwindDbContext関連（UT-PER-001〜UT-PER-013, UT-PER-064〜UT-PER-065）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-PER-001: コンストラクタ（Options のみ） | E-01 (行16-19) | ○ |
| C-02 | UT-PER-002: コンストラクタ（全パラメータ） | E-01 (行21-29) | ○ |
| C-03 | UT-PER-003: SaveChangesAsync新規追加時のCreated設定 | E-01 (行53-70), E-16 (行47-62) | ○ |
| C-04 | UT-PER-004: SaveChangesAsync更新時のLastModified設定 | E-01 (行53-70), E-16 (行64-76) | ○ |
| C-05 | UT-PER-005: AuditableEntity以外は監査対象外 | E-01 (行55) ChangeTracker.Entries<AuditableEntity>() | ○ |
| C-06 | UT-PER-006: ICurrentUserServiceがnullの場合 | E-01 (行60, 64) null安全でないコード | ○ |
| C-07 | UT-PER-007: IDateTimeがnullの場合 | E-01 (行61, 65) null安全でないコード | ○ |
| C-08 | UT-PER-008: OnModelCreating設定適用 | E-01 (行73-76) | ○ |
| C-09 | UT-PER-009〜013: DbSetプロパティ | E-01 (行31-51) | ○ |
| C-10 | UT-PER-064〜065: 複数エンティティ操作 | E-01 (行55-68) foreachによる全エントリ処理 | ○ |

### CategoryConfiguration関連（UT-PER-014〜UT-PER-017）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | UT-PER-014: CategoryIdカラム名 | E-05 (行12) | ○ |
| C-12 | UT-PER-015: CategoryName必須・最大15文字 | E-05 (行14-16) | ○ |
| C-13 | UT-PER-016: Description ntext型 | E-05 (行18) | ○ |
| C-14 | UT-PER-017: Picture image型 | E-05 (行20) | ○ |

### CustomerConfiguration関連（UT-PER-018〜UT-PER-021）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | UT-PER-018: CustomerId最大5文字・値生成なし | E-06 (行11-14) | ○ |
| C-16 | UT-PER-019: CompanyName必須・最大40文字 | E-06 (行20-22) | ○ |
| C-17 | UT-PER-020: アドレス系フィールド最大長 | E-06 (行16, 18, 28, 34, 36) | ○ |
| C-18 | UT-PER-021: ContactName/ContactTitle最大30文字 | E-06 (行24, 26) | ○ |

### EmployeeConfiguration関連（UT-PER-022〜UT-PER-025）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | UT-PER-022: FirstName必須・最大10文字 | E-07 (行23-25) | ○ |
| C-20 | UT-PER-023: LastName必須・最大20文字 | E-07 (行31-33) | ○ |
| C-21 | UT-PER-024: BirthDate/HireDate datetime型 | E-07 (行15, 27) | ○ |
| C-22 | UT-PER-025: Manager自己参照リレーション | E-07 (行49-52) | ○ |

### OrderConfiguration関連（UT-PER-026〜UT-PER-028）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | UT-PER-026: Freight money型・デフォルト0 | E-08 (行19-21) | ○ |
| C-24 | UT-PER-027: 日付フィールド datetime型 | E-08 (行23, 25, 39) | ○ |
| C-25 | UT-PER-028: Shipperリレーション | E-08 (行41-44) | ○ |

### OrderDetailConfiguration関連（UT-PER-029〜UT-PER-033）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | UT-PER-029: 複合主キー設定 | E-09 (行11) | ○ |
| C-27 | UT-PER-030: テーブル名 Order Details | E-09 (行13) | ○ |
| C-28 | UT-PER-031: Quantityデフォルト値1 | E-09 (行19) | ○ |
| C-29 | UT-PER-032: UnitPrice money型 | E-09 (行21) | ○ |
| C-30 | UT-PER-033: ClientSetNull削除動作 | E-09 (行26, 32) | ○ |

### ProductConfiguration関連（UT-PER-034〜UT-PER-036）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | UT-PER-034: ProductName必須・最大40文字 | E-10 (行15-17) | ○ |
| C-32 | UT-PER-035: UnitPrice money型・デフォルト0 | E-10 (行25-27) | ○ |
| C-33 | UT-PER-036: 在庫フィールドデフォルト0 | E-10 (行21, 29, 31) | ○ |

### RegionConfiguration関連（UT-PER-037〜UT-PER-039）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | UT-PER-037: 非クラスタ化インデックス | E-11 (行11-12) | ○ |
| C-35 | UT-PER-038: RegionId値生成なし | E-11 (行15) | ○ |
| C-36 | UT-PER-039: RegionDescription必須・最大50文字 | E-11 (行18-20) | ○ |

### ShipperConfiguration関連（UT-PER-040〜UT-PER-041）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | UT-PER-040: CompanyName必須・最大40文字 | E-12 (行13-15) | ○ |
| C-38 | UT-PER-041: Phone最大24文字 | E-12 (行17) | ○ |

### SupplierConfiguration関連（UT-PER-042〜UT-PER-044）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | UT-PER-042: CompanyName必須・最大40文字 | E-13 (行17-19) | ○ |
| C-40 | UT-PER-043: HomePage ntext型 | E-13 (行29) | ○ |
| C-41 | UT-PER-044: アドレス系フィールド最大長 | E-13 (行11, 13, 25, 31, 35) | ○ |

### TerritoryConfiguration関連（UT-PER-045〜UT-PER-049）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | UT-PER-045: 非クラスタ化・値生成なし | E-14 (行11-12, 16) | ○ |
| C-43 | UT-PER-046: TerritoryId最大20文字 | E-14 (行15) | ○ |
| C-44 | UT-PER-047: TerritoryDescription必須・最大50文字 | E-14 (行21-23) | ○ |
| C-45 | UT-PER-048: Regionリレーション | E-14 (行25-28) | ○ |
| C-46 | UT-PER-049: ClientSetNull削除動作 | E-14 (行28) | ○ |

### EmployeeTerritoryConfiguration関連（UT-PER-050〜UT-PER-053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | UT-PER-050: 複合主キー・非クラスタ化 | E-15 (行11-12) | ○ |
| C-48 | UT-PER-051: TerritoryId最大20文字 | E-15 (行17) | ○ |
| C-49 | UT-PER-052: Employee/Territoryリレーション | E-15 (行20-30) | ○ |
| C-50 | UT-PER-053: ClientSetNull削除動作 | E-15 (行23, 29) | ○ |

### DesignTimeDbContextFactoryBase関連（UT-PER-054〜UT-PER-058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | UT-PER-054: CreateDbContext実装 | E-03 (行15-19) | ○ |
| C-52 | UT-PER-055: 環境変数による設定読み込み | E-03 (行17-18, 29-30) | ○ |
| C-53 | UT-PER-056: 接続文字列null時例外 | E-03 (行41-44) | ○ |
| C-54 | UT-PER-057: 接続文字列空時例外 | E-03 (行41-44) | ○ |
| C-55 | UT-PER-058: CreateNewInstance抽象メソッド | E-03 (行21) | ○ |

### NorthwindDbContextFactory関連（UT-PER-059）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | UT-PER-059: CreateNewInstance実装 | E-02 (行7-10) | ○ |

### DependencyInjection関連（UT-PER-060〜UT-PER-063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | UT-PER-060: DbContext登録 | E-04 (行12-13) | ○ |
| C-58 | UT-PER-061: INorthwindDbContext Scoped登録 | E-04 (行15) | ○ |
| C-59 | UT-PER-062: IServiceCollection返却 | E-04 (行17) | ○ |
| C-60 | UT-PER-063: 接続文字列未設定時の挙動 | E-04 (行13) GetConnectionString使用 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースに対してソースコードから根拠を確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードに基づいて生成されています
- 注意点：
  - UT-PER-006, UT-PER-007: null安全性のテストは実際の挙動確認が必要
  - UT-PER-063: 接続文字列未設定時の挙動はランタイムでの確認が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] SaveChangesAsyncの監査プロパティ設定ロジック（UT-PER-003〜007）が既存テストと整合しているか
- [ ] Configuration設定の必須フィールド・最大長制約がビジネス要件と一致しているか
- [ ] 複合主キー設定（OrderDetail, EmployeeTerritory）が正しいか
- [ ] 外部キーリレーションの削除動作（ClientSetNull）が適切か
- [ ] DependencyInjection設定がアプリケーション全体の設計と整合しているか
