---
generated_at: 2026-01-07 23:45:00
metrics:
  claims_total: 131
  claims_with_evidence: 131
  claims_without_evidence: 0
confidence_derived: 1.00
---

# WebUI モジュール 単体テストケース一覧 根拠レポート

## 1. 概要

本レポートは、WebUI モジュールの単体テストケース一覧（WebUI.csv）の生成根拠を記載するものです。

### 対象モジュール
- **モジュール名**: WebUI
- **レイヤー**: プレゼンテーションレイヤー（ASP.NET Core MVC）
- **総テストケース数**: 131件

### 対象ファイル一覧
| No | ファイルパス | クラス名 |
|----|-------------|---------|
| 1 | Src/WebUI/Controllers/BaseController.cs | BaseController |
| 2 | Src/WebUI/Controllers/CategoriesController.cs | CategoriesController |
| 3 | Src/WebUI/Controllers/CustomersController.cs | CustomersController |
| 4 | Src/WebUI/Controllers/EmployeesController.cs | EmployeesController |
| 5 | Src/WebUI/Controllers/ProductsController.cs | ProductsController |
| 6 | Src/WebUI/Controllers/OidcConfigurationController.cs | OidcConfigurationController |
| 7 | Src/WebUI/Services/CurrentUserService.cs | CurrentUserService |
| 8 | Src/WebUI/Common/CustomExceptionHandlerMiddleware.cs | CustomExceptionHandlerMiddleware |
| 9 | Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs | LoginModel |
| 10 | Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml.cs | RegisterModel |
| 11 | Src/WebUI/Pages/Error.cshtml.cs | ErrorModel |
| 12 | Src/WebUI/Areas/Identity/IdentityHostingStartup.cs | IdentityHostingStartup |
| 13 | Src/WebUI/Program.cs | Program |
| 14 | Src/WebUI/Startup.cs | Startup |

## 2. テストケース生成根拠

### 2.1 BaseController（UT-WUI-001〜003）

**ソースコード根拠**:
```csharp
// Src/WebUI/Controllers/BaseController.cs (Line 9-14)
[ApiController]
[Route("api/[controller]/[action]")]
public abstract class BaseController : ControllerBase
{
    private IMediator _mediator;
    protected IMediator Mediator => _mediator ??= HttpContext.RequestServices.GetService<IMediator>();
}
```

**テスト観点の根拠**:
- `Mediator` プロパティは遅延初期化パターン（null合体演算子）を使用しており、初回アクセス時にDIコンテナから取得
- キャッシュ動作の確認が必要
- `HttpContext` が null の場合の異常系テストが必要

---

### 2.2 CategoriesController（UT-WUI-004〜013）

**ソースコード根拠**:
```csharp
// Src/WebUI/Controllers/CategoriesController.cs (Line 11-41)
[Authorize]
public class CategoriesController : BaseController
{
    [HttpGet]
    [AllowAnonymous]
    public async Task<ActionResult<CategoriesListVm>> GetAll()
    {
        return Ok(await Mediator.Send(new GetCategoriesListQuery()));
    }

    [HttpPost]
    [ProducesResponseType(StatusCodes.Status200OK)]
    [ProducesDefaultResponseType]
    public async Task<IActionResult> Upsert(UpsertCategoryCommand command)
    {
        var id = await Mediator.Send(command);
        return Ok(id);
    }

    [HttpDelete("{id}")]
    [ProducesResponseType(StatusCodes.Status204NoContent)]
    [ProducesResponseType(StatusCodes.Status404NotFound)]
    public async Task<IActionResult> Delete(int id)
    {
        await Mediator.Send(new DeleteCategoryCommand { Id = id });
        return NoContent();
    }
}
```

**テスト観点の根拠**:
- `[Authorize]` 属性がクラスレベルで付与 → 認証テストが必要
- `GetAll` には `[AllowAnonymous]` → 匿名アクセス可能の確認
- `Delete` は `[ProducesResponseType(StatusCodes.Status404NotFound)]` → 404エラーケースが想定されている
- `id` パラメータは `int` 型 → 境界値テスト（0、負数）が必要

---

### 2.3 CustomersController（UT-WUI-014〜027）

**ソースコード根拠**:
```csharp
// Src/WebUI/Controllers/CustomersController.cs (Line 13-63)
[Authorize]
public class CustomersController : BaseController
{
    [HttpGet]
    public async Task<ActionResult<CustomersListVm>> GetAll() { ... }

    [HttpGet("{id}")]
    [ProducesResponseType(StatusCodes.Status200OK)]
    [ProducesResponseType(StatusCodes.Status404NotFound)]
    public async Task<ActionResult<CustomerDetailVm>> Get(string id) { ... }

    [HttpPost]
    [ProducesResponseType(StatusCodes.Status204NoContent)]
    [ProducesDefaultResponseType]
    public async Task<IActionResult> Create([FromBody]CreateCustomerCommand command) { ... }

    [HttpPut("{id}")]
    [ProducesResponseType(StatusCodes.Status204NoContent)]
    [ProducesResponseType(StatusCodes.Status404NotFound)]
    public async Task<IActionResult> Update([FromBody]UpdateCustomerCommand command) { ... }

    [HttpDelete("{id}")]
    [ProducesResponseType(StatusCodes.Status204NoContent)]
    [ProducesResponseType(StatusCodes.Status404NotFound)]
    public async Task<IActionResult> Delete(string id) { ... }
}
```

**テスト観点の根拠**:
- 全メソッドに `[Authorize]` が適用 → 認証テストが必要
- `Get`、`Update`、`Delete` に `[ProducesResponseType(StatusCodes.Status404NotFound)]` → 存在しないリソースのエラーケース
- `id` は `string` 型 → 空文字、null の境界値テストが必要
- `[FromBody]` 属性 → リクエストボディのバリデーションテストが必要

---

### 2.4 EmployeesController（UT-WUI-028〜038）

**ソースコード根拠**:
```csharp
// Src/WebUI/Controllers/EmployeesController.cs (Line 11-49)
public class EmployeesController : BaseController
{
    [HttpGet]
    [ProducesResponseType(StatusCodes.Status200OK)]
    public async Task<ActionResult<IList<EmployeeLookupDto>>> GetAll() { ... }

    [HttpGet("{id}")]
    [ProducesResponseType(StatusCodes.Status200OK)]
    public async Task<ActionResult<EmployeeDetailVm>> Get(int id) { ... }

    [HttpPost]
    [ProducesResponseType(StatusCodes.Status204NoContent)]
    [ProducesDefaultResponseType]
    public async Task<IActionResult> Upsert(UpsertEmployeeCommand command) { ... }

    [HttpDelete("{id}")]
    [ProducesResponseType(StatusCodes.Status204NoContent)]
    [ProducesResponseType(StatusCodes.Status404NotFound)]
    public async Task<IActionResult> Delete(int id) { ... }
}
```

**テスト観点の根拠**:
- クラスレベルに `[Authorize]` がない → 認証不要のエンドポイント
- `id` は `int` 型 → 境界値テスト（0、負数）が必要
- `Upsert` パターン → 新規作成と更新の両方のテストが必要

---

### 2.5 ProductsController（UT-WUI-039〜054）

**ソースコード根拠**:
```csharp
// Src/WebUI/Controllers/ProductsController.cs (Line 14-71)
[Authorize]
public class ProductsController : BaseController
{
    [HttpGet]
    [AllowAnonymous]
    public async Task<ActionResult<ProductsListVm>> GetAll() { ... }

    [HttpGet("{id}")]
    [AllowAnonymous]
    public async Task<ActionResult<ProductDetailVm>> Get(int id) { ... }

    [HttpPost]
    public async Task<ActionResult<int>> Create([FromBody] CreateProductCommand command) { ... }

    [HttpPut]
    [ProducesResponseType(StatusCodes.Status204NoContent)]
    [ProducesDefaultResponseType]
    public async Task<IActionResult> Update([FromBody] UpdateProductCommand command) { ... }

    [HttpDelete("{id}")]
    [ProducesResponseType(StatusCodes.Status204NoContent)]
    [ProducesDefaultResponseType]
    public async Task<IActionResult> Delete(int id) { ... }

    [HttpGet]
    [AllowAnonymous]
    public async Task<FileResult> Download()
    {
        var vm = await Mediator.Send(new GetProductsFileQuery());
        return File(vm.Content, vm.ContentType, vm.FileName);
    }
}
```

**テスト観点の根拠**:
- `GetAll`、`Get`、`Download` に `[AllowAnonymous]` → 匿名アクセス可能
- `Create`、`Update`、`Delete` は認証必要（クラスレベルの `[Authorize]`）
- `Download` は `FileResult` を返却 → ファイルダウンロード機能のテスト

---

### 2.6 OidcConfigurationController（UT-WUI-055〜058）

**ソースコード根拠**:
```csharp
// Src/WebUI/Controllers/OidcConfigurationController.cs (Line 7-27)
[ApiExplorerSettings(IgnoreApi = true)]
public class OidcConfigurationController : Controller
{
    private readonly ILogger<OidcConfigurationController> logger;

    public OidcConfigurationController(IClientRequestParametersProvider clientRequestParametersProvider, ILogger<OidcConfigurationController> _logger)
    {
        ClientRequestParametersProvider = clientRequestParametersProvider;
        logger = _logger;
    }

    public IClientRequestParametersProvider ClientRequestParametersProvider { get; }

    [HttpGet("_configuration/{clientId}")]
    public IActionResult GetClientRequestParameters([FromRoute]string clientId)
    {
        var parameters = ClientRequestParametersProvider.GetClientParameters(HttpContext, clientId);
        return Ok(parameters);
    }
}
```

**テスト観点の根拠**:
- `Controller` を継承（`BaseController` ではない）→ 独自のコンストラクタDIパターン
- `clientId` は `string` 型 → 空文字、存在しないIDのテストが必要
- `[ApiExplorerSettings(IgnoreApi = true)]` → Swagger/OpenAPIから除外される内部API

---

### 2.7 CurrentUserService（UT-WUI-059〜065）

**ソースコード根拠**:
```csharp
// Src/WebUI/Services/CurrentUserService.cs (Line 7-19)
public class CurrentUserService : ICurrentUserService
{
    public CurrentUserService(IHttpContextAccessor httpContextAccessor)
    {
        UserId = httpContextAccessor.HttpContext?.User?.FindFirstValue(ClaimTypes.NameIdentifier);
        IsAuthenticated = UserId != null;
    }

    public string UserId { get; }
    public bool IsAuthenticated { get; }
}
```

**テスト観点の根拠**:
- null条件演算子（`?.`）の連鎖 → 各段階でのnullケースのテストが必要
- `ClaimTypes.NameIdentifier` からのClaim取得 → 認証済み/未認証のテスト
- `IsAuthenticated` は `UserId != null` に依存 → 連動性のテスト

---

### 2.8 CustomExceptionHandlerMiddleware（UT-WUI-066〜073）

**ソースコード根拠**:
```csharp
// Src/WebUI/Common/CustomExceptionHandlerMiddleware.cs (Line 11-72)
public class CustomExceptionHandlerMiddleware
{
    private readonly RequestDelegate _next;

    public CustomExceptionHandlerMiddleware(RequestDelegate next)
    {
        _next = next;
    }

    public async Task Invoke(HttpContext context)
    {
        try
        {
            await _next(context);
        }
        catch (Exception ex)
        {
            await HandleExceptionAsync(context, ex);
        }
    }

    private Task HandleExceptionAsync(HttpContext context, Exception exception)
    {
        var code = HttpStatusCode.InternalServerError;
        var result = string.Empty;

        switch (exception)
        {
            case ValidationException validationException:
                code = HttpStatusCode.BadRequest;
                result = JsonConvert.SerializeObject(validationException.Failures);
                break;
            case BadRequestException badRequestException:
                code = HttpStatusCode.BadRequest;
                result = badRequestException.Message;
                break;
            case NotFoundException _:
                code = HttpStatusCode.NotFound;
                break;
        }

        context.Response.ContentType = "application/json";
        context.Response.StatusCode = (int)code;

        if (result == string.Empty)
        {
            result = JsonConvert.SerializeObject(new { error = exception.Message });
        }

        return context.Response.WriteAsync(result);
    }
}
```

**テスト観点の根拠**:
- `switch` 文による例外タイプ別処理 → 各例外タイプのテストが必要
  - `ValidationException` → 400 BadRequest + Failures JSON
  - `BadRequestException` → 400 BadRequest + Message
  - `NotFoundException` → 404 NotFound
  - その他 → 500 InternalServerError + error JSON
- `Content-Type: application/json` の設定確認

---

### 2.9 LoginModel（UT-WUI-074〜088）

**ソースコード根拠**:
```csharp
// Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs (Line 19-140)
[AllowAnonymous]
public class LoginModel : PageModel
{
    public class InputModel
    {
        [Required]
        [EmailAddress]
        public string Email { get; set; }

        [Required]
        [DataType(DataType.Password)]
        public string Password { get; set; }

        [Display(Name = "Remember me?")]
        public bool RememberMe { get; set; }
    }

    public async Task OnGetAsync(string returnUrl = null) { ... }
    public async Task<IActionResult> OnPostAsync(string returnUrl = null) { ... }
    public async Task<IActionResult> OnPostSendVerificationEmailAsync() { ... }
}
```

**テスト観点の根拠**:
- `[Required]` 属性 → 必須バリデーションのテスト
- `[EmailAddress]` 属性 → メール形式バリデーションのテスト
- `OnPostAsync` 内の条件分岐:
  - `result.Succeeded` → ログイン成功
  - `result.RequiresTwoFactor` → 2FA必要
  - `result.IsLockedOut` → ロックアウト状態
  - その他 → ログイン失敗

---

### 2.10 RegisterModel（UT-WUI-089〜102）

**ソースコード根拠**:
```csharp
// Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml.cs (Line 21-115)
[AllowAnonymous]
public class RegisterModel : PageModel
{
    public class InputModel
    {
        [Required]
        [EmailAddress]
        [Display(Name = "Email")]
        public string Email { get; set; }

        [Required]
        [StringLength(100, ErrorMessage = "The {0} must be at least {2} and at max {1} characters long.", MinimumLength = 6)]
        [DataType(DataType.Password)]
        [Display(Name = "Password")]
        public string Password { get; set; }

        [DataType(DataType.Password)]
        [Display(Name = "Confirm password")]
        [Compare("Password", ErrorMessage = "The password and confirmation password do not match.")]
        public string ConfirmPassword { get; set; }
    }

    public async Task OnGetAsync(string returnUrl = null) { ... }
    public async Task<IActionResult> OnPostAsync(string returnUrl = null) { ... }
}
```

**テスト観点の根拠**:
- `[StringLength(100, MinimumLength = 6)]` → 文字数境界値テスト（5文字、6文字、100文字、101文字）
- `[Compare("Password")]` → パスワード一致バリデーション
- `RequireConfirmedAccount` 設定による分岐 → 確認メール要否のテスト

---

### 2.11 ErrorModel（UT-WUI-103〜108）

**ソースコード根拠**:
```csharp
// Src/WebUI/Pages/Error.cshtml.cs (Line 9-27)
[ResponseCache(Duration = 0, Location = ResponseCacheLocation.None, NoStore = true)]
public class ErrorModel : PageModel
{
    private readonly ILogger<ErrorModel> _logger;

    public ErrorModel(ILogger<ErrorModel> logger)
    {
        _logger = logger;
    }

    public string RequestId { get; set; }
    public bool ShowRequestId => !string.IsNullOrEmpty(RequestId);

    public void OnGet()
    {
        RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier;
    }
}
```

**テスト観点の根拠**:
- `Activity.Current?.Id ?? HttpContext.TraceIdentifier` → 2つのソースからのID取得
- `ShowRequestId` プロパティ → `string.IsNullOrEmpty` による判定

---

### 2.12 IdentityHostingStartup（UT-WUI-109）

**ソースコード根拠**:
```csharp
// Src/WebUI/Areas/Identity/IdentityHostingStartup.cs (Line 9-18)
[assembly: HostingStartup(typeof(Northwind.WebUI.Areas.Identity.IdentityHostingStartup))]
namespace Northwind.WebUI.Areas.Identity
{
    public class IdentityHostingStartup : IHostingStartup
    {
        public void Configure(IWebHostBuilder builder)
        {
            builder.ConfigureServices((context, services) => { });
        }
    }
}
```

**テスト観点の根拠**:
- 現在は空実装 → 将来の拡張に備えた最小限のテスト

---

### 2.13 Program（UT-WUI-110〜119）

**ソースコード根拠**:
```csharp
// Src/WebUI/Program.cs (Line 20-78)
public class Program
{
    public static async Task Main(string[] args)
    {
        var host = CreateWebHostBuilder(args).Build();

        using (var scope = host.Services.CreateScope())
        {
            var services = scope.ServiceProvider;
            try
            {
                var northwindContext = services.GetRequiredService<NorthwindDbContext>();
                northwindContext.Database.Migrate();

                var identityContext = services.GetRequiredService<ApplicationDbContext>();
                identityContext.Database.Migrate();

                var mediator = services.GetRequiredService<IMediator>();
                await mediator.Send(new SeedSampleDataCommand(), CancellationToken.None);
            }
            catch (Exception ex)
            {
                var logger = scope.ServiceProvider.GetRequiredService<ILogger<Program>>();
                logger.LogError(ex, "An error occurred while migrating or initializing the database.");
            }
        }

        host.Run();
    }

    public static IWebHostBuilder CreateWebHostBuilder(string[] args) =>
        WebHost.CreateDefaultBuilder(args)
            .ConfigureAppConfiguration((hostingContext, config) =>
            {
                var env = hostingContext.HostingEnvironment;
                config.AddJsonFile("appsettings.json", optional: true, reloadOnChange: true)
                    .AddJsonFile($"appsettings.{env.EnvironmentName}.json", optional: true, reloadOnChange: true)
                    .AddJsonFile($"appsettings.Local.json", optional: true, reloadOnChange: true);

                if (env.IsDevelopment())
                {
                    var appAssembly = Assembly.Load(new AssemblyName(env.ApplicationName));
                    if (appAssembly != null)
                    {
                        config.AddUserSecrets(appAssembly, optional: true);
                    }
                }

                config.AddEnvironmentVariables();
                if (args != null)
                {
                    config.AddCommandLine(args);
                }
            })
            .UseStartup<Startup>();
}
```

**テスト観点の根拠**:
- データベースマイグレーション処理 → 正常系/異常系のテスト
- シードデータ投入 → `SeedSampleDataCommand` の実行確認
- 設定ファイル読み込み順序 → 各設定ソースのテスト

---

### 2.14 Startup（UT-WUI-120〜131）

**ソースコード根拠**:
```csharp
// Src/WebUI/Startup.cs (Line 19-153)
public class Startup
{
    public void ConfigureServices(IServiceCollection services)
    {
        services.AddInfrastructure(Configuration, Environment);
        services.AddPersistence(Configuration);
        services.AddApplication();
        services.AddHealthChecks().AddDbContextCheck<NorthwindDbContext>();
        services.AddScoped<ICurrentUserService, CurrentUserService>();
        services.AddHttpContextAccessor();
        // ... more configuration
    }

    public void Configure(IApplicationBuilder app)
    {
        if (Environment.IsDevelopment())
        {
            app.UseDeveloperExceptionPage();
            app.UseDatabaseErrorPage();
            RegisteredServicesPage(app);
        }
        else
        {
            app.UseExceptionHandler("/Error");
            app.UseHsts();
        }

        app.UseCustomExceptionHandler();
        app.UseHealthChecks("/health");
        app.UseAuthentication();
        app.UseIdentityServer();
        app.UseAuthorization();
        // ... more middleware
    }
}
```

**テスト観点の根拠**:
- DIコンテナへのサービス登録 → 各サービスの登録確認
- 環境別ミドルウェア構成 → Development/Production の分岐テスト
- ミドルウェアパイプラインの順序 → 認証/認可の正しい順序確認

---

## 3. テスト観点カバレッジ

| テスト観点 | テストケース数 | 割合 |
|-----------|--------------|------|
| 正常系 | 68 | 51.9% |
| 異常系 | 42 | 32.1% |
| 境界値 | 21 | 16.0% |
| **合計** | **131** | **100%** |

## 4. 優先度分布

| 優先度 | テストケース数 | 割合 |
|--------|--------------|------|
| 高 | 72 | 55.0% |
| 中 | 54 | 41.2% |
| 低 | 5 | 3.8% |
| **合計** | **131** | **100%** |

## 5. 備考

- 全てのテストケースはソースコードの解析に基づいて生成されています
- 統合テスト向けのケース（Program.Main など）は単体テストとしては実装が難しい場合があります
- ASP.NET Core のテスト機能（`WebApplicationFactory`、`TestServer`）の活用を推奨します
- Identity関連のテストには `UserManager`、`SignInManager` のモックが必要です
