---
generated_at: 2026-01-07 12:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された受入テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **UAT-038 Remember me機能**：フロントエンド実装の詳細確認が必要
  2. **UAT-039 エラーハンドリング**：エラー画面表示の詳細な動作確認が必要
  3. **UAT-033 従業員作成**：認可なしでの作成が意図した動作か確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Controllers/CustomersController.cs` - 顧客コントローラー
- E-02: `Src/WebUI/Controllers/ProductsController.cs` - 商品コントローラー
- E-03: `Src/WebUI/Controllers/CategoriesController.cs` - カテゴリコントローラー
- E-04: `Src/WebUI/Controllers/EmployeesController.cs` - 従業員コントローラー
- E-05: `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs` - ログインページ
- E-06: `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml.cs` - 登録ページ
- E-07: `Src/WebUI/ClientApp/src/app/app.routing.module.ts` - ルーティング設定
- E-08: `Src/WebUI/ClientApp/src/api-authorization/authorize.guard.ts` - 認可ガード
- E-09: `Src/WebUI/ClientApp/src/app/customers/customers.component.ts` - 顧客コンポーネント
- E-10: `Src/WebUI/ClientApp/src/app/products/products.component.ts` - 商品コンポーネント
- E-11: `Src/WebUI/ClientApp/src/app/customer-detail/customer-detail.component.ts` - 顧客詳細コンポーネント
- E-12: `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommandValidator.cs` - 顧客作成バリデーター
- E-13: `Src/Application/Customers/Commands/UpdateCustomer/UpdateCustomerCommand.cs` - 顧客更新コマンド
- E-14: `Src/Application/Customers/Commands/DeleteCustomer/DeleteCustomerCommand.cs` - 顧客削除コマンド
- E-15: `Src/Domain/Entities/Customer.cs` - 顧客エンティティ
- E-16: `Src/Domain/Entities/Product.cs` - 商品エンティティ
- E-17: `Tests/WebUI.IntegrationTests/Controllers/Customers/GetAll.cs` - 顧客一覧取得テスト
- E-18: `Tests/WebUI.IntegrationTests/Controllers/Customers/Create.cs` - 顧客作成テスト
- E-19: `Tests/WebUI.IntegrationTests/Controllers/Products/GetAll.cs` - 商品一覧取得テスト
- E-20: `Src/WebUI/ClientApp/e2e/src/app.e2e-spec.ts` - E2Eテスト
- E-21: `Src/WebUI/Common/CustomExceptionHandlerMiddleware.cs` - 例外ハンドラー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-001 | 新規ユーザー登録が正常に完了する | E-06 | ○ |
| UAT-002 | パスワード不一致時のバリデーションエラー | E-06 (InputModel.ConfirmPassword Compare属性) | ○ |
| UAT-003 | 不正なメールアドレス形式でのバリデーションエラー | E-06 (EmailAddress属性) | ○ |
| UAT-004 | 正しい認証情報でログインが成功する | E-05 | ○ |
| UAT-005 | 誤った認証情報でログインが失敗する | E-05 (lockoutOnFailure: true) | ○ |
| UAT-006 | アカウントロックアウト後のログイン試行 | E-05 (result.IsLockedOut) | ○ |
| UAT-007 | ホーム画面が正常に表示される | E-20 | ○ |
| UAT-008 | 顧客一覧が正常に表示される | E-01, E-09, E-17 | ○ |
| UAT-009 | 未認証時に顧客一覧へのアクセスがリダイレクトされる | E-07, E-08 | ○ |
| UAT-010 | 顧客詳細がモーダルで表示される | E-09, E-11 | ○ |
| UAT-011 | 顧客詳細モーダルを閉じる | E-11 (closeModal) | ○ |
| UAT-012 | 新規顧客が正常に作成される | E-01, E-12, E-18 | ○ |
| UAT-013 | 必須項目未入力時のバリデーションエラー | E-12 (NotEmpty) | ○ |
| UAT-014 | 顧客ID文字数バリデーション | E-12 (Length(5)) | ○ |
| UAT-015 | 既存顧客情報が正常に更新される | E-01, E-13 | ○ |
| UAT-016 | 存在しない顧客の更新でエラーが返される | E-13 (NotFoundException) | ○ |
| UAT-017 | 既存顧客が正常に削除される | E-01, E-14 | ○ |
| UAT-018 | 存在しない顧客の削除でエラーが返される | E-14 | ○ |
| UAT-019 | 商品一覧が正常に表示される（匿名） | E-02 (AllowAnonymous), E-10, E-19 | ○ |
| UAT-020 | 認証ユーザーで商品一覧が表示される | E-02, E-10 | ○ |
| UAT-021 | 商品詳細が正常に取得される | E-02 (Get, AllowAnonymous) | ○ |
| UAT-022 | 新規商品が正常に作成される | E-02 (Create) | ○ |
| UAT-023 | 未認証時の商品作成が拒否される | E-02 (Authorize属性) | ○ |
| UAT-024 | 既存商品情報が正常に更新される | E-02 (Update) | ○ |
| UAT-025 | 既存商品が正常に削除される | E-02 (Delete) | ○ |
| UAT-026 | 商品一覧ファイルがダウンロードされる | E-02 (Download, AllowAnonymous) | ○ |
| UAT-027 | カテゴリ一覧が正常に取得される | E-03 (GetAll, AllowAnonymous) | ○ |
| UAT-028 | 新規カテゴリが正常に作成される | E-03 (Upsert) | ○ |
| UAT-029 | 既存カテゴリが正常に更新される | E-03 (Upsert) | ○ |
| UAT-030 | 既存カテゴリが正常に削除される | E-03 (Delete) | ○ |
| UAT-031 | 従業員一覧が正常に取得される | E-04 (GetAll) | ○ |
| UAT-032 | 従業員詳細が正常に取得される | E-04 (Get) | ○ |
| UAT-033 | 新規従業員が正常に作成される | E-04 (Upsert) | △ |
| UAT-034 | 既存従業員が正常に削除される | E-04 (Delete) | ○ |
| UAT-035 | ホーム画面から商品画面への遷移 | E-07 | ○ |
| UAT-036 | ホーム画面から顧客画面への遷移 | E-07 | ○ |
| UAT-037 | ログアウトが正常に実行される | E-05 | ○ |
| UAT-038 | Remember me機能でセッションが維持される | E-05 (Input.RememberMe) | △ |
| UAT-039 | システムエラー時にエラー画面が表示される | E-21 | △ |
| UAT-040 | 住所フィールドの最大文字数バリデーション | E-12 (MaximumLength(60)) | ○ |
| UAT-041 | 市区町村フィールドの最大文字数バリデーション | E-12 (MaximumLength(15)) | ○ |
| UAT-042 | 電話番号フィールドの最大文字数バリデーション | E-12 (MaximumLength(24)) | ○ |
| UAT-043 | アプリケーション起動時にウェルカムメッセージが表示される | E-20 | ○ |
| UAT-044 | 顧客作成後に一覧に反映される | E-01, E-17, E-18 | ○ |
| UAT-045 | 商品更新後に詳細に反映される | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UAT-033（従業員作成）**: EmployeesControllerにAuthorize属性がないため、匿名ユーザーでも従業員の作成・更新・削除が可能になっている。これが意図した設計かどうかの確認が必要
  - 候補：セキュリティ要件定義書 / アクセス制御設計書 / 業務要件書
- **UAT-038（Remember me）**: Remember meの具体的な有効期間やセッション維持の詳細実装がコードから確認できない
  - 候補：認証設計書 / ASP.NET Identity設定ファイル
- **UAT-039（エラーハンドリング）**: CustomExceptionHandlerMiddlewareの存在は確認できるが、エラー画面（Error.cshtml）への具体的な遷移条件の詳細確認が必要
  - 候補：エラーハンドリング設計書 / 画面設計書

## 5) リスクフラグ（レビュー観点）
- **2 高リスク**: EmployeesControllerに認可属性がなく、従業員データの作成・更新・削除が認証なしで可能。セキュリティ上の懸念あり
- **1 中リスク**: 顧客管理APIのバリデーションは確認できるが、商品・カテゴリ・従業員のバリデータークラスは未確認
- **0 低リスク**: E2Eテストは基本的なウェルカムメッセージ確認のみで、主要な業務フローのE2Eテストが不足

## 6) レビュアーチェックリスト（最小）
- [ ] EmployeesControllerの認可要件を確認し、必要に応じてAuthorize属性を追加するか検討
- [ ] UAT-033～034の従業員関連テストケースについて、期待されるユーザーロールを確認
- [ ] Remember me機能の有効期間がビジネス要件を満たしているか確認
- [ ] 商品・カテゴリ作成時のバリデーション要件を確認し、必要に応じてテストケースを追加
- [ ] エラー発生時のユーザー体験（エラーメッセージの表示内容）が適切か確認
