---
generated_at: 2026-01-07 21:45:00
metrics:
  claims_total: 5
  claims_with_evidence: 5
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：5 / 5、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/Application/Products/Queries/GetProductsFile/GetProductsFileQuery.cs` - 商品ファイル取得クエリ定義
- E-02: `Src/Application/Products/Queries/GetProductsFile/GetProductsFileQueryHandler.cs` - 商品ファイル取得ハンドラ実装
- E-03: `Src/Application/Products/Queries/GetProductsFile/ProductsFileVm.cs` - 商品ファイルビューモデル定義
- E-04: `Src/Application/Products/Queries/GetProductsFile/ProductRecordDto.cs` - 商品レコードDTO定義（出力項目）
- E-05: `Src/Infrastructure/Files/CsvFileBuilder.cs` - CSVファイルビルダー実装
- E-06: `Src/Infrastructure/Files/ProductFileRecordMap.cs` - 商品ファイルレコードマッピング設定
- E-07: `Src/WebUI/Controllers/ProductsController.cs` - 商品コントローラ（Download APIエンドポイント）
- E-08: `Src/Application/Common/Interfaces/ICsvFileBuilder.cs` - CSVファイルビルダーインターフェース定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 商品一覧CSVという帳票が存在する | E-01, E-02, E-07 | ○ |
| C-02 | カテゴリ名、商品名、単価、販売終了フラグを出力する | E-04 | ○ |
| C-03 | CSV形式で出力される | E-03, E-05 | ○ |
| C-04 | ファイル名は「yyyy-MM-dd-Products.csv」形式 | E-02 | ○ |
| C-05 | 単価は通貨形式で出力される | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの主張はありません。全ての主張がソースコードに基づいています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能であり、信頼性が高い。

## 6) レビュアーチェックリスト（最小）
- [ ] 商品一覧CSV以外に帳票機能が存在しないことを確認
- [ ] 出力項目（Category, Name, UnitPrice, Discontinued）が仕様と一致しているか確認
- [ ] ファイル名形式がビジネス要件と一致しているか確認
