# 帳票設計書 1-商品一覧CSV

## 概要

本ドキュメントは、Northwind Tradersシステムにおける商品一覧CSVエクスポート機能の帳票設計書です。

### 本帳票の処理概要

商品マスタに登録されている全商品データをCSV形式でエクスポートする機能です。商品管理業務において、外部システムとのデータ連携や、商品データのバックアップ・分析用途に使用されます。

**業務上の目的・背景**：商品管理担当者が、商品マスタデータを外部ツール（Excel等）で分析・加工したり、他システムへデータ連携する際に利用します。また、定期的なデータバックアップや棚卸業務における商品リスト確認にも活用されます。

**帳票の利用シーン**：商品データの棚卸確認、外部システムへのデータ連携、商品分析レポート作成時のデータ抽出、マスタデータのバックアップ取得など。

**主要な出力内容**：
1. カテゴリ名（Category）：商品が属するカテゴリの名称
2. 商品名（Name）：商品の名称
3. 単価（Unit Price）：商品の販売単価（通貨形式）
4. 販売終了フラグ（Discontinued）：商品の販売終了状態

**帳票の出力タイミング**：ユーザーがAPI経由でダウンロードリクエストを実行した時点で即時生成・出力されます。

**帳票の利用者**：商品管理担当者、在庫管理担当者、システム管理者

## 帳票種別

一覧表（CSVエクスポート）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Products API | GET /api/products/download | APIリクエスト |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | CSV |
| 用紙サイズ | - |
| 向き | - |
| ファイル名 | {yyyy-MM-dd}-Products.csv |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8 |

### CSV固有設定

| 項目 | 内容 |
|-----|------|
| 区切り文字 | カンマ（,） |
| ヘッダー行 | 有 |
| 囲み文字 | 必要に応じてダブルクォーテーション |
| ライブラリ | CsvHelper |

## 帳票レイアウト

### レイアウト概要

CSV形式のため、ヘッダー行＋データ行の構成となります。

```
┌─────────────────────────────────────┐
│         ヘッダー行（列名）            │
├─────────────────────────────────────┤
│         データ行（商品データ）         │
│              ...                    │
│              ...                    │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Category | カテゴリ名 | Categories.CategoryName | 文字列 |
| 2 | Name | 商品名 | Products.ProductName | 文字列 |
| 3 | Unit Price | 単価 | Products.UnitPrice | 通貨形式（C） |
| 4 | Discontinued | 販売終了フラグ | Products.Discontinued | True/False |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Category | カテゴリ名 | Categories.CategoryName | 文字列 | 可変 |
| 2 | Name | 商品名 | Products.ProductName | 文字列 | 可変 |
| 3 | Unit Price | 単価 | Products.UnitPrice | 通貨形式（$0.00等） | 可変 |
| 4 | Discontinued | 販売終了フラグ | Products.Discontinued | True/False | 可変 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| - | - | フッター部なし | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| なし | 全商品を抽出（フィルタ条件なし） | - |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| - | なし | データベースのデフォルト順序 |

### 改ページ条件

CSV形式のため改ページなし

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| Products | 商品マスタ | メインテーブル |
| Categories | カテゴリマスタ | Products.CategoryId = Categories.CategoryId (LEFT JOIN) |

### テーブル別参照項目詳細

#### Products

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| ProductName | Name | 全件取得 | - |
| UnitPrice | Unit Price | 全件取得 | null時は0として出力 |
| Discontinued | Discontinued | 全件取得 | - |
| CategoryId | - | JOIN条件用 | - |

#### Categories

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| CategoryId | - | JOIN条件用 | - |
| CategoryName | Category | JOIN結果 | null時は空文字 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Unit Price | UnitPrice ?? 0 | - | null時は0に置換後、通貨形式（C）で文字列変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[GET /api/products/download] --> B[ProductsController.Download]
    B --> C[GetProductsFileQuery発行]
    C --> D[GetProductsFileQueryHandler.Handle]
    D --> E[Products取得<br/>ProjectTo&lt;ProductRecordDto&gt;]
    E --> F[ICsvFileBuilder.BuildProductsFile]
    F --> G[CsvHelper でCSV生成]
    G --> H[ProductsFileVm 生成]
    H --> I[FileResult返却]
    I --> J[CSVダウンロード完了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 商品データが0件 | - | 空のCSV（ヘッダーのみ）を出力 |
| DB接続エラー | データベース接続失敗 | 500 Internal Server Error | システム管理者に連絡 |
| 認証エラー | 未認証（ただしAllowAnonymous指定） | - | 現状は匿名アクセス許可 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百〜数千件 |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | 特に制限なし |

## セキュリティ考慮事項

- 本APIは`[AllowAnonymous]`属性が付与されており、認証なしでアクセス可能
- 商品データは機密性が低いためこの設定だが、本番環境では要件に応じて認証を検討
- 出力データに個人情報は含まれない

## 備考

- CsvHelperライブラリを使用してCSV生成を行う
- ファイル名の日付は出力時点のサーバー日時（IDateTime.Now）を使用
- 単価の通貨形式はサーバーのカルチャ設定に依存

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、帳票出力に使用されるDTO（Data Transfer Object）の構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ProductRecordDto.cs | `Src/Application/Products/Queries/GetProductsFile/ProductRecordDto.cs` | CSV出力する4項目（Category, Name, UnitPrice, Discontinued）の定義。AutoMapperによるマッピング設定を確認。 |
| 1-2 | ProductsFileVm.cs | `Src/Application/Products/Queries/GetProductsFile/ProductsFileVm.cs` | 最終出力結果（FileName, ContentType, Content）の構造。 |

**読解のコツ**: `IMapFrom<Product>`インターフェースとMappingメソッドで、ProductエンティティからProductRecordDtoへの変換ルールが定義されています。

#### Step 2: エントリーポイントを理解する

処理の起点となるControllerを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProductsController.cs | `Src/WebUI/Controllers/ProductsController.cs` | Downloadメソッド（63-70行目）がエントリーポイント。GetProductsFileQueryを発行しFileResultを返却。 |

**主要処理フロー**:
1. **63行目**: `[HttpGet]`と`[AllowAnonymous]`属性でルーティング定義
2. **65行目**: `Download()`メソッドがエントリーポイント
3. **67行目**: `Mediator.Send(new GetProductsFileQuery())`でクエリ発行
4. **69行目**: `File(vm.Content, vm.ContentType, vm.FileName)`でファイル返却

#### Step 3: クエリハンドラを理解する

CQRSパターンのQueryHandler層を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GetProductsFileQuery.cs | `Src/Application/Products/Queries/GetProductsFile/GetProductsFileQuery.cs` | パラメータなしのクエリ定義。 |
| 3-2 | GetProductsFileQueryHandler.cs | `Src/Application/Products/Queries/GetProductsFile/GetProductsFileQueryHandler.cs` | メイン処理ロジック。DBからProductを取得し、CSVに変換、ファイル名生成。 |

**主要処理フロー**:
- **27-43行目**: Handleメソッドでメイン処理
- **29-31行目**: `_context.Products.ProjectTo<ProductRecordDto>()`でDB取得＋マッピング
- **33行目**: `_fileBuilder.BuildProductsFile(records)`でCSV生成
- **35-40行目**: ProductsFileVm構築（ファイル名は`{yyyy-MM-dd}-Products.csv`形式）

#### Step 4: CSV生成処理を理解する

Infrastructure層のCSV生成実装を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ICsvFileBuilder.cs | `Src/Application/Common/Interfaces/ICsvFileBuilder.cs` | インターフェース定義。 |
| 4-2 | CsvFileBuilder.cs | `Src/Infrastructure/Files/CsvFileBuilder.cs` | CsvHelperを使用したCSV生成実装。 |
| 4-3 | ProductFileRecordMap.cs | `Src/Infrastructure/Files/ProductFileRecordMap.cs` | CSVカラム名と書式設定。UnitPriceを"Unit Price"として通貨形式で出力。 |

**主要処理フロー**:
- **CsvFileBuilder.cs 11-22行目**: MemoryStreamにCSV書き込み
- **ProductFileRecordMap.cs 10-11行目**: AutoMapと単価の通貨形式変換

#### Step 5: ドメインエンティティを理解する

データソースとなるエンティティを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | Product.cs | `Src/Domain/Entities/Product.cs` | 商品エンティティ。ProductName, UnitPrice, Discontinued, CategoryIdなど。 |
| 5-2 | Category.cs | `Src/Domain/Entities/Category.cs` | カテゴリエンティティ。CategoryNameがCSV出力に使用される。 |

### プログラム呼び出し階層図

```
ProductsController.Download()
    │
    └─ Mediator.Send(GetProductsFileQuery)
           │
           └─ GetProductsFileQueryHandler.Handle()
                  │
                  ├─ _context.Products.ProjectTo<ProductRecordDto>()
                  │      └─ AutoMapper: Product → ProductRecordDto
                  │              └─ Category.CategoryName → Category
                  │              └─ ProductName → Name
                  │
                  └─ _fileBuilder.BuildProductsFile(records)
                         └─ CsvFileBuilder.BuildProductsFile()
                                └─ CsvHelper + ProductFileRecordMap
                                       └─ UnitPrice → "Unit Price" (通貨形式)
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト ───▶ ProductsController     ───▶ FileResult
GET /api/           │                            │
products/download   ▼                            ▼
                GetProductsFileQuery         CSVファイル
                    │                     {yyyy-MM-dd}-Products.csv
                    ▼
             QueryHandler
                    │
    ┌───────────────┼───────────────┐
    ▼               ▼               ▼
Products       Categories      AutoMapper
 テーブル         テーブル          (DTO変換)
    │               │               │
    └───────────────┴───────────────┘
                    │
                    ▼
              ProductRecordDto[]
                    │
                    ▼
              CsvFileBuilder
                    │
                    ▼
              byte[] (CSV)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ProductsController.cs | `Src/WebUI/Controllers/ProductsController.cs` | ソース | APIエンドポイント定義 |
| GetProductsFileQuery.cs | `Src/Application/Products/Queries/GetProductsFile/GetProductsFileQuery.cs` | ソース | クエリ定義 |
| GetProductsFileQueryHandler.cs | `Src/Application/Products/Queries/GetProductsFile/GetProductsFileQueryHandler.cs` | ソース | クエリハンドラ（メイン処理） |
| ProductRecordDto.cs | `Src/Application/Products/Queries/GetProductsFile/ProductRecordDto.cs` | ソース | CSVレコードDTO |
| ProductsFileVm.cs | `Src/Application/Products/Queries/GetProductsFile/ProductsFileVm.cs` | ソース | 出力結果ViewModel |
| ICsvFileBuilder.cs | `Src/Application/Common/Interfaces/ICsvFileBuilder.cs` | ソース | CSV生成インターフェース |
| CsvFileBuilder.cs | `Src/Infrastructure/Files/CsvFileBuilder.cs` | ソース | CSV生成実装 |
| ProductFileRecordMap.cs | `Src/Infrastructure/Files/ProductFileRecordMap.cs` | ソース | CSVマッピング設定 |
| Product.cs | `Src/Domain/Entities/Product.cs` | ソース | 商品エンティティ |
| Category.cs | `Src/Domain/Entities/Category.cs` | ソース | カテゴリエンティティ |
