---
generated_at: 2026-01-08 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-商品一覧CSV.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（想定データ件数・目標出力時間）**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Controllers/ProductsController.cs` - Downloadメソッド定義（63-70行目）
- E-02: `Src/Application/Products/Queries/GetProductsFile/GetProductsFileQuery.cs` - クエリ定義
- E-03: `Src/Application/Products/Queries/GetProductsFile/GetProductsFileQueryHandler.cs` - クエリハンドラ実装
- E-04: `Src/Application/Products/Queries/GetProductsFile/ProductRecordDto.cs` - DTOとマッピング定義
- E-05: `Src/Application/Products/Queries/GetProductsFile/ProductsFileVm.cs` - 出力ViewModelの定義
- E-06: `Src/Infrastructure/Files/CsvFileBuilder.cs` - CSV生成実装
- E-07: `Src/Infrastructure/Files/ProductFileRecordMap.cs` - CSVマッピング設定
- E-08: `Src/Domain/Entities/Product.cs` - 商品エンティティ
- E-09: `Src/Domain/Entities/Category.cs` - カテゴリエンティティ
- E-10: `Src/Application/Common/Interfaces/ICsvFileBuilder.cs` - インターフェース定義
- E-11: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは GET /api/products/download | E-01 (63行目: [HttpGet], Downloadメソッド) | ○ |
| C-02 | AllowAnonymous属性で認証不要 | E-01 (64行目: [AllowAnonymous]) | ○ |
| C-03 | ファイル形式はCSV | E-03 (38行目: ContentType = "text/csv") | ○ |
| C-04 | ファイル名は{yyyy-MM-dd}-Products.csv形式 | E-03 (39行目: $"{_dateTime.Now:yyyy-MM-dd}-Products.csv") | ○ |
| C-05 | 出力項目：Category（カテゴリ名） | E-04 (9行目: string Category) | ○ |
| C-06 | 出力項目：Name（商品名） | E-04 (11行目: string Name) | ○ |
| C-07 | 出力項目：UnitPrice（単価） | E-04 (13行目: decimal? UnitPrice) | ○ |
| C-08 | 出力項目：Discontinued（販売終了フラグ） | E-04 (15行目: bool Discontinued) | ○ |
| C-09 | CategoryはCategory.CategoryNameからマッピング | E-04 (21行目: s.Category.CategoryName) | ○ |
| C-10 | NameはProduct.ProductNameからマッピング | E-04 (20行目: s.ProductName) | ○ |
| C-11 | UnitPriceは通貨形式（C）で出力 | E-07 (11行目: .ConvertUsing(c => (c.UnitPrice ?? 0).ToString("C"))) | ○ |
| C-12 | UnitPriceがnullの場合は0に置換 | E-07 (11行目: c.UnitPrice ?? 0) | ○ |
| C-13 | CSVヘッダーでUnitPriceは"Unit Price"と表示 | E-07 (11行目: .Name("Unit Price")) | ○ |
| C-14 | CsvHelperライブラリを使用 | E-06 (3行目: using CsvHelper) | ○ |
| C-15 | MemoryStreamでCSV生成 | E-06 (13行目: using var memoryStream = new MemoryStream()) | ○ |
| C-16 | ProductsテーブルからデータSource | E-03 (29行目: _context.Products) | ○ |
| C-17 | CategoryテーブルとJOIN（ナビゲーションプロパティ） | E-04 (21行目), E-08 (24行目: Category Category) | ○ |
| C-18 | 全件取得（フィルタ条件なし） | E-03 (29-31行目: ToListAsync、WHERE句なし) | ○ |
| C-19 | Productエンティティの構造 | E-08 (全体) | ○ |
| C-20 | Categoryエンティティの構造 | E-09 (全体) | ○ |
| C-21 | MediatRパターンでクエリ実行 | E-01 (67行目), E-02, E-03 | ○ |
| C-22 | AutoMapperでDTO変換 | E-03 (30行目: ProjectTo), E-04 (17-21行目: Mapping) | ○ |
| C-23 | 帳票名「商品一覧CSV」 | E-11 (2行目) | ○ |
| C-24 | 説明「商品データをCSV形式でエクスポート」 | E-11 (2行目) | ○ |
| C-25 | パフォーマンス要件（想定データ件数: 数百〜数千件、目標出力時間: 数秒） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（想定データ件数、目標出力時間、同時出力数上限）
  - ソースコード上に明示的な定義がない
  - 候補：要件定義書 / 性能テスト仕様書 / 運用設計書

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 機能仕様はソースコードから正確に抽出
- **1: 中リスク** - パフォーマンス要件は推測値のため、本番運用前に要確認
- **0: 低リスク** - セキュリティ記載（AllowAnonymous）はコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件が実際の運用要件と整合しているか確認
- [ ] AllowAnonymousが本番環境で適切かセキュリティレビュー
- [ ] 通貨形式の出力がロケール設定と一致するか確認
