---
generated_at: 2026-01-07 12:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：業務要件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **顧客詳細モーダル（関連画面）**：顧客詳細モーダルでの顧客更新操作は推定
  2. **ログアウト関連機能**：機能一覧に明示的なログアウト機能がない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Controllers/CustomersController.cs`
- E-02: `Src/WebUI/Controllers/ProductsController.cs`
- E-03: `Src/WebUI/Controllers/EmployeesController.cs`
- E-04: `Src/WebUI/Controllers/CategoriesController.cs`
- E-05: `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs`
- E-06: `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml.cs`
- E-07: `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommand.cs`
- E-08: `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommandValidator.cs`
- E-09: `Src/Application/Customers/Commands/UpdateCustomer/UpdateCustomerCommand.cs`
- E-10: `Src/Application/Customers/Commands/DeleteCustomer/DeleteCustomerCommand.cs`
- E-11: `Src/Application/Products/Commands/CreateProduct/CreateProductCommand.cs`
- E-12: `Src/Application/Products/Commands/UpdateProduct/UpdateProductCommand.cs`
- E-13: `Src/Application/Products/Commands/DeleteProduct/DeleteProductCommand.cs`
- E-14: `Src/Application/Products/Queries/GetProductsFile/GetProductsFileQuery.cs`
- E-15: `Src/Application/Employees/Commands/UpsertEmployee/UpsertEmployeeCommand.cs`
- E-16: `Src/Application/Employees/Commands/DeleteEmployee/DeleteEmployeeCommand.cs`
- E-17: `Src/Application/Categories/Commands/UpsertCategory/UpsertCategoryCommand.cs`
- E-18: `Src/Application/Categories/Commands/DeleteCategory/DeleteCategoryCommand.cs`
- E-19: `Src/Domain/Entities/Customer.cs`
- E-20: `Src/Domain/Entities/Product.cs`
- E-21: `Src/Domain/Entities/Employee.cs`
- E-22: `Src/Domain/Entities/Category.cs`
- E-23: `Src/Domain/Entities/Order.cs`
- E-24: `Src/Application/System/Commands/SeedSampleData/SeedSampleDataCommand.cs`
- E-25: `Src/WebUI/Common/CustomExceptionHandlerMiddleware.cs`
- E-26: `Src/Application/Common/Interfaces/ICurrentUserService.cs`
- E-27: `Docs/code-to-docs/画面一覧/画面一覧.csv`
- E-28: `Docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ユーザー登録：新規ユーザーアカウントを作成できる | E-06, E-28 | ○ |
| C-02 | ログイン：メールアドレスとパスワードでログインできる | E-05, E-28 | ○ |
| C-03 | ログアウト：システムからログアウトできる | E-27 | △ |
| C-04 | メール確認：確認メールを送信できる | E-05, E-06 | ○ |
| C-05 | 顧客一覧表示：全顧客情報を一覧表示できる | E-01, E-27, E-28 | ○ |
| C-06 | 顧客詳細表示：顧客の詳細情報を確認できる | E-01, E-27, E-28 | ○ |
| C-07 | 顧客登録：新規顧客を登録できる | E-01, E-07, E-08, E-28 | ○ |
| C-08 | 顧客情報更新：既存顧客情報を更新できる | E-01, E-09, E-28 | △ |
| C-09 | 顧客削除：顧客情報を削除できる | E-01, E-10, E-28 | ○ |
| C-10 | 商品一覧表示：全商品情報を一覧表示できる | E-02, E-27, E-28 | ○ |
| C-11 | 商品詳細表示：商品の詳細情報を確認できる | E-02, E-28 | ○ |
| C-12 | 商品登録：新規商品を登録できる | E-02, E-11, E-28 | ○ |
| C-13 | 商品情報更新：既存商品情報を更新できる | E-02, E-12, E-28 | ○ |
| C-14 | 商品削除：商品情報を削除できる | E-02, E-13, E-28 | ○ |
| C-15 | 商品一覧ダウンロード：商品一覧をCSVでダウンロードできる | E-02, E-14, E-28 | ○ |
| C-16 | カテゴリ一覧表示：カテゴリ一覧を確認できる | E-04, E-28 | ○ |
| C-17 | カテゴリ登録・更新：カテゴリを登録または更新できる | E-04, E-17, E-28 | ○ |
| C-18 | カテゴリ削除：カテゴリを削除できる | E-04, E-18, E-28 | ○ |
| C-19 | 従業員一覧表示：従業員情報を一覧表示できる | E-03, E-28 | ○ |
| C-20 | 従業員詳細表示：従業員の詳細情報を確認できる | E-03, E-28 | ○ |
| C-21 | 従業員登録・更新：従業員を登録または更新できる | E-03, E-15, E-28 | ○ |
| C-22 | 従業員削除：従業員を削除できる（自分は不可） | E-03, E-16, E-28 | ○ |
| C-23 | 在庫管理：在庫数、発注数、再発注レベルを管理できる | E-20 | ○ |
| C-24 | 販売停止管理：商品の販売停止状態を管理できる | E-20 | ○ |
| C-25 | 仕入先関連付け：商品と仕入先を関連付けできる | E-20 | ○ |
| C-26 | 監査証跡：作成日時、更新日時を記録できる | E-20, E-21, E-23 | ○ |
| C-27 | サンプルデータ投入：初期データを投入できる | E-24, E-28 | ○ |
| C-28 | 例外処理：エラーを統一的に処理できる | E-25, E-28 | ○ |
| C-29 | 現在ユーザー情報取得：ログインユーザー情報を取得できる | E-26, E-28 | ○ |
| C-30 | 顧客登録通知：登録時に通知を送信できる | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- **ログアウト機能（C-03）**：画面一覧にログアウト画面は存在するが、機能一覧にログアウト機能の明示的な定義がない
  - 候補：ASP.NET Core Identityの標準機能 / IdentityServerのログアウトエンドポイント
- **顧客更新の関連画面（C-08）**：顧客詳細モーダルから更新できるとの推定だが、明示的なUI確認が必要
  - 候補：顧客詳細モーダルの編集機能 / 別途編集画面

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 認証・認可関連の実装は ASP.NET Core Identity と IdentityServer を使用しており、業界標準に準拠
- **0 (低リスク)**: CRUD操作は MediatR パターンで実装されており、バリデーションも FluentValidation で定義済み
- **1 (中リスク)**: 従業員削除時の関連データ（注文、担当地域）の処理が完全ではない可能性（TODOコメントあり）
- **0 (低リスク)**: 例外ハンドリングは CustomExceptionHandlerMiddleware で統一的に処理

## 6) レビュアーチェックリスト（最小）
- [ ] ログアウト機能の画面・API実装が存在するか確認
- [ ] 顧客詳細モーダルで顧客情報の更新UIが実装されているか確認
- [ ] 従業員削除時の関連データ処理ロジックを確認（注文、担当地域への影響）
- [ ] カテゴリ削除時の関連商品への影響を確認
- [ ] 商品削除時の関連注文詳細への影響を確認
