---
generated_at: 2026-01-07 21:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml.cs`
- E-02: `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs`
- E-03: `Src/WebUI/Controllers/CustomersController.cs`
- E-04: `Src/Application/Customers/Queries/GetCustomersList/GetCustomersListQuery.cs`
- E-05: `Src/Application/Customers/Queries/GetCustomerDetail/GetCustomerDetailQuery.cs`
- E-06: `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommand.cs`
- E-07: `Src/Application/Customers/Commands/UpdateCustomer/UpdateCustomerCommand.cs`
- E-08: `Src/Application/Customers/Commands/DeleteCustomer/DeleteCustomerCommand.cs`
- E-09: `Src/WebUI/Controllers/ProductsController.cs`
- E-10: `Src/Application/Products/Queries/GetProductsList/GetProductsListQuery.cs`
- E-11: `Src/Application/Products/Queries/GetProductDetail/GetProductDetailQuery.cs`
- E-12: `Src/Application/Products/Commands/CreateProduct/CreateProductCommand.cs`
- E-13: `Src/Application/Products/Commands/UpdateProduct/UpdateProductCommand.cs`
- E-14: `Src/Application/Products/Commands/DeleteProduct/DeleteProductCommand.cs`
- E-15: `Src/Application/Products/Queries/GetProductsFile/GetProductsFileQueryHandler.cs`
- E-16: `Src/WebUI/Controllers/CategoriesController.cs`
- E-17: `Src/Application/Categories/Queries/GetCategoriesList/GetCategoriesListQuery.cs`
- E-18: `Src/Application/Categories/Commands/UpsertCategory/UpsertCategoryCommand.cs`
- E-19: `Src/Application/Categories/Commands/DeleteCategory/DeleteCategoryCommand.cs`
- E-20: `Src/WebUI/Controllers/EmployeesController.cs`
- E-21: `Src/Application/Employees/Queries/GetEmployeesList/GetEmployeesListQuery.cs`
- E-22: `Src/Application/Employees/Queries/GetEmployeeDetail/GetEmployeeDetailQuery.cs`
- E-23: `Src/Application/Employees/Commands/UpsertEmployee/UpsertEmployeeCommand.cs`
- E-24: `Src/Application/Employees/Commands/DeleteEmployee/DeleteEmployeeCommand.cs`
- E-25: `Src/Application/System/Commands/SeedSampleData/SeedSampleDataCommand.cs`
- E-26: `Src/WebUI/Common/CustomExceptionHandlerMiddleware.cs`
- E-27: `Src/WebUI/Services/CurrentUserService.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ユーザー登録機能 | E-01 | ○ |
| C-02 | ログイン機能 | E-02 | ○ |
| C-03 | メール確認送信機能 | E-02 | ○ |
| C-04 | 顧客一覧取得機能 | E-03, E-04 | ○ |
| C-05 | 顧客詳細取得機能 | E-03, E-05 | ○ |
| C-06 | 顧客登録機能 | E-03, E-06 | ○ |
| C-07 | 顧客更新機能 | E-03, E-07 | ○ |
| C-08 | 顧客削除機能 | E-03, E-08 | ○ |
| C-09 | 商品一覧取得機能 | E-09, E-10 | ○ |
| C-10 | 商品詳細取得機能 | E-09, E-11 | ○ |
| C-11 | 商品登録機能 | E-09, E-12 | ○ |
| C-12 | 商品更新機能 | E-09, E-13 | ○ |
| C-13 | 商品削除機能 | E-09, E-14 | ○ |
| C-14 | 商品一覧ダウンロード機能 | E-09, E-15 | ○ |
| C-15 | カテゴリ一覧取得機能 | E-16, E-17 | ○ |
| C-16 | カテゴリ登録・更新機能 | E-16, E-18 | ○ |
| C-17 | カテゴリ削除機能 | E-16, E-19 | ○ |
| C-18 | 従業員一覧取得機能 | E-20, E-21 | ○ |
| C-19 | 従業員詳細取得機能 | E-20, E-22 | ○ |
| C-20 | 従業員登録・更新機能 | E-20, E-23 | ○ |
| C-21 | 従業員削除機能 | E-20, E-24 | ○ |
| C-22 | サンプルデータ投入機能 | E-25 | ○ |
| C-23 | 例外ハンドリング機能 | E-26 | ○ |
| C-24 | 現在ユーザー情報取得機能 | E-27 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全ての機能について、ソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている
- 注意点：
  - Order（注文）エンティティは存在するが、OrdersControllerは未実装
  - Supplier（仕入先）、Shipper（配送業者）、Region/Territory（地域）のCRUD機能は未実装
  - これらは将来的な拡張候補として考慮可能

## 6) レビュアーチェックリスト（最小）
- [ ] 各カテゴリの機能分類が適切か確認
- [ ] APIエンドポイントの記載が正しいか確認
- [ ] 認証要否（Authorize/AllowAnonymous）の記載が正しいか確認
- [ ] 未実装機能（Orders, Suppliers, Shippers等）の追加が必要か検討
