# 機能設計書 14-商品一覧ダウンロード

## 概要

本ドキュメントは、NorthwindTradersシステムにおける商品一覧ダウンロード機能の設計仕様を定義する。

### 本機能の処理概要

本機能は、全ての商品情報をCSVファイルとしてダウンロードするためのAPIエンドポイントを提供する。データベースから商品情報を取得し、CsvHelperライブラリを使用してCSV形式に変換し、ファイルとしてダウンロードさせる。

**業務上の目的・背景**：商品マスタデータを外部システムへエクスポートしたり、Excelでの加工・分析を行ったり、バックアップ目的でデータを抽出する際に使用される。CSV形式は汎用性が高く、様々なツールやシステムとの連携に適している。

**機能の利用シーン**：商品データの定期的なバックアップ、他システムへのデータ移行、商品分析レポートの作成、棚卸し用リストの出力など、商品一覧を外部ファイルとして取得したい場面で使用される。

**主要な処理内容**：
1. APIリクエストを受け取る（パラメータなし）
2. GetProductsFileQueryを通じてMediatRパイプラインへディスパッチ
3. GetProductsFileQueryHandlerがデータベースから全商品を取得
4. AutoMapperでProductRecordDtoに変換
5. ICsvFileBuilderでCSVバイト配列を生成
6. ファイル名に日付を含むCSVファイルとしてレスポンスを返却

**関連システム・外部連携**：特になし。出力されたCSVファイルは外部システムでの利用を想定。

**権限による制御**：本エンドポイントには[AllowAnonymous]属性が付与されており、認証なしでアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | 商品一覧画面 | 補助機能 | Exportボタン押下時に/api/products/downloadエンドポイントを呼び出し |

## 機能種別

帳票出力 / CSVエクスポート

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | パラメータなし | - |

### 入力データソース

HTTPリクエスト（GET /api/Products/Download）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Category | string | カテゴリ名（CategoryNameからマッピング） |
| Name | string | 商品名（ProductNameからマッピング） |
| UnitPrice | decimal? | 単価（通貨フォーマット） |
| Discontinued | bool | 販売終了フラグ |

### 出力先

HTTPレスポンス（ファイルダウンロード）
- Content-Type: text/csv
- ファイル名: {yyyy-MM-dd}-Products.csv（例: 2026-01-07-Products.csv）

## 処理フロー

### 処理シーケンス

\`\`\`
1. ProductsController.Download()がHTTP GETリクエストを受信
2. MediatRを通じてGetProductsFileQueryをディスパッチ
3. GetProductsFileQueryHandlerがクエリを処理
   └─ _context.Products.ProjectTo<ProductRecordDto>()で全商品を取得・変換
4. ICsvFileBuilderでCSV生成
5. ProductsFileVmを作成
6. ファイルレスポンスを返却
\`\`\`

### フローチャート

\`\`\`mermaid
flowchart TD
    A[HTTP GET /api/Products/Download] --> B[GetProductsFileQuery生成]
    B --> C[MediatR.Send]
    C --> D[GetProductsFileQueryHandler.Handle]
    D --> E[Products.ProjectTo]
    E --> F[ToListAsync]
    F --> G[ICsvFileBuilder.BuildProductsFile]
    G --> H[ProductsFileVm作成]
    H --> I[File レスポンス返却]
\`\`\`

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 全件出力 | フィルタなしで全商品を出力する | 常に適用 |
| BR-02 | 日付付きファイル名 | ファイル名に出力日付を含める | 常に適用 |
| BR-03 | 通貨フォーマット | UnitPriceは通貨形式でフォーマット | 常に適用 |

### 計算ロジック

- UnitPrice: nullの場合は0として出力し、通貨フォーマットを適用
- Category: Categoryエンティティが存在する場合はCategoryName、存在しない場合は空文字

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 商品取得 | Products | SELECT | 全商品を取得 |
| カテゴリ参照 | Categories | SELECT (JOIN) | 商品に紐づくカテゴリ名を取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 500 | InternalServerError | データベース接続エラー等 | システム管理者に連絡 |

## トランザクション仕様

読み取り専用操作のため、明示的なトランザクション管理は不要。

## パフォーマンス要件

大量のデータ出力の可能性があるため、メモリ使用量に注意が必要。

## セキュリティ考慮事項

- [AllowAnonymous]属性により認証不要で公開されている
- 商品マスタは公開情報として扱われている想定

## 備考

- CSVの文字コードはUTF-8
- CsvHelperライブラリを使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ProductRecordDto.cs | \`Src/Application/Products/Queries/GetProductsFile/ProductRecordDto.cs\` | CSV出力用のDTO構造を確認 |
| 1-2 | ProductsFileVm.cs | \`Src/Application/Products/Queries/GetProductsFile/ProductsFileVm.cs\` | 出力ファイル情報のViewModel |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProductsController.cs | \`Src/WebUI/Controllers/ProductsController.cs\` | Download()メソッド（63-70行目） |

#### Step 3: クエリハンドラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GetProductsFileQueryHandler.cs | \`Src/Application/Products/Queries/GetProductsFile/GetProductsFileQueryHandler.cs\` | データ取得とCSV生成ロジック |

### プログラム呼び出し階層図

\`\`\`
ProductsController.Download()
    │
    ├─ Mediator.Send(GetProductsFileQuery)
    │      │
    │      └─ GetProductsFileQueryHandler.Handle()
    │             │
    │             ├─ _context.Products.ProjectTo<ProductRecordDto>()
    │             │
    │             └─ _fileBuilder.BuildProductsFile(records)
    │
    └─ return File(vm.Content, vm.ContentType, vm.FileName)
\`\`\`

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ProductsController.cs | \`Src/WebUI/Controllers/ProductsController.cs\` | ソース | APIエンドポイント定義 |
| GetProductsFileQuery.cs | \`Src/Application/Products/Queries/GetProductsFile/GetProductsFileQuery.cs\` | ソース | クエリ定義 |
| GetProductsFileQueryHandler.cs | \`Src/Application/Products/Queries/GetProductsFile/GetProductsFileQueryHandler.cs\` | ソース | クエリ処理ハンドラー |
| ProductRecordDto.cs | \`Src/Application/Products/Queries/GetProductsFile/ProductRecordDto.cs\` | ソース | CSV出力用DTO |
| ProductsFileVm.cs | \`Src/Application/Products/Queries/GetProductsFile/ProductsFileVm.cs\` | ソース | ファイル情報ViewModel |
| CsvFileBuilder.cs | \`Src/Infrastructure/Files/CsvFileBuilder.cs\` | ソース | CSV生成実装 |
| ProductFileRecordMap.cs | \`Src/Infrastructure/Files/ProductFileRecordMap.cs\` | ソース | CsvHelperマッピング設定 |
