# 機能設計書 15-カテゴリ一覧取得

## 概要

本ドキュメントは、NorthwindTradersシステムにおけるカテゴリ一覧取得機能の設計仕様を定義する。

### 本機能の処理概要

本機能は、全ての商品カテゴリ情報を一覧形式で取得するためのAPIエンドポイントを提供する。カテゴリID、カテゴリ名、説明、画像データを含むカテゴリ情報のリストを返却する。

**業務上の目的・背景**：商品を分類・管理するためのカテゴリマスタは、商品登録時のカテゴリ選択、商品検索のフィルタリング、売上分析のグルーピングなど、様々な場面で参照される。本機能により、システム内で利用可能な全カテゴリを取得できる。

**機能の利用シーン**：商品登録画面でカテゴリ選択用のドロップダウンを表示する際、商品一覧画面でカテゴリフィルタを提供する際、カテゴリ管理画面で一覧を表示する際などに使用される。

**主要な処理内容**：
1. APIリクエストを受け取る（パラメータなし）
2. GetCategoriesListQueryを通じてMediatRパイプラインへディスパッチ
3. GetCategoriesListQueryHandlerがデータベースから全カテゴリを取得
4. AutoMapperでCategoryDtoに変換
5. カテゴリリストと件数を含むViewModelを返却

**関連システム・外部連携**：特になし。

**権限による制御**：本エンドポイントには[AllowAnonymous]属性が付与されており、認証なしでアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 現在、この機能を直接呼び出す画面は実装されていない |

## 機能種別

CRUD操作 / 一覧取得（Read）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | パラメータなし | - |

### 入力データソース

HTTPリクエスト（GET /api/Categories）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Categories | List<CategoryDto> | カテゴリ情報のリスト |
| Count | int | カテゴリ件数 |

#### CategoryDto

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Id | int | カテゴリID |
| Name | string | カテゴリ名 |
| Description | string | 説明 |
| Picture | byte[] | カテゴリ画像 |

### 出力先

HTTPレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

\`\`\`
1. CategoriesController.GetAll()がHTTP GETリクエストを受信
2. MediatRを通じてGetCategoriesListQueryをディスパッチ
3. GetCategoriesListQueryHandlerがクエリを処理
   └─ _context.Categories.ProjectTo<CategoryDto>()で全カテゴリを取得・変換
4. CategoriesListVmを作成
   └─ Categories: カテゴリDTOリスト
   └─ Count: リスト件数
5. ViewModelを返却
\`\`\`

### フローチャート

\`\`\`mermaid
flowchart TD
    A[HTTP GET /api/Categories] --> B[GetCategoriesListQuery生成]
    B --> C[MediatR.Send]
    C --> D[GetCategoriesListQueryHandler.Handle]
    D --> E[Categories.ProjectTo]
    E --> F[ToListAsync]
    F --> G[CategoriesListVm作成]
    G --> H[HTTP 200 OK]
\`\`\`

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 全件取得 | フィルタなしで全カテゴリを取得する | 常に適用 |
| BR-02 | 認証不要 | 誰でも取得可能 | 常に適用 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| カテゴリ取得 | Categories | SELECT | 全カテゴリを取得 |

### テーブル別操作詳細

#### Categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | CategoryID | 全件 | Id にマッピング |
| SELECT | CategoryName | 全件 | Name にマッピング |
| SELECT | Description | 全件 | そのまま |
| SELECT | Picture | 全件 | バイト配列 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 500 | InternalServerError | データベース接続エラー等 | システム管理者に連絡 |

## トランザクション仕様

読み取り専用操作のため、明示的なトランザクション管理は不要。

## パフォーマンス要件

特に明示的な要件なし。カテゴリ数は一般的に少数のため、パフォーマンス問題は発生しにくい。

## セキュリティ考慮事項

- [AllowAnonymous]属性により認証不要で公開されている
- カテゴリ情報は公開情報として扱われている

## 備考

- CategoryDtoでは、CategoryIdがIdに、CategoryNameがNameにマッピングされる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Category.cs | \`Src/Domain/Entities/Category.cs\` | カテゴリエンティティの構造 |
| 1-2 | CategoryDto.cs | \`Src/Application/Categories/Queries/GetCategoriesList/CategoryDto.cs\` | DTOとマッピングルール |
| 1-3 | CategoriesListVm.cs | \`Src/Application/Categories/Queries/GetCategoriesList/CategoriesListVm.cs\` | ViewModel構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CategoriesController.cs | \`Src/WebUI/Controllers/CategoriesController.cs\` | GetAll()メソッド（14-19行目） |

#### Step 3: クエリハンドラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GetCategoriesListQueryHandler.cs | \`Src/Application/Categories/Queries/GetCategoriesList/GetCategoriesListQueryHandler.cs\` | データ取得ロジック |

### プログラム呼び出し階層図

\`\`\`
CategoriesController.GetAll()
    │
    ├─ Mediator.Send(GetCategoriesListQuery)
    │      │
    │      └─ GetCategoriesListQueryHandler.Handle()
    │             │
    │             ├─ _context.Categories.ProjectTo<CategoryDto>()
    │             │
    │             └─ new CategoriesListVm { Categories, Count }
    │
    └─ return Ok(vm)
\`\`\`

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CategoriesController.cs | \`Src/WebUI/Controllers/CategoriesController.cs\` | ソース | APIエンドポイント定義 |
| GetCategoriesListQuery.cs | \`Src/Application/Categories/Queries/GetCategoriesList/GetCategoriesListQuery.cs\` | ソース | クエリ定義 |
| GetCategoriesListQueryHandler.cs | \`Src/Application/Categories/Queries/GetCategoriesList/GetCategoriesListQueryHandler.cs\` | ソース | クエリ処理ハンドラー |
| CategoryDto.cs | \`Src/Application/Categories/Queries/GetCategoriesList/CategoryDto.cs\` | ソース | カテゴリDTO |
| CategoriesListVm.cs | \`Src/Application/Categories/Queries/GetCategoriesList/CategoriesListVm.cs\` | ソース | ViewModel |
| Category.cs | \`Src/Domain/Entities/Category.cs\` | ソース | ドメインエンティティ |
