# 機能設計書 18-従業員一覧取得

## 概要

本ドキュメントは、NorthwindTradersシステムにおける従業員一覧取得機能の設計仕様を定義する。

### 本機能の処理概要

本機能は、全ての従業員情報を一覧形式で取得するためのAPIエンドポイントを提供する。従業員ID、氏名（LastName + FirstName）、役職、内線番号を含む従業員情報のリストを返却する。

**業務上の目的・背景**：従業員マスタは、受注担当者の割り当て、組織構造の表示、権限管理など多くの場面で参照される。本機能により、システム内の全従業員を一覧で取得できる。

**機能の利用シーン**：受注入力画面での担当者選択、従業員管理画面での一覧表示、レポート機能での担当者フィルタリングなどに使用される。

**主要な処理内容**：
1. APIリクエストを受け取る（パラメータなし）
2. GetEmployeesListQueryを通じてMediatRパイプラインへディスパッチ
3. GetEmployeesListQueryHandlerがデータベースから全従業員を取得
4. AutoMapperでEmployeeLookupDtoに変換
5. 氏名順（Name）でソートして返却

**関連システム・外部連携**：特になし。

**権限による制御**：EmployeesControllerにはクラスレベルで[Authorize]属性が付与されていないが、BaseControllerの設定により認証が必要な場合がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 現在、この機能を直接呼び出す画面は実装されていない |

## 機能種別

CRUD操作 / 一覧取得（Read）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | 入力パラメータなし | - |

### 入力データソース

入力パラメータなし。Employeesテーブルから全件取得。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Employees | IList<EmployeeLookupDto> | 従業員一覧 |

### EmployeeLookupDto

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Id | int | 従業員ID |
| Name | string | 氏名（LastName, FirstName形式） |
| Position | string | 役職（Title） |
| Extension | string | 内線番号 |

### 出力先

HTTPレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. EmployeesController.GetAll()がHTTP GETリクエストを受信
   └─ パラメータなし
2. MediatRを通じてGetEmployeesListQueryをディスパッチ
   └─ Mediator.Send(new GetEmployeesListQuery())
3. GetEmployeesListQueryHandlerがクエリを処理
   └─ Employees全件をEmployeeLookupDtoにマッピング
4. 氏名（Name）でソート
   └─ OrderBy(e => e.Name)
5. EmployeesListVmを作成し返却
```

### フローチャート

```mermaid
flowchart TD
    A[HTTP GET /api/Employees] --> B[GetEmployeesListQuery生成]
    B --> C[MediatR.Send]
    C --> D[GetEmployeesListQueryHandler.Handle]
    D --> E[Employees全件取得]
    E --> F[EmployeeLookupDtoにマッピング]
    F --> G[氏名でソート]
    G --> H[EmployeesListVm作成]
    H --> I[HTTP 200 OK]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 全件取得 | 全ての従業員を取得対象とする（フィルタなし） | 常に適用 |
| BR-02 | 氏名ソート | 氏名（LastName, FirstName形式）でソート | 常に適用 |
| BR-03 | 氏名形式 | 氏名は「LastName, FirstName」形式で出力 | 常に適用 |

### 計算ロジック

- Name: `LastName + ", " + FirstName` の形式で結合

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 従業員全件取得 | Employees | SELECT | 全従業員を取得 |

### テーブル別操作詳細

#### Employees

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | EmployeeID | 全件 | Idに出力 |
| SELECT | LastName | 全件 | Name結合に使用 |
| SELECT | FirstName | 全件 | Name結合に使用 |
| SELECT | Title | 全件 | Positionに出力 |
| SELECT | Extension | 全件 | そのまま出力 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 500 | InternalServerError | データベース接続エラー等 | システム管理者に連絡 |

### リトライ仕様

特になし。

## トランザクション仕様

読み取り専用のため、トランザクション管理は不要。

## パフォーマンス要件

特に明示的な要件なし。

## セキュリティ考慮事項

- 従業員情報は個人情報を含むため、適切なアクセス制御が必要
- 本一覧では最小限の情報（ID、氏名、役職、内線）のみを出力

## 備考

- EmployeeLookupDtoはリスト表示用の軽量DTO
- 詳細情報が必要な場合は従業員詳細取得機能（No.19）を使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Employee.cs | `Src/Domain/Entities/Employee.cs` | 従業員エンティティの全プロパティ |
| 1-2 | EmployeeLookupDto.cs | `Src/Application/Employees/Queries/GetEmployeesList/EmployeeLookupDto.cs` | DTOとマッピングルール |
| 1-3 | EmployeesListVm.cs | `Src/Application/Employees/Queries/GetEmployeesList/EmployeesListVm.cs` | ViewModel構造 |

**読解のコツ**: EmployeeLookupDto.csのMapping()メソッドで、氏名の結合ロジック（LastName + ", " + FirstName）とTitle→Positionのマッピングを確認。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EmployeesController.cs | `Src/WebUI/Controllers/EmployeesController.cs` | GetAll()メソッドの実装 |

**主要処理フロー**:
1. **14-19行目**: GetAll()メソッドがGetEmployeesListQueryを発行
2. **15行目**: [ProducesResponseType(StatusCodes.Status200OK)]

#### Step 3: クエリとハンドラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GetEmployeesListQuery.cs | `Src/Application/Employees/Queries/GetEmployeesList/GetEmployeesListQuery.cs` | クエリとハンドラーが同一ファイル |

**主要処理フロー**:
- **25-30行目**: Handle()メソッド
- **27-30行目**: ProjectTo、OrderBy、ToListAsyncの流れ
- **32-35行目**: EmployeesListVmを作成

### プログラム呼び出し階層図

```
EmployeesController.GetAll()
    │
    ├─ Mediator.Send(GetEmployeesListQuery)
    │      │
    │      └─ GetEmployeesListQueryHandler.Handle()
    │             │
    │             ├─ _context.Employees.ProjectTo<EmployeeLookupDto>()
    │             │
    │             ├─ .OrderBy(e => e.Name)
    │             │
    │             ├─ .ToListAsync()
    │             │
    │             └─ return EmployeesListVm
    │
    └─ return Ok(vm)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

HTTP GET          ───▶  GetEmployeesListQuery    ───▶  JSON
(パラメータなし)              │                         EmployeesListVm
                              │
                              ▼
                    GetEmployeesListQueryHandler
                              │
                              ▼
                    Employees全件取得
                              │
                              ▼
                    AutoMapper → EmployeeLookupDto
                              │
                              ▼
                    OrderBy(Name)でソート
                              │
                              ▼
                    EmployeesListVm
                    { Employees }
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EmployeesController.cs | `Src/WebUI/Controllers/EmployeesController.cs` | ソース | APIエンドポイント定義 |
| GetEmployeesListQuery.cs | `Src/Application/Employees/Queries/GetEmployeesList/GetEmployeesListQuery.cs` | ソース | クエリとハンドラー |
| EmployeeLookupDto.cs | `Src/Application/Employees/Queries/GetEmployeesList/EmployeeLookupDto.cs` | ソース | 従業員一覧DTO |
| EmployeesListVm.cs | `Src/Application/Employees/Queries/GetEmployeesList/EmployeesListVm.cs` | ソース | ViewModel |
| Employee.cs | `Src/Domain/Entities/Employee.cs` | ソース | ドメインエンティティ |
