# 機能設計書 22-サンプルデータ投入

## 概要

本ドキュメントは、Northwind Tradersシステムにおけるサンプルデータ投入機能の設計仕様を記載する。本機能はアプリケーション起動時に初期サンプルデータをデータベースに投入する開発・テスト支援機能である。

### 本機能の処理概要

本機能は、データベースが空の状態でアプリケーションが起動した際に、顧客、従業員、商品、注文などのサンプルデータを自動的にデータベースに投入する機能である。開発環境やテスト環境での動作確認に使用される。

**業務上の目的・背景**：新規開発環境のセットアップ時や、テスト環境の初期化時に、手動でサンプルデータを登録する手間を省き、迅速に開発・テストを開始できるようにする。一貫したテストデータを使用することで、再現性のあるテストが可能となる。

**機能の利用シーン**：
- 開発者がローカル環境をセットアップする際に自動実行
- CI/CD環境でテスト用データベースを初期化する際に実行
- デモ環境を構築する際に実行

**主要な処理内容**：
1. アプリケーション起動時にデータベースマイグレーションを実行
2. 顧客データが存在しない場合のみサンプルデータを投入（既存データがある場合はスキップ）
3. 顧客、地域、テリトリー、従業員、カテゴリ、配送業者、仕入先、商品、注文の順でデータを投入
4. 最後に従業員に対応するユーザーアカウントを作成

**関連システム・外部連携**：ASP.NET Core Identityと連携し、従業員に対応するログイン用ユーザーアカウントを作成する。

**権限による制御**：本機能はアプリケーション起動時に自動実行されるため、ユーザー権限による制御はない。ただし、本番環境では無効化することが推奨される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面からの呼び出しではなく、アプリケーション起動時に自動実行される |

## 機能種別

データ連携 / バッチ処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| なし | - | - | 本機能は入力パラメータを受け取らない | - |

### 入力データソース

ソースコード内にハードコーディングされたサンプルデータ（SampleDataSeeder.cs内に定義）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| MediatR Unit | Unit | コマンド正常完了を示す戻り値 |

### 出力先

以下のデータベーステーブルにサンプルデータが投入される：
- Customers（顧客）
- Regions（地域）
- Territories（テリトリー）
- Employees（従業員）
- Categories（カテゴリ）
- Shippers（配送業者）
- Suppliers（仕入先）
- Products（商品）
- Orders / OrderDetails（注文・注文明細）
- AspNetUsers（Identityユーザー）

## 処理フロー

### 処理シーケンス

```
1. アプリケーション起動（Program.Main）
   └─ WebHostBuilder.Build()でホストを構築

2. データベースマイグレーション実行
   └─ NorthwindDbContext.Database.Migrate()
   └─ ApplicationDbContext.Database.Migrate()

3. SeedSampleDataCommand発行
   └─ Mediator.Send(new SeedSampleDataCommand())

4. 既存データ確認
   └─ _context.Customers.Any()で顧客データ存在確認
   └─ 存在する場合は処理終了

5. 各マスターデータ投入（順次実行）
   └─ SeedCustomersAsync（顧客91件）
   └─ SeedRegionsAsync（地域4件）
   └─ SeedTerritoriesAsync（テリトリー53件）
   └─ SeedEmployeesAsync（従業員9件）
   └─ SeedCategoriesAsync（カテゴリ8件）
   └─ SeedShippersAsync（配送業者3件）
   └─ SeedSuppliersAsync（仕入先29件）
   └─ SeedProductsAsync（商品77件）

6. トランザクションデータ投入
   └─ SeedOrdersAsync（注文830件）

7. ユーザーアカウント作成
   └─ SeedUsersAsync（従業員に対応するユーザーを作成）
```

### フローチャート

```mermaid
flowchart TD
    A[アプリケーション起動] --> B[データベースマイグレーション]
    B --> C[SeedSampleDataCommand送信]
    C --> D{顧客データ存在?}
    D -->|Yes| E[処理終了]
    D -->|No| F[顧客データ投入]
    F --> G[地域データ投入]
    G --> H[テリトリーデータ投入]
    H --> I[従業員データ投入]
    I --> J[カテゴリデータ投入]
    J --> K[配送業者データ投入]
    K --> L[仕入先データ投入]
    L --> M[商品データ投入]
    M --> N[注文データ投入]
    N --> O[ユーザーアカウント作成]
    O --> P[処理完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-22-01 | 二重投入防止 | 顧客データが既に存在する場合はサンプルデータ投入をスキップする | _context.Customers.Any() == true の場合 |
| BR-22-02 | 投入順序制約 | 外部キー制約を満たすため、親テーブルから順にデータを投入する | 常に適用 |
| BR-22-03 | ユーザー作成ルール | 従業員のFirstNameをメールアドレス形式（{firstname}@northwind）でユーザー名とする | UserIdがnullの従業員に対して |
| BR-22-04 | 初期パスワード | 全従業員ユーザーの初期パスワードは「Northwind1!」 | ユーザー作成時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 存在確認 | Customers | SELECT | 顧客データの有無を確認 |
| 顧客投入 | Customers | INSERT | 91件の顧客サンプルデータ |
| 地域投入 | Regions | INSERT | 4件の地域データ |
| テリトリー投入 | Territories | INSERT | 53件のテリトリーデータ |
| 従業員投入 | Employees | INSERT | 9件の従業員データ |
| カテゴリ投入 | Categories | INSERT | 8件のカテゴリデータ |
| 配送業者投入 | Shippers | INSERT | 3件の配送業者データ |
| 仕入先投入 | Suppliers | INSERT | 29件の仕入先データ |
| 商品投入 | Products | INSERT | 77件の商品データ |
| 注文投入 | Orders | INSERT | 830件の注文データ |
| 注文明細投入 | OrderDetails | INSERT | 注文に紐づく明細データ |
| ユーザー作成 | AspNetUsers | INSERT | 従業員に対応するユーザーアカウント |
| 従業員更新 | Employees | UPDATE | UserId列の設定 |

### テーブル別操作詳細

#### Customers

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | ANY() | 存在確認のみ |
| INSERT | 全カラム | サンプルデータ | 91件のNorthwind標準テストデータ |

#### Employees

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | 全カラム | サンプルデータ | 9件の従業員データ |
| UPDATE | UserId | 作成したユーザーのID | ユーザー作成後に更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Exception | データベース接続失敗 | 起動時ログに出力、管理者確認 |
| - | Exception | マイグレーション失敗 | 起動時ログに出力、管理者確認 |
| - | Exception | 重複データ投入 | 通常は発生しない（存在確認済み） |

### リトライ仕様

リトライ仕様なし。アプリケーション起動時に1回のみ実行される。

## トランザクション仕様

- 各テーブルへのデータ投入は個別のSaveChangesAsync()で保存される
- 全体を単一トランザクションとして管理していないため、途中で失敗した場合は部分的にデータが投入された状態となる可能性がある

## パフォーマンス要件

- アプリケーション起動時に1回のみ実行されるため、厳密な性能要件はない
- ただし、起動時間に影響するため、通常は数秒以内に完了することが望ましい

## セキュリティ考慮事項

- **本番環境での無効化推奨**：サンプルデータには固定パスワード「Northwind1!」を使用しているため、本番環境では使用しないこと
- テスト用ユーザーのパスワードがソースコードにハードコーディングされている点に注意
- デフォルトで全ユーザーに同一パスワードが設定されるため、本番前に変更が必要

## 備考

- サンプルデータは旧Microsoftの「Northwind」サンプルデータベースのデータに基づいている
- SampleDataSeeder.csは非常に大きなファイル（1.4MB以上）であり、多数のサンプルデータが直接埋め込まれている
- TODOコメントに「Add to manager role」とあり、管理職従業員へのロール割り当て機能が未実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

アプリケーション起動時の処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Program.cs | `Src/WebUI/Program.cs` | Main()メソッドでのマイグレーションとSeedSampleDataCommand発行 |

**主要処理フロー**:
- **22-24行目**: WebHostの構築
- **26-28行目**: スコープの作成とサービス取得
- **32-33行目**: NorthwindDbContextのマイグレーション実行
- **35-36行目**: ApplicationDbContext（Identity）のマイグレーション実行
- **38-39行目**: SeedSampleDataCommandの発行

**読解のコツ**: ASP.NET Coreでは、Main()メソッドがアプリケーションのエントリーポイントであり、DIコンテナを通じてサービスを取得している。

#### Step 2: コマンドとハンドラを理解する

MediatRコマンドパターンの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SeedSampleDataCommand.cs | `Src/Application/System/Commands/SeedSampleData/SeedSampleDataCommand.cs` | コマンドクラスとハンドラの実装 |

**主要処理フロー**:
- **9-11行目**: SeedSampleDataCommandクラス（パラメータなし）
- **13-22行目**: ハンドラのコンストラクタで依存注入
- **24-30行目**: Handle()メソッドでSampleDataSeeder.SeedAllAsync()を呼び出し

#### Step 3: データ投入ロジックを理解する

サンプルデータ投入の実際のロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SampleDataSeeder.cs | `Src/Application/System/Commands/SeedSampleData/SampleDataSeeder.cs` | メインの投入ロジック |

**主要処理フロー**:
- **12-27行目**: SampleDataSeederクラスの定義、Dictionaryでエンティティ参照を管理
- **29-55行目**: SeedAllAsync()で投入順序を制御
- **31-34行目**: 顧客データ存在確認による二重投入防止
- **57-80行目**: SeedUsersAsync()で従業員ユーザー作成

**読解のコツ**:
- ファイルが非常に大きいため、まずSeedAllAsync()メソッドで全体の流れを把握
- 各Seedメソッドは同じパターン（配列定義 → AddRange → SaveChanges）で実装
- Dictionary<int, Entity>を使用して、後続の処理で参照が必要なエンティティを保持

#### Step 4: インターフェースを理解する

依存するサービスインターフェースを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | INorthwindDbContext.cs | `Src/Application/Common/Interfaces/INorthwindDbContext.cs` | 各DbSetの定義 |
| 4-2 | IUserManager.cs | `Src/Application/Common/Interfaces/IUserManager.cs` | CreateUserAsyncメソッドのシグネチャ |

### プログラム呼び出し階層図

```
Program.Main()
    │
    ├─ WebHost.CreateWebHostBuilder().Build()
    │
    ├─ NorthwindDbContext.Database.Migrate()
    │
    ├─ ApplicationDbContext.Database.Migrate()
    │
    └─ Mediator.Send(SeedSampleDataCommand)
           │
           └─ SeedSampleDataCommandHandler.Handle()
                  │
                  └─ SampleDataSeeder.SeedAllAsync()
                         │
                         ├─ _context.Customers.Any() [存在確認]
                         │
                         ├─ SeedCustomersAsync()
                         │      └─ _context.Customers.AddRange() → SaveChangesAsync()
                         │
                         ├─ SeedRegionsAsync()
                         ├─ SeedTerritoriesAsync()
                         ├─ SeedEmployeesAsync()
                         ├─ SeedCategoriesAsync()
                         ├─ SeedShippersAsync()
                         ├─ SeedSuppliersAsync()
                         ├─ SeedProductsAsync()
                         ├─ SeedOrdersAsync()
                         │
                         └─ SeedUsersAsync()
                                └─ _userManager.CreateUserAsync()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

なし               Program.Main()
（アプリ起動時）        │
                       ▼
                  マイグレーション実行 ──────────▶ DBスキーマ作成
                       │
                       ▼
                  SeedSampleDataCommand
                       │
                       ▼
                  Customers.Any()
                       │
                       ▼
                  [顧客なしの場合]
                       │
                       ▼
ハードコード      SampleDataSeeder ──────────────▶ Customers (91件)
サンプルデータ          │                         Regions (4件)
                       │                         Territories (53件)
                       │                         Employees (9件)
                       │                         Categories (8件)
                       │                         Shippers (3件)
                       │                         Suppliers (29件)
                       │                         Products (77件)
                       │                         Orders (~830件)
                       │
                       ▼
                  SeedUsersAsync() ──────────────▶ AspNetUsers (9件)
                                                   + Employees.UserId更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Program.cs | `Src/WebUI/Program.cs` | ソース | アプリケーションエントリーポイント、起動時処理 |
| SeedSampleDataCommand.cs | `Src/Application/System/Commands/SeedSampleData/SeedSampleDataCommand.cs` | ソース | MediatRコマンドとハンドラ |
| SampleDataSeeder.cs | `Src/Application/System/Commands/SeedSampleData/SampleDataSeeder.cs` | ソース | サンプルデータ投入ロジック |
| INorthwindDbContext.cs | `Src/Application/Common/Interfaces/INorthwindDbContext.cs` | ソース | DBコンテキストインターフェース |
| IUserManager.cs | `Src/Application/Common/Interfaces/IUserManager.cs` | ソース | ユーザー管理インターフェース |
| NorthwindDbContext.cs | `Src/Persistence/NorthwindDbContext.cs` | ソース | DBコンテキスト実装 |
| ApplicationDbContext.cs | `Src/Infrastructure/Identity/ApplicationDbContext.cs` | ソース | Identity用DBコンテキスト |
