# 機能設計書 3-メール確認送信

## 概要

本ドキュメントは、NorthwindTradersシステムにおけるメール確認送信機能の設計仕様を記載する。ユーザー登録時およびログイン画面からのメールアドレス確認メール送信機能の詳細を定義する。

### 本機能の処理概要

**業務上の目的・背景**：ユーザー登録時にメールアドレスの有効性を確認することで、不正なアカウント作成を防止し、パスワードリセット等の重要な通知が確実にユーザーに届くようにする。これはセキュリティと信頼性の観点から重要な機能である。

**機能の利用シーン**：
1. 新規ユーザー登録完了後に自動的に確認メールを送信
2. ログイン画面から確認メールの再送信を要求する場合
3. メール確認が未完了のユーザーがログインを試みた場合

**主要な処理内容**：
1. ユーザーのメールアドレスに対してメール確認トークンを生成
2. トークンをBase64Urlエンコードして確認URL作成
3. IEmailSenderインターフェースを通じて確認メールを送信
4. ユーザーが確認リンクをクリックすると、トークン検証後にEmailConfirmedをtrueに更新

**関連システム・外部連携**：IEmailSenderインターフェースを通じたメール送信サービス（SMTP、SendGrid等）との連携。

**権限による制御**：メール確認送信自体は認証不要だが、確認リンクのクリックによるメールアドレス確認はトークンの正当性検証によって保護されている。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | ログイン画面（サーバー） | 補助機能 | Resend email confirmationボタン押下時にIEmailSender.SendEmailAsync()で確認メールを再送信する |
| 8 | 新規登録画面（サーバー） | 補助機能 | ユーザー登録成功後にIEmailSender.SendEmailAsync()でメール確認用メールを送信する |

## 機能種別

通知処理 / メール送信

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Email | string | Yes | 確認メールの送信先アドレス | EmailAddress形式 |
| UserId | string | Yes（内部） | ユーザーID | - |

### 入力データソース

- ユーザー登録時：RegisterModelのInputModel.Email
- 再送信時：LoginModelのInputModel.Email

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 確認メール | Email | HTMLメール本文に確認リンクを含む |
| 確認トークン | string | Base64Urlエンコードされた確認トークン |
| 確認URL | string | 確認ページへのリンクURL |

### 出力先

- IEmailSenderを通じて外部メールサービスへ送信
- 送信先：ユーザーのメールアドレス

## 処理フロー

### 処理シーケンス

```
1. ユーザー登録時の確認メール送信（Register.cshtml.cs）
   ├─ UserManager.GenerateEmailConfirmationTokenAsync()でトークン生成
   ├─ WebEncoders.Base64UrlEncode()でトークンをエンコード
   ├─ Url.Page()で確認URLを生成（/Account/ConfirmEmail）
   └─ IEmailSender.SendEmailAsync()でメール送信

2. ログイン画面からの再送信（Login.cshtml.cs）
   ├─ UserManager.FindByEmailAsync()でユーザー検索
   ├─ UserManager.GetUserIdAsync()でユーザーID取得
   ├─ UserManager.GenerateEmailConfirmationTokenAsync()でトークン生成
   ├─ Url.Page()で確認URLを生成
   └─ IEmailSender.SendEmailAsync()でメール送信
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{呼び出し元}
    B -->|ユーザー登録| C[Register.OnPostAsync]
    B -->|再送信要求| D[Login.OnPostSendVerificationEmailAsync]
    C --> E[UserManager.CreateAsync成功]
    D --> F[UserManager.FindByEmailAsync]
    E --> G[GenerateEmailConfirmationTokenAsync]
    F --> H{ユーザー存在?}
    H -->|No| I[メッセージ表示のみ]
    H -->|Yes| J[GetUserIdAsync]
    J --> K[GenerateEmailConfirmationTokenAsync]
    G --> L[Base64UrlEncode]
    K --> L
    L --> M[確認URL生成]
    M --> N[IEmailSender.SendEmailAsync]
    N --> O[完了メッセージ表示]
    I --> O
    O --> P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | トークン一意性 | 各ユーザーに対して一意の確認トークンを生成 | メール送信時 |
| BR-002 | セキュアエンコード | トークンはBase64Urlエンコードして送信 | 常時 |
| BR-003 | HTMLエンコード | 確認URLはHtmlEncoder.Default.Encode()で安全にエンコード | 常時 |
| BR-004 | 存在しないユーザーへの対応 | ユーザーが存在しない場合も同一メッセージを表示（情報漏洩防止） | 再送信時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ユーザー検索 | AspNetUsers | SELECT | メールアドレスによるユーザー検索（再送信時） |

### テーブル別操作詳細

#### AspNetUsers

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | Id, Email | NormalizedEmail = Input.Email.ToUpper() | ユーザー検索 |

※確認リンククリック後のEmailConfirmed更新はConfirmEmail機能で行われる

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| UserNotFound | 検索エラー | 指定されたメールアドレスのユーザーが存在しない | セキュリティのため同一メッセージを表示 |
| EmailSendFailure | 送信エラー | メール送信サービスでエラー発生 | リトライまたはサポートへ連絡 |

### リトライ仕様

メール送信失敗時のリトライはIEmailSenderの実装に依存する。ユーザー側からは再送信ボタンで再試行可能。

## トランザクション仕様

メール送信は非同期処理であり、データベーストランザクションとは独立して実行される。

## パフォーマンス要件

- メール送信は非同期で実行
- ユーザー操作のレスポンス時間に影響を与えないよう設計

## セキュリティ考慮事項

- 確認トークンは推測困難な値をUserManagerが生成
- トークンはBase64Urlエンコードにより安全にURLパラメータとして送信
- 確認URLはHTTPSプロトコルを使用（Request.Scheme）
- 存在しないユーザーへの再送信要求でも同一メッセージを返す（ユーザー列挙攻撃対策）
- HTMLEncoderによるXSS対策

## 備考

- IEmailSenderは抽象化されており、実装は設定により切り替え可能（開発環境ではコンソール出力、本番環境ではSMTP等）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メール送信インターフェースを理解する

IEmailSenderインターフェースの役割を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | - | Microsoft.AspNetCore.Identity.UI.Services | IEmailSenderはASP.NET Core Identity UIの標準インターフェース |

**読解のコツ**: IEmailSenderはDIコンテナに登録され、SendEmailAsync(email, subject, htmlMessage)メソッドを提供する。

#### Step 2: ユーザー登録時のメール送信を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Register.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml.cs` | ユーザー登録後のメール送信処理 |

**主要処理フロー**:
1. **84行目**: GenerateEmailConfirmationTokenAsync()でトークン生成
2. **85行目**: WebEncoders.Base64UrlEncode()でトークンエンコード
3. **86-90行目**: Url.Page()で確認URLを生成（/Account/ConfirmEmail）
4. **92-93行目**: IEmailSender.SendEmailAsync()でメール送信
5. **93行目**: HtmlEncoder.Default.Encode(callbackUrl)でXSS対策

#### Step 3: ログイン画面からの再送信を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Login.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs` | 確認メール再送信処理 |

**主要処理フロー**:
1. **112-117行目**: OnPostSendVerificationEmailAsync()エントリーポイント
2. **119行目**: FindByEmailAsync()でユーザー検索
3. **120-123行目**: ユーザーが存在しない場合も同一メッセージ表示（セキュリティ対策）
4. **125行目**: GetUserIdAsync()でユーザーID取得
5. **126行目**: GenerateEmailConfirmationTokenAsync()でトークン生成
6. **127-131行目**: 確認URL生成
7. **132-135行目**: SendEmailAsync()でメール送信

### プログラム呼び出し階層図

```
[ユーザー登録時]
Register.cshtml
    └─ RegisterModel.OnPostAsync()
           ├─ UserManager.CreateAsync()
           ├─ UserManager.GenerateEmailConfirmationTokenAsync()
           └─ IEmailSender.SendEmailAsync()
                  └─ 外部メールサービス

[再送信時]
Login.cshtml
    └─ LoginModel.OnPostSendVerificationEmailAsync()
           ├─ UserManager.FindByEmailAsync()
           ├─ UserManager.GetUserIdAsync()
           ├─ UserManager.GenerateEmailConfirmationTokenAsync()
           └─ IEmailSender.SendEmailAsync()
                  └─ 外部メールサービス
```

### データフロー図

```
[入力]                    [処理]                              [出力]

Email            ───▶  GenerateEmailConfirmationTokenAsync  ───▶  確認トークン
User             ───▶  Base64UrlEncode                      ───▶  エンコード済トークン
                 ───▶  Url.Page                             ───▶  確認URL
                 ───▶  IEmailSender.SendEmailAsync          ───▶  確認メール
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Register.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml.cs` | ソース | 登録時のメール送信処理 |
| Login.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs` | ソース | 再送信処理 |
| ConfirmEmail.cshtml.cs | `Src/WebUI/Areas/Identity/Pages/Account/ConfirmEmail.cshtml.cs` | ソース | メール確認処理（確認リンク先） |
| Startup.cs | `Src/WebUI/Startup.cs` | ソース | IEmailSenderのDI登録 |
