---
generated_at: 2026-01-07 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-ユーザー登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（3秒以内）**：コードに明示的な要件定義なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml.cs` - RegisterModelクラス
- E-02: `Src/Infrastructure/Identity/ApplicationUser.cs` - ApplicationUserエンティティ
- E-03: `Src/WebUI/Startup.cs` - サービス登録設定
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ASP.NET Core Identityを使用したユーザー登録機能 | E-01 (21-24行目: UserManager, SignInManager使用) | ○ |
| C-02 | メールアドレスとパスワードを入力して登録 | E-01 (47-64行目: InputModelクラス定義) | ○ |
| C-03 | パスワードは6〜100文字の制限 | E-01 (55行目: StringLength(100, MinimumLength = 6)) | ○ |
| C-04 | メール確認トークンの生成と送信 | E-01 (84-93行目: GenerateEmailConfirmationTokenAsync, SendEmailAsync) | ○ |
| C-05 | RequireConfirmedAccountに応じた後続処理分岐 | E-01 (95-103行目: if文による分岐) | ○ |
| C-06 | [AllowAnonymous]属性により未認証アクセス許可 | E-01 (20行目: AllowAnonymous属性) | ○ |
| C-07 | UserManager.CreateAsync()でユーザー作成 | E-01 (79行目: CreateAsync呼び出し) | ○ |
| C-08 | 外部認証プロバイダー対応 | E-01 (69, 75行目: ExternalLogins取得) | ○ |
| C-09 | ApplicationUserはIdentityUserを継承 | E-02 (5-7行目: class定義) | ○ |
| C-10 | 画面No.8「新規登録画面（サーバー）」と連携 | E-05 (12行目: 画面No.8の定義) | ○ |
| C-11 | IEmailSender使用 | E-04 (3行目: 備考欄), E-01 (11, 26行目: using, DI) | ○ |
| C-12 | メールアドレス形式バリデーション | E-01 (50行目: EmailAddress属性) | ○ |
| C-13 | パスワード確認入力との一致チェック | E-01 (62行目: Compare属性) | ○ |
| C-14 | ユーザー名としてメールアドレスを使用 | E-01 (78行目: UserName = Input.Email) | ○ |
| C-15 | 作成失敗時のエラーをModelStateに追加 | E-01 (105-108行目: foreach error) | ○ |
| C-16 | Base64Urlエンコードでトークン送信 | E-01 (85行目: WebEncoders.Base64UrlEncode) | ○ |
| C-17 | SignInAsync()による自動ログイン | E-01 (101行目: SignInAsync呼び出し) | ○ |
| C-18 | レスポンス時間3秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（3秒以内）の根拠がコード内に見当たらない
  - 候補：非機能要件定義書 / SLA定義 / 性能テスト仕様書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 認証機能はASP.NET Core Identity標準機能を使用しており、セキュリティ面は堅牢
- 1: 中リスク - メール送信サービスの実装詳細が不明（IEmailSenderの具体的実装）

## 6) レビュアーチェックリスト（最小）
- [ ] パスワードポリシー（6文字以上）が業務要件を満たしているか確認
- [ ] メール送信サービス（IEmailSender）の実装が本番環境で適切に設定されているか確認
- [ ] RequireConfirmedAccount設定が業務要件に合致しているか確認
