---
generated_at: 2026-01-07 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-商品登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Controllers/ProductsController.cs` - 35-41行目 Create()メソッド
- E-02: `Src/Application/Products/Commands/CreateProduct/CreateProductCommand.cs` - 5-16行目 コマンド定義
- E-03: `Src/Application/Products/Commands/CreateProduct/CreateProductCommandHandler.cs` - 18-34行目 Handle()メソッド
- E-04: `Src/Domain/Entities/Product.cs` - 6-27行目 Productエンティティ定義
- E-05: `Src/Persistence/Configurations/ProductConfiguration.cs` - 9-33行目 EF Core設定
- E-06: `Src/Application/Common/Interfaces/INorthwindDbContext.cs` - DbSet<Product>定義
- E-07: `Docs/code-to-docs/機能一覧/機能一覧.csv` - No.11 商品登録の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントはPOST /api/Products | E-01 (35行目 [HttpPost]) | ○ |
| C-02 | [Authorize]属性により認証必須 | E-01 (14行目 [Authorize]) | ○ |
| C-03 | 入力パラメータはProductName, UnitPrice, SupplierId, CategoryId, Discontinued | E-02 (7-15行目) | ○ |
| C-04 | 戻り値の型はint（商品ID） | E-02 (IRequest<int>) | ○ |
| C-05 | Productエンティティを新規作成しDbSetに追加 | E-03 (20-29行目) | ○ |
| C-06 | SaveChangesAsync()でデータベースにコミット | E-03 (31行目) | ○ |
| C-07 | 生成された商品IDを返却 | E-03 (33行目 return entity.ProductId) | ○ |
| C-08 | ProductエンティティはAuditableEntityを継承 | E-04 (6行目) | ○ |
| C-09 | ProductNameは必須で最大40文字 | E-05 (15-17行目) | ○ |
| C-10 | UnitPriceはmoney型でデフォルト0 | E-05 (25-27行目) | ○ |
| C-11 | CategoryIdとSupplierIdは外部キー | E-04, E-05 | ○ |
| C-12 | MediatRパターンを使用 | E-01, E-03 (IRequestHandler) | ○ |
| C-13 | INorthwindDbContextを通じてデータアクセス | E-03 (11-16行目), E-06 | ○ |
| C-14 | ProductIdは自動生成 | E-05 (11行目 HasColumnName) + EF Core規約 | ○ |
| C-15 | OrderDetailsとのリレーションあり | E-04 (26行目) | ○ |
| C-16 | CategoryとSupplierとのリレーションあり | E-04 (24-25行目) | ○ |
| C-17 | Discontinuedはbool型 | E-02 (15行目), E-04 (22行目) | ○ |
| C-18 | 機能一覧でNo.11として定義 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張に対して根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）
- [x] エンドポイントの認証設定が正しいか確認済み
- [x] 入力パラメータの型とソースコードが一致しているか確認済み
- [x] データベース操作の内容が正確か確認済み
- [ ] バリデーションロジックの有無を確認（現在は未実装）
