---
generated_at: 2026-01-07 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-従業員詳細取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `Src/WebUI/Controllers/EmployeesController.cs` - 21-26行目 Get()メソッド
- E-02: `Src/Application/Employees/Queries/GetEmployeeDetail/GetEmployeeDetailQuery.cs` - クエリとハンドラー
- E-03: `Src/Application/Employees/Queries/GetEmployeeDetail/EmployeeDetailVm.cs` - ViewModel定義
- E-04: `Src/Application/Employees/Queries/GetEmployeeDetail/EmployeeTerritoryDto.cs` - DTO定義
- E-05: `Src/Domain/Entities/Employee.cs` - エンティティ定義
- E-06: `Docs/code-to-docs/機能一覧/機能一覧.csv` - No.19 従業員詳細取得の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントはGET /api/Employees/{id} | E-01 (21行目 [HttpGet("{id}")]) | ○ |
| C-02 | 入力パラメータはidのみ | E-02 (14行目 Id) | ○ |
| C-03 | 戻り値はEmployeeDetailVm | E-02 (IRequest<EmployeeDetailVm>) | ○ |
| C-04 | Where(EmployeeId == request.Id)で検索 | E-02 (29行目) | ○ |
| C-05 | ProjectTo<EmployeeDetailVm>でマッピング | E-02 (30-31行目) | ○ |
| C-06 | SingleOrDefaultAsync()で取得 | E-02 (32行目) | ○ |
| C-07 | EmployeeDetailVmに18個のプロパティ | E-03 (11-45行目) | ○ |
| C-08 | TitleOfCourtesy→Titleにマッピング | E-03 (51行目) | ○ |
| C-09 | Title→Positionにマッピング | E-03 (52行目) | ○ |
| C-10 | ReportsTo→ManagerIdにマッピング | E-03 (53行目) | ○ |
| C-11 | EmployeeTerritories→Territoriesにマッピング | E-03 (54行目) | ○ |
| C-12 | EmployeeTerritoryDtoにTerritoryId, Territory, Region | E-04 (9-13行目) | ○ |
| C-13 | Territory名はTerritoryDescriptionから | E-04 (19行目) | ○ |
| C-14 | Region名はRegionDescriptionから | E-04 (20行目) | ○ |
| C-15 | Ok()でレスポンス返却 | E-01 (25行目) | ○ |
| C-16 | Employeeエンティティの構造 | E-05 | ○ |
| C-17 | MediatRパターンを使用 | E-01, E-02 (IRequestHandler) | ○ |
| C-18 | 機能一覧でNo.19として定義 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張に対して根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードにより裏付けられている
- 注意: 存在しないIDの場合、nullが返却される（NotFoundExceptionではない）

## 6) レビュアーチェックリスト（最小）
- [x] エンドポイントの認証設定が正しいか確認済み
- [x] DTOプロパティマッピングが正確か確認済み
- [x] リレーションデータの取得が正しいか確認済み
- [ ] 存在しないID時の挙動を確認（現在はnull返却）
