---
generated_at: 2026-01-07 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-ログイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs` - LoginModelクラス
- E-02: `Src/Infrastructure/Identity/ApplicationUser.cs` - ApplicationUserエンティティ
- E-03: `Src/WebUI/Startup.cs` - サービス登録・認証設定
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ASP.NET Core Identityを使用したログイン機能 | E-01 (21-24行目: UserManager, SignInManager使用) | ○ |
| C-02 | メールアドレスとパスワードで認証 | E-01 (47-59行目: InputModelクラス定義) | ○ |
| C-03 | RememberMe機能による永続Cookie発行 | E-01 (57-58行目: RememberMeプロパティ, 86行目: 引数) | ○ |
| C-04 | アカウントロックアウト機能 | E-01 (86行目: lockoutOnFailure: true), E-04 (3行目) | ○ |
| C-05 | 二要素認証対応 | E-01 (92-95行目: RequiresTwoFactor分岐), E-04 (3行目) | ○ |
| C-06 | PasswordSignInAsync()による認証 | E-01 (86行目: PasswordSignInAsync呼び出し) | ○ |
| C-07 | [AllowAnonymous]属性により未認証アクセス許可 | E-01 (18行目: AllowAnonymous属性) | ○ |
| C-08 | 外部認証スキーム一覧取得 | E-01 (73行目: GetExternalAuthenticationSchemesAsync) | ○ |
| C-09 | 外部認証Cookie削除 | E-01 (71行目: SignOutAsync(IdentityConstants.ExternalScheme)) | ○ |
| C-10 | 確認メール再送信機能 | E-01 (112-139行目: OnPostSendVerificationEmailAsync) | ○ |
| C-11 | IEmailSender使用 | E-01 (24, 33行目: using, DI) | ○ |
| C-12 | 画面No.5,6,7と連携 | E-05 (8-10行目) | ○ |
| C-13 | ログイン失敗時エラーメッセージ | E-01 (103行目: "Invalid login attempt.") | ○ |
| C-14 | ロックアウト時Lockoutページへリダイレクト | E-01 (96-100行目: RedirectToPage("./Lockout")) | ○ |
| C-15 | 二要素認証時LoginWith2faへリダイレクト | E-01 (92-95行目: RedirectToPage("./LoginWith2fa")) | ○ |
| C-16 | returnUrlへのリダイレクト | E-01 (90行目: LocalRedirect(returnUrl)) | ○ |
| C-17 | EmailAddress形式バリデーション | E-01 (50行目: EmailAddress属性) | ○ |
| C-18 | Password必須バリデーション | E-01 (53行目: Required属性) | ○ |
| C-19 | 認証・認可ミドルウェア設定 | E-03 (105-107行目: UseAuthentication等) | ○ |
| C-20 | IdentityServer連携 | E-03 (106行目: UseIdentityServer), E-05 (8行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で不足情報はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 認証機能はASP.NET Core Identity標準機能を使用しており、セキュリティ面は堅牢
- 0: 低リスク - lockoutOnFailure: trueでブルートフォース攻撃対策済み

## 6) レビュアーチェックリスト（最小）
- [ ] ロックアウトポリシー（失敗回数、ロック期間）が業務要件に合致しているか確認
- [ ] 二要素認証の設定が適切に行われているか確認
- [ ] パスワードポリシーがセキュリティ要件を満たしているか確認
