---
generated_at: 2026-01-07 22:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-従業員削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **従業員に関連するテリトリーや注文がある場合の動作**：TODOコメントのみで実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/Application/Employees/Commands/DeleteEmployee/DeleteEmployeeCommand.cs`（1-57行目）
- E-02: `Src/WebUI/Controllers/EmployeesController.cs`（39-47行目）
- E-03: `Src/Domain/Entities/Employee.cs`（1-41行目）
- E-04: `Src/Application/Common/Interfaces/ICurrentUserService.cs`（1-9行目）
- E-05: `Src/Application/Common/Interfaces/IUserManager.cs`（1-12行目）
- E-06: `Src/Application/Common/Interfaces/INorthwindDbContext.cs`（1-34行目）
- E-07: `Src/Application/Common/Exceptions/NotFoundException.cs`（1-12行目）
- E-08: `Src/Application/Common/Exceptions/BadRequestException.cs`（1-12行目）
- E-09: `Docs/code-to-docs/機能一覧/機能一覧.csv`（22行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 従業員IDに基づいて削除する機能である | E-01（12行目）, E-02（42-44行目） | ○ |
| C-02 | DELETE /api/Employees/{id}がエンドポイント | E-02（39-46行目） | ○ |
| C-03 | 存在しない場合はNotFoundExceptionをスロー | E-01（32-35行目）, E-07 | ○ |
| C-04 | 自分自身は削除できない | E-01（37-40行目） | ○ |
| C-05 | 自己削除時はBadRequestExceptionをスロー | E-01（39行目）, E-08 | ○ |
| C-06 | UserIdが存在する場合はユーザーアカウントも削除 | E-01（42-45行目）, E-05 | ○ |
| C-07 | Employees.Removeで削除を実行 | E-01（49行目） | ○ |
| C-08 | SaveChangesAsyncで保存 | E-01（51行目） | ○ |
| C-09 | ICurrentUserServiceでユーザー確認 | E-01（18, 24, 37行目）, E-04 | ○ |
| C-10 | INorthwindDbContextを使用 | E-01（16, 20, 29, 49, 51行目）, E-06 | ○ |
| C-11 | MediatRパターンを使用 | E-01（1行目）, E-02（44行目） | ○ |
| C-12 | 成功時は204 No Contentを返す | E-02（40, 46行目） | ○ |
| C-13 | 404エラーコードを返す | E-02（41行目） | ○ |
| C-14 | Employeeエンティティが定義されている | E-03（7-40行目） | ○ |
| C-15 | UserIdフィールドが存在する | E-03（17行目） | ○ |
| C-16 | FindAsyncで検索を行う | E-01（29-30行目） | ○ |
| C-17 | 機能一覧に「従業員削除」が定義されている | E-09 | ○ |
| C-18 | 関連するテリトリーや注文がある場合エラーになる可能性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18について：TODOコメント（E-01の47行目）に記載があるが、実際の動作は外部キー制約の設定に依存する。データベース設計書の制約定義を確認する必要がある。
  - 候補：`Src/Persistence/Configurations/EmployeeConfiguration.cs` / データベース設計書 / 外部キー制約の定義

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: 関連データ（Territory、Order）が存在する場合の削除動作がTODOのまま。実運用時にエラーが発生する可能性がある。
- **0（低リスク）**: ユーザーアカウント削除とEmployee削除のトランザクション整合性について、確認が必要。

## 6) レビュアーチェックリスト（最小）
- [ ] 自己削除防止ロジックが正しく実装されているか確認
- [ ] UserManager.DeleteUserAsyncの実装と例外処理を確認
- [ ] 外部キー制約による削除制限の動作確認
- [ ] 画面からの呼び出しフローの確認（画面機能マッピングに未定義）
