---
generated_at: 2026-01-07 22:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：22-サンプルデータ投入

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **投入されるデータ件数**：SampleDataSeeder.csが大きすぎて全数確認困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Program.cs`（22-48行目）
- E-02: `Src/Application/System/Commands/SeedSampleData/SeedSampleDataCommand.cs`（1-33行目）
- E-03: `Src/Application/System/Commands/SeedSampleData/SampleDataSeeder.cs`（1-80行目、行番号検索結果）
- E-04: `Src/Application/Common/Interfaces/INorthwindDbContext.cs`（1-34行目）
- E-05: `Src/Application/Common/Interfaces/IUserManager.cs`（1-12行目）
- E-06: `Docs/code-to-docs/機能一覧/機能一覧.csv`（23行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アプリケーション起動時に自動実行される | E-01（38-39行目） | ○ |
| C-02 | データベースマイグレーションを先に実行する | E-01（32-36行目） | ○ |
| C-03 | 顧客データが存在する場合はスキップする | E-03（31-34行目） | ○ |
| C-04 | MediatRのSendでコマンドを発行 | E-01（39行目）, E-02（9-11行目） | ○ |
| C-05 | SampleDataSeederクラスで投入処理を行う | E-02（26-28行目）, E-03（12行目） | ○ |
| C-06 | 投入順序は顧客から開始される | E-03（36行目） | ○ |
| C-07 | 従業員データ投入後にユーザーを作成 | E-03（54-55行目） | ○ |
| C-08 | ユーザー名は{firstname}@northwind形式 | E-03（68行目） | ○ |
| C-09 | 初期パスワードは「Northwind1!」 | E-03（69行目） | ○ |
| C-10 | INorthwindDbContextを使用 | E-02（15, 18行目）, E-04 | ○ |
| C-11 | IUserManagerを使用 | E-02（16, 21行目）, E-05 | ○ |
| C-12 | Unit型を返却 | E-02（30行目） | ○ |
| C-13 | SeedAllAsyncで全データ投入を行う | E-03（29行目） | ○ |
| C-14 | Regionsデータを投入 | E-03（38行目） | ○ |
| C-15 | Territoriesデータを投入 | E-03（40行目） | ○ |
| C-16 | Employeesデータを投入 | E-03（42行目） | ○ |
| C-17 | Categoriesデータを投入 | E-03（44行目） | ○ |
| C-18 | Ordersデータを投入 | E-03（52行目） | ○ |
| C-19 | 機能一覧に「サンプルデータ投入」が定義されている | E-06 | ○ |
| C-20 | 投入データ件数（顧客91件など）の正確性 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20について：SampleDataSeeder.csのファイルサイズが1.4MBを超えており、全体を読み込めなかったため、投入されるデータの正確な件数は確認できていない。
  - 候補：SampleDataSeeder.csを分割して確認 / 実行後のデータベース検証

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: 初期パスワード「Northwind1!」がソースコードにハードコーディングされている。本番環境での使用は避けるべき。
- **0（低リスク）**: TODOコメントに「Add to manager role」があり、管理職へのロール付与が未実装。

## 6) レビュアーチェックリスト（最小）
- [ ] SampleDataSeeder.csの投入データ内容が適切か確認
- [ ] 本番環境でこの機能が無効化されているか確認
- [ ] 初期パスワードのセキュリティリスクを認識しているか
- [ ] データ投入中のエラー発生時の挙動確認
