---
generated_at: 2026-01-07 22:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-例外ハンドリング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Common/CustomExceptionHandlerMiddleware.cs`（1-72行目）
- E-02: `Src/Application/Common/Exceptions/ValidationException.cs`（1-36行目）
- E-03: `Src/Application/Common/Exceptions/BadRequestException.cs`（1-12行目）
- E-04: `Src/Application/Common/Exceptions/NotFoundException.cs`（1-12行目）
- E-05: `Src/WebUI/Startup.cs`（89行目）
- E-06: `Docs/code-to-docs/機能一覧/機能一覧.csv`（24行目）
- E-07: `Docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（14行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ミドルウェアとして実装されている | E-01（11-63行目） | ○ |
| C-02 | RequestDelegateを使用した委譲パターン | E-01（13, 24行目） | ○ |
| C-03 | try-catchで例外をキャッチ | E-01（22-29行目） | ○ |
| C-04 | ValidationExceptionで400を返す | E-01（40-43行目） | ○ |
| C-05 | ValidationExceptionでFailuresをシリアライズ | E-01（42行目）, E-02（34行目） | ○ |
| C-06 | BadRequestExceptionで400を返す | E-01（44-46行目） | ○ |
| C-07 | BadRequestExceptionでメッセージを返す | E-01（46行目）, E-03（7-8行目） | ○ |
| C-08 | NotFoundExceptionで404を返す | E-01（48-49行目） | ○ |
| C-09 | デフォルトで500を返す | E-01（34行目） | ○ |
| C-10 | Content-Typeはapplication/json | E-01（53行目） | ○ |
| C-11 | Newtonsoft.Jsonでシリアライズ | E-01（3, 42, 58行目） | ○ |
| C-12 | 拡張メソッドUseCustomExceptionHandlerが提供される | E-01（65-70行目） | ○ |
| C-13 | Startup.csで登録される | E-05 | ○ |
| C-14 | ValidationExceptionはFailuresプロパティを持つ | E-02（34行目） | ○ |
| C-15 | NotFoundExceptionはエンティティ名とキーを含む | E-04（7-8行目） | ○ |
| C-16 | 機能一覧に「例外ハンドリング」が定義されている | E-06 | ○ |
| C-17 | 画面機能マッピングでエラー画面と関連付けられている | E-07 | ○ |
| C-18 | 空のresultの場合はデフォルトのエラーJSONを生成 | E-01（56-59行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張にソースコードの根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: Exception.Messageをそのままクライアントに返却しているため、本番環境でセンシティブな情報が漏洩する可能性がある。
- **0（低リスク）**: 開発環境ではUseDeveloperExceptionPage()が先に適用されるため、このミドルウェアの動作検証が必要。

## 6) レビュアーチェックリスト（最小）
- [ ] 本番環境でException.Messageの内容が適切か確認
- [ ] 各例外クラスの使用箇所で適切なメッセージが設定されているか確認
- [ ] 開発環境と本番環境でのエラー表示の違いを理解しているか
- [ ] Content-Type: application/json固定で問題ないか確認
