---
generated_at: 2026-01-07 10:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-顧客一覧取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Controllers/CustomersController.cs` - CustomersControllerクラス
- E-02: `Src/Application/Customers/Queries/GetCustomersList/GetCustomersListQuery.cs` - クエリ定義
- E-03: `Src/Application/Customers/Queries/GetCustomersList/GetCustomersListQueryHandler.cs` - クエリハンドラ
- E-04: `Src/Application/Customers/Queries/GetCustomersList/CustomerLookupDto.cs` - DTO定義
- E-05: `Src/Application/Customers/Queries/GetCustomersList/CustomersListVm.cs` - ViewModel定義
- E-06: `Src/Domain/Entities/Customer.cs` - ドメインエンティティ
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GET /api/Customersエンドポイントでアクセス | E-01 (16行目: [HttpGet]), E-07 (5行目: 備考) | ○ |
| C-02 | [Authorize]属性により認証必須 | E-01 (13行目: [Authorize]) | ○ |
| C-03 | MediatRを通じてクエリ発行 | E-01 (19行目: Mediator.Send) | ○ |
| C-04 | GetCustomersListQueryはパラメータなし | E-02 (5-7行目: 空のクラス定義) | ○ |
| C-05 | INorthwindDbContext.Customersからデータ取得 | E-03 (24行目: _context.Customers) | ○ |
| C-06 | ProjectTo<CustomerLookupDto>でマッピング | E-03 (25行目: ProjectTo) | ○ |
| C-07 | ToListAsync()で非同期実行 | E-03 (26行目: ToListAsync) | ○ |
| C-08 | CustomersListVmにラップして返却 | E-03 (28-31行目: new CustomersListVm) | ○ |
| C-09 | CustomerLookupDtoはId, Nameの2プロパティ | E-04 (9-10行目: プロパティ定義) | ○ |
| C-10 | CustomerId→Id, CompanyName→Nameのマッピング | E-04 (14-16行目: CreateMap設定) | ○ |
| C-11 | Ok(vm)でHTTP 200返却 | E-01 (21行目: return Ok) | ○ |
| C-12 | 画面No.3「顧客一覧画面」と連携 | E-08 (5行目) | ○ |
| C-13 | CustomersClient.getAll()から呼び出し | E-08 (5行目: 関連する操作・処理) | ○ |
| C-14 | 全ての顧客情報を一覧形式で取得 | E-07 (5行目: 機能説明) | ○ |
| C-15 | Customerエンティティに全プロパティ定義 | E-06 (5-25行目: クラス定義) | ○ |
| C-16 | IList<CustomerLookupDto>としてリスト返却 | E-05 (7行目: Customersプロパティ) | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で不足情報はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 標準的なCQRSパターンでの実装
- 0: 低リスク - Entity FrameworkによるSQLインジェクション対策済み

## 6) レビュアーチェックリスト（最小）
- [ ] 大量データ時のパフォーマンスが許容範囲内か確認（ページング未実装）
- [ ] 返却するデータ項目（Id, Name）が業務要件を満たしているか確認
