---
generated_at: 2026-01-07 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-顧客詳細取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Controllers/CustomersController.cs` - CustomersControllerクラス
- E-02: `Src/Application/Customers/Queries/GetCustomerDetail/GetCustomerDetailQuery.cs` - クエリ定義
- E-03: `Src/Application/Customers/Queries/GetCustomerDetail/GetCustomerDetailQueryHandler.cs` - クエリハンドラ
- E-04: `Src/Application/Customers/Queries/GetCustomerDetail/GetCustomerDetailQueryValidator.cs` - バリデーター
- E-05: `Src/Application/Customers/Queries/GetCustomerDetail/CustomerDetailVm.cs` - ViewModel定義
- E-06: `Src/Domain/Entities/Customer.cs` - ドメインエンティティ
- E-07: `Src/Application/Common/Exceptions/NotFoundException.cs` - 例外クラス
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GET /api/Customers/{id}エンドポイントでアクセス | E-01 (24行目: [HttpGet("{id}")]), E-08 (6行目: 備考) | ○ |
| C-02 | [Authorize]属性により認証必須 | E-01 (13行目: [Authorize]) | ○ |
| C-03 | MediatRを通じてクエリ発行 | E-01 (29行目: Mediator.Send) | ○ |
| C-04 | GetCustomerDetailQueryはIdパラメータを持つ | E-02 (7行目: Id プロパティ) | ○ |
| C-05 | FluentValidationでIDバリデーション | E-04 (9行目: RuleFor(v => v.Id).NotEmpty().Length(5)) | ○ |
| C-06 | FindAsync()で主キー検索 | E-03 (24-25行目: FindAsync(request.Id)) | ○ |
| C-07 | 存在しない場合はNotFoundExceptionスロー | E-03 (27-30行目: throw new NotFoundException) | ○ |
| C-08 | NotFoundExceptionのメッセージ形式 | E-07 (7-9行目: "Entity \"{name}\" ({key}) was not found.") | ○ |
| C-09 | AutoMapperでCustomerDetailVmにマッピング | E-03 (32行目: _mapper.Map<CustomerDetailVm>) | ○ |
| C-10 | CustomerId→Idのマッピング設定 | E-05 (23-24行目: ForMember設定) | ○ |
| C-11 | ProducesResponseType(200)と(404)定義 | E-01 (25-26行目: ProducesResponseType属性) | ○ |
| C-12 | Ok(vm)でHTTP 200返却 | E-01 (31行目: return Ok) | ○ |
| C-13 | 画面No.3,4と連携 | E-09 (6-7行目) | ○ |
| C-14 | 指定した顧客IDに基づいて詳細取得 | E-08 (6行目: 機能説明) | ○ |
| C-15 | CustomerDetailVmは11プロパティを持つ | E-05 (9-19行目: プロパティ定義) | ○ |
| C-16 | CustomerエンティティはOrdersコレクション持つ | E-06 (9, 24行目: Orders) | ○ |
| C-17 | IMapFrom<Customer>でマッピング設定 | E-05 (7行目: IMapFrom実装) | ○ |
| C-18 | 顧客IDは5文字固定のバリデーション | E-04 (9行目: Length(5)) | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で不足情報はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 標準的なCQRSパターンでの実装
- 0: 低リスク - FluentValidationによる入力検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] 返却するデータ項目が業務要件を満たしているか確認
- [ ] 顧客IDの5文字制限がデータベース設計と整合しているか確認
