---
generated_at: 2026-01-07 10:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-顧客登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Controllers/CustomersController.cs` - CustomersControllerクラス
- E-02: `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommand.cs` - コマンド・ハンドラ
- E-03: `Src/Application/Customers/Commands/CreateCustomer/CreateCustomerCommandValidator.cs` - バリデーター
- E-04: `Src/Application/Customers/Commands/CreateCustomer/CustomerCreated.cs` - ドメインイベント
- E-05: `Src/Domain/Entities/Customer.cs` - ドメインエンティティ
- E-06: `Src/Persistence/Configurations/CustomerConfiguration.cs` - エンティティ設定
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | POST /api/Customersエンドポイントでアクセス | E-01 (34行目: [HttpPost]), E-07 (7行目: 備考) | ○ |
| C-02 | [Authorize]属性により認証必須 | E-01 (13行目: [Authorize]) | ○ |
| C-03 | [FromBody]でJSONデシリアライズ | E-01 (37行目: FromBody属性) | ○ |
| C-04 | MediatRを通じてコマンド発行 | E-01 (39行目: Mediator.Send) | ○ |
| C-05 | CreateCustomerCommandは11プロパティを持つ | E-02 (11-31行目: プロパティ定義) | ○ |
| C-06 | 内部Handlerクラスでコマンド処理 | E-02 (33-68行目: Handler class) | ○ |
| C-07 | Customerエンティティを作成 | E-02 (46-58行目: new Customer) | ○ |
| C-08 | _context.Customers.Add()で追加 | E-02 (60行目: Add) | ○ |
| C-09 | SaveChangesAsync()で永続化 | E-02 (62行目: SaveChangesAsync) | ○ |
| C-10 | CustomerCreatedイベントをPublish | E-02 (64行目: Publish), E-04 | ○ |
| C-11 | NoContent()でHTTP 204返却 | E-01 (41行目: return NoContent) | ○ |
| C-12 | Id: 5文字固定、必須のバリデーション | E-03 (9行目: Length(5).NotEmpty) | ○ |
| C-13 | CompanyName: 最大40文字、必須 | E-03 (12行目: MaximumLength(40).NotEmpty) | ○ |
| C-14 | PostalCode: 最大10文字、必須 | E-03 (18行目: MaximumLength(10).NotEmpty) | ○ |
| C-15 | Address: 最大60文字 | E-03 (10行目: MaximumLength(60)), E-06 (16行目) | ○ |
| C-16 | City: 最大15文字 | E-03 (11行目: MaximumLength(15)), E-06 (18行目) | ○ |
| C-17 | ContactName: 最大30文字 | E-03 (13行目: MaximumLength(30)), E-06 (24行目) | ○ |
| C-18 | Phone: 最大24文字 | E-03 (17行目: MaximumLength(24)), E-06 (32行目) | ○ |
| C-19 | 新規顧客を登録する機能 | E-07 (7行目: 機能説明) | ○ |
| C-20 | CustomerエンティティにOrdersコレクション | E-05 (9, 24行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で不足情報はありません

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Regionプロパティがコマンドにあるがエンティティ作成時に設定されていない（E-02 57行目参照：PostalCodeまでで終了）
- 0: 低リスク - FluentValidationによる入力検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] 顧客ID（5文字）の採番ルールが業務要件と整合しているか確認
- [ ] Regionプロパティが設定されない問題が許容されるか確認
- [ ] CustomerCreatedイベントのハンドラが適切に実装されているか確認
