---
generated_at: 2026-01-07 10:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-顧客更新

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Controllers/CustomersController.cs` - CustomersControllerクラス
- E-02: `Src/Application/Customers/Commands/UpdateCustomer/UpdateCustomerCommand.cs` - コマンド・ハンドラ
- E-03: `Src/Application/Customers/Commands/UpdateCustomer/UpdateCustomerCommandValidator.cs` - バリデーター
- E-04: `Src/Domain/Entities/Customer.cs` - ドメインエンティティ
- E-05: `Src/Application/Common/Exceptions/NotFoundException.cs` - 例外クラス
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PUT /api/Customers/{id}エンドポイントでアクセス | E-01 (44行目: [HttpPut("{id}")]), E-06 (8行目: 備考) | ○ |
| C-02 | [Authorize]属性により認証必須 | E-01 (13行目: [Authorize]) | ○ |
| C-03 | [FromBody]でJSONデシリアライズ | E-01 (47行目: FromBody属性) | ○ |
| C-04 | MediatRを通じてコマンド発行 | E-01 (49行目: Mediator.Send) | ○ |
| C-05 | SingleOrDefaultAsync()で顧客検索 | E-02 (36-37行目: SingleOrDefaultAsync) | ○ |
| C-06 | 存在しない場合はNotFoundExceptionスロー | E-02 (39-42行目: throw new NotFoundException) | ○ |
| C-07 | エンティティのプロパティを更新 | E-02 (44-52行目: entity.Property = request.Property) | ○ |
| C-08 | SaveChangesAsync()で永続化 | E-02 (54行目: SaveChangesAsync) | ○ |
| C-09 | NoContent()でHTTP 204返却 | E-01 (51行目: return NoContent) | ○ |
| C-10 | ProducesResponseType(204)と(404)定義 | E-01 (45-46行目: ProducesResponseType属性) | ○ |
| C-11 | Id: 最大5文字、必須 | E-03 (10行目: MaximumLength(5).NotEmpty) | ○ |
| C-12 | CompanyName: 最大40文字、必須 | E-03 (12行目: MaximumLength(40).NotEmpty) | ○ |
| C-13 | Fax: 最大24文字、必須 | E-03 (17行目: MaximumLength(24).NotEmpty) | ○ |
| C-14 | Phone: 最大24文字、必須 | E-03 (18行目: MaximumLength(24).NotEmpty) | ○ |
| C-15 | オーストラリア郵便番号4桁ルール | E-03 (22-24行目: Matches, When Australia) | ○ |
| C-16 | クイーンズランド電話番号ルール | E-03 (26-29行目: Must HaveQueenslandLandLine) | ○ |
| C-17 | HaveQueenslandLandLineメソッド実装 | E-03 (32-35行目: StartsWith("07")チェック) | ○ |
| C-18 | 既存の顧客情報を更新する機能 | E-06 (8行目: 機能説明) | ○ |
| C-19 | UpdateCustomerCommandは11プロパティを持つ | E-02 (11-23行目: プロパティ定義) | ○ |
| C-20 | Regionは更新対象外 | E-02 (44-52行目: Regionの更新なし) | ○ |
| C-21 | NotFoundExceptionのメッセージ形式 | E-05 (7-9行目) | ○ |
| C-22 | PostalCode.StartsWith("4")条件 | E-03 (28行目: PostalCode.StartsWith("4")) | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で不足情報はありません

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Regionプロパティがコマンドにあるが更新対象外（意図的かどうか確認必要）
- 1: 中リスク - 楽観的ロックが実装されていない（同時更新時のデータ整合性）
- 0: 低リスク - オーストラリア特有のバリデーションルールの妥当性確認

## 6) レビュアーチェックリスト（最小）
- [ ] Regionプロパティが更新対象外であることが業務要件と整合しているか確認
- [ ] 同時更新時のデータ整合性要件を確認（楽観的ロック導入要否）
- [ ] オーストラリア特有のバリデーションルールが業務要件と整合しているか確認
