---
generated_at: 2026-01-07 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-顧客削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/Controllers/CustomersController.cs` - CustomersControllerクラス
- E-02: `Src/Application/Customers/Commands/DeleteCustomer/DeleteCustomerCommand.cs` - コマンド定義
- E-03: `Src/Application/Customers/Commands/DeleteCustomer/DeleteCustomerCommandHandler.cs` - コマンドハンドラ
- E-04: `Src/Application/Customers/Commands/DeleteCustomer/DeleteCustomerCommandValidator.cs` - バリデーター
- E-05: `Src/Application/Common/Exceptions/NotFoundException.cs` - 例外クラス
- E-06: `Src/Application/Common/Exceptions/DeleteFailureException.cs` - 削除失敗例外クラス
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DELETE /api/Customers/{id}エンドポイントでアクセス | E-01 (54行目: [HttpDelete("{id}")]), E-07 (9行目: 備考) | ○ |
| C-02 | [Authorize]属性により認証必須 | E-01 (13行目: [Authorize]) | ○ |
| C-03 | MediatRを通じてコマンド発行 | E-01 (59行目: Mediator.Send) | ○ |
| C-04 | DeleteCustomerCommandはIdのみ持つ | E-02 (5-8行目: Idプロパティのみ) | ○ |
| C-05 | FindAsync()で顧客検索 | E-03 (22-23行目: FindAsync) | ○ |
| C-06 | 存在しない場合はNotFoundExceptionスロー | E-03 (25-28行目: throw new NotFoundException) | ○ |
| C-07 | Orders.Any()で関連受注チェック | E-03 (30行目: _context.Orders.Any) | ○ |
| C-08 | 受注あり場合はDeleteFailureExceptionスロー | E-03 (31-34行目: throw new DeleteFailureException) | ○ |
| C-09 | DeleteFailureExceptionのメッセージ | E-06 (7-9行目: "Deletion of entity...") | ○ |
| C-10 | 受注なければRemove()で削除マーク | E-03 (36行目: Remove) | ○ |
| C-11 | SaveChangesAsync()で永続化 | E-03 (38行目: SaveChangesAsync) | ○ |
| C-12 | NoContent()でHTTP 204返却 | E-01 (61行目: return NoContent) | ○ |
| C-13 | ProducesResponseType(204)と(404)定義 | E-01 (55-56行目: ProducesResponseType属性) | ○ |
| C-14 | Id: 5文字固定、必須のバリデーション | E-04 (9行目: NotEmpty().Length(5)) | ○ |
| C-15 | 指定した顧客IDに基づいて削除 | E-07 (9行目: 機能説明) | ○ |
| C-16 | NotFoundExceptionのメッセージ形式 | E-05 (7-9行目) | ○ |
| C-17 | CustomerId条件で受注検索 | E-03 (30行目: o.CustomerId == entity.CustomerId) | ○ |
| C-18 | 削除失敗メッセージに受注関連説明あり | E-03 (33行目: "There are existing orders...") | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で不足情報はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 参照整合性チェックにより安全な削除処理を実現
- 0: 低リスク - 物理削除のため、削除後のデータ復旧は不可能（業務要件確認）

## 6) レビュアーチェックリスト（最小）
- [ ] 物理削除が業務要件に合致しているか確認（論理削除の要否）
- [ ] 関連受注が存在する顧客の削除要件を確認（受注の移行、アーカイブ等）
- [ ] 削除権限が特定ロールに限定されるべきか確認
