---
generated_at: 2026-01-07 22:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Src/WebUI/ClientApp/src/app/app.routing.module.ts` - Angularルーティング定義
- E-02: `Src/WebUI/ClientApp/src/app/app.module.ts` - Angularモジュール定義
- E-03: `Src/WebUI/ClientApp/src/app/home/home.component.ts` - ホームコンポーネント
- E-04: `Src/WebUI/ClientApp/src/app/home/home.component.html` - ホームテンプレート
- E-05: `Src/WebUI/ClientApp/src/app/products/products.component.ts` - 商品コンポーネント
- E-06: `Src/WebUI/ClientApp/src/app/products/products.component.html` - 商品テンプレート
- E-07: `Src/WebUI/ClientApp/src/app/customers/customers.component.ts` - 顧客コンポーネント
- E-08: `Src/WebUI/ClientApp/src/app/customers/customers.component.html` - 顧客テンプレート
- E-09: `Src/WebUI/ClientApp/src/app/customer-detail/customer-detail.component.ts` - 顧客詳細コンポーネント
- E-10: `Src/WebUI/ClientApp/src/app/customer-detail/customer-detail.component.html` - 顧客詳細テンプレート
- E-11: `Src/WebUI/ClientApp/src/api-authorization/api-authorization.module.ts` - 認証モジュール定義
- E-12: `Src/WebUI/ClientApp/src/api-authorization/api-authorization.constants.ts` - 認証パス定義
- E-13: `Src/WebUI/ClientApp/src/api-authorization/login/login.component.ts` - ログインコンポーネント
- E-14: `Src/WebUI/ClientApp/src/api-authorization/logout/logout.component.ts` - ログアウトコンポーネント
- E-15: `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml` - サーバーサイドログインページ
- E-16: `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml` - サーバーサイド登録ページ
- E-17: `Src/WebUI/Pages/Error.cshtml` - エラーページ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ホーム画面が存在し、ルートパス（/）でアクセス可能 | E-01, E-03, E-04 | ○ |
| C-02 | 商品一覧画面が存在し、/productsでアクセス可能 | E-01, E-05, E-06 | ○ |
| C-03 | 商品一覧画面は認証不要 | E-01 | ○ |
| C-04 | 顧客一覧画面が存在し、/customersでアクセス可能 | E-01, E-07, E-08 | ○ |
| C-05 | 顧客一覧画面はAuthorizeGuardで保護されている | E-01 | ○ |
| C-06 | 顧客詳細はモーダルダイアログで表示される | E-07, E-09, E-10 | ○ |
| C-07 | 顧客詳細はBsModalServiceを使用して表示 | E-07 | ○ |
| C-08 | ログイン画面（SPA）が/authentication/loginで存在 | E-11, E-12, E-13 | ○ |
| C-09 | ログアウト画面（SPA）が/authentication/logoutで存在 | E-11, E-12, E-14 | ○ |
| C-10 | サーバーサイドログイン画面が/Identity/Account/Loginで存在 | E-12, E-15 | ○ |
| C-11 | サーバーサイド登録画面が/Identity/Account/Registerで存在 | E-12, E-16 | ○ |
| C-12 | エラー画面がRazor Pagesとして存在 | E-17 | ○ |
| C-13 | ログイン画面からサーバーサイド登録画面へ遷移可能 | E-13, E-12 | ○ |
| C-14 | サーバーサイドログイン画面から登録画面へ遷移可能 | E-15 | ○ |
| C-15 | 商品一覧画面でCSVエクスポートが可能 | E-06 | ○ |
| C-16 | 顧客一覧画面で行クリックにより詳細を表示 | E-08 | ○ |
| C-17 | アプリケーション名はNorthwind Traders | E-04, E-12 | ○ |
| C-18 | 認証にIdentityServerを使用 | E-11, E-12, E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての画面情報はソースコードから直接確認できた。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードにより裏付けられており、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] ルーティング定義（app.routing.module.ts）と画面一覧の整合性を確認
- [ ] 認証が必要な画面（顧客一覧）のAuthorizeGuard適用を確認
- [ ] サーバーサイドIdentityページ（Login.cshtml, Register.cshtml）の存在を確認
- [ ] モーダルダイアログ（顧客詳細）の実装を確認
- [ ] 画面遷移図のmermaid記法が正しくレンダリングされることを確認
