# Northwind Traders 画面遷移図

## 概要

本ドキュメントは、Northwind Tradersアプリケーションの画面遷移を示します。
本アプリケーションはAngularフロントエンド（SPA）とASP.NET Core Identity（サーバーサイド認証）の2層構成となっています。

## 画面遷移図

```mermaid
flowchart TD
    subgraph SPA["Angular SPA"]
        HOME[ホーム画面<br>/]
        PRODUCTS[商品一覧画面<br>/products]
        CUSTOMERS[顧客一覧画面<br>/customers]
        CUSTOMER_DETAIL[顧客詳細モーダル]
        LOGIN_SPA[ログイン画面<br>/authentication/login]
        LOGOUT_SPA[ログアウト画面<br>/authentication/logout]
    end

    subgraph SERVER["ASP.NET Core Identity"]
        LOGIN_SERVER[ログイン画面<br>/Identity/Account/Login]
        REGISTER_SERVER[新規登録画面<br>/Identity/Account/Register]
        ERROR[エラー画面]
    end

    %% メイン画面からの遷移
    HOME -->|ナビゲーション| PRODUCTS
    HOME -->|ナビゲーション| CUSTOMERS

    %% 商品一覧画面の遷移
    PRODUCTS -->|ナビゲーション| HOME
    PRODUCTS -->|ナビゲーション| CUSTOMERS

    %% 顧客一覧画面の遷移（認証必要）
    CUSTOMERS -->|ナビゲーション| HOME
    CUSTOMERS -->|ナビゲーション| PRODUCTS
    CUSTOMERS -->|行クリック| CUSTOMER_DETAIL
    CUSTOMER_DETAIL -->|閉じる| CUSTOMERS

    %% 認証フロー
    HOME -->|ログイン| LOGIN_SPA
    PRODUCTS -->|ログイン| LOGIN_SPA
    CUSTOMERS -.->|未認証時リダイレクト| LOGIN_SPA

    LOGIN_SPA -->|リダイレクト| LOGIN_SERVER
    LOGIN_SPA -->|登録へ| REGISTER_SERVER
    LOGIN_SERVER -->|登録リンク| REGISTER_SERVER
    REGISTER_SERVER -->|ログインへ| LOGIN_SERVER

    LOGIN_SERVER -->|認証成功| HOME
    REGISTER_SERVER -->|登録成功| LOGIN_SPA

    %% ログアウトフロー
    HOME -->|ログアウト| LOGOUT_SPA
    PRODUCTS -->|ログアウト| LOGOUT_SPA
    CUSTOMERS -->|ログアウト| LOGOUT_SPA
    LOGOUT_SPA -->|完了| HOME

    %% エラー遷移
    HOME -.->|エラー発生| ERROR
    PRODUCTS -.->|エラー発生| ERROR
    CUSTOMERS -.->|エラー発生| ERROR

    %% スタイル定義
    classDef mainPage fill:#e1f5fe,stroke:#01579b,stroke-width:2px
    classDef authPage fill:#fff3e0,stroke:#e65100,stroke-width:2px
    classDef serverPage fill:#fce4ec,stroke:#880e4f,stroke-width:2px
    classDef modalPage fill:#f3e5f5,stroke:#4a148c,stroke-width:2px
    classDef errorPage fill:#ffebee,stroke:#b71c1c,stroke-width:2px

    class HOME,PRODUCTS,CUSTOMERS mainPage
    class LOGIN_SPA,LOGOUT_SPA authPage
    class LOGIN_SERVER,REGISTER_SERVER serverPage
    class CUSTOMER_DETAIL modalPage
    class ERROR errorPage
```

## 遷移の説明

### メイン画面間の遷移

| 遷移元 | 遷移先 | 条件 | 説明 |
|--------|--------|------|------|
| ホーム画面 | 商品一覧画面 | なし | サイドメニューまたはナビゲーションから遷移 |
| ホーム画面 | 顧客一覧画面 | 認証済み | サイドメニューまたはナビゲーションから遷移 |
| 商品一覧画面 | ホーム画面 | なし | ナビゲーションから遷移 |
| 顧客一覧画面 | ホーム画面 | なし | ナビゲーションから遷移 |
| 顧客一覧画面 | 顧客詳細モーダル | なし | 顧客行をクリックして詳細表示 |

### 認証関連の遷移

| 遷移元 | 遷移先 | 条件 | 説明 |
|--------|--------|------|------|
| 任意の画面 | ログイン画面（SPA） | 未認証 | ログインボタンをクリックまたは認証が必要な画面へのアクセス |
| ログイン画面（SPA） | ログイン画面（サーバー） | なし | IdentityServerへリダイレクト |
| ログイン画面（サーバー） | 新規登録画面 | なし | 登録リンクをクリック |
| ログイン画面（サーバー） | 元の画面 | 認証成功 | returnUrlパラメータに基づく |
| 任意の画面 | ログアウト画面 | 認証済み | ログアウトボタンをクリック |
| ログアウト画面 | ホーム画面 | なし | ログアウト完了後 |

## 画面アクセス制御

| 画面 | アクセス制御 | 備考 |
|------|--------------|------|
| ホーム画面 | 公開 | 認証不要 |
| 商品一覧画面 | 公開 | 認証不要 |
| 顧客一覧画面 | 認証必須 | AuthorizeGuardで保護 |
| 顧客詳細モーダル | 認証必須 | 親画面（顧客一覧）が認証必須 |
| ログイン画面 | 公開 | 認証不要 |
| 新規登録画面 | 公開 | 認証不要 |
| エラー画面 | 公開 | 認証不要 |

## 補足

- 実線矢印（`-->`）: ユーザー操作による通常の遷移
- 点線矢印（`-.->`)：システム自動遷移（リダイレクト、エラー発生時など）
- 顧客一覧画面へのアクセスは`AuthorizeGuard`により保護されており、未認証の場合はログイン画面へリダイレクトされる
- サーバーサイドの認証画面（Login.cshtml、Register.cshtml）はASP.NET Core Identityが提供するRazor Pagesで実装されている
