---
generated_at: 2026-01-07 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠があります
  2. 特に優先レビューが必要な項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `Src/WebUI/ClientApp/src/app/home/home.component.ts`
- E-04: `Src/WebUI/ClientApp/src/app/products/products.component.ts`
- E-05: `Src/WebUI/ClientApp/src/app/products/products.component.html`
- E-06: `Src/WebUI/ClientApp/src/app/customers/customers.component.ts`
- E-07: `Src/WebUI/ClientApp/src/app/customers/customers.component.html`
- E-08: `Src/WebUI/ClientApp/src/app/customer-detail/customer-detail.component.ts`
- E-09: `Src/WebUI/ClientApp/src/api-authorization/login/login.component.ts`
- E-10: `Src/WebUI/ClientApp/src/api-authorization/logout/logout.component.ts`
- E-11: `Src/WebUI/Areas/Identity/Pages/Account/Login.cshtml.cs`
- E-12: `Src/WebUI/Areas/Identity/Pages/Account/Register.cshtml.cs`
- E-13: `Src/WebUI/Pages/Error.cshtml.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ホーム画面は静的コンテンツのみで機能連携なし | E-03 | ○ |
| C-02 | 商品一覧画面はProductsClient.getAll()で商品一覧取得 | E-04 | ○ |
| C-03 | 商品一覧画面はExportボタンで/api/products/downloadを呼び出し | E-05 | ○ |
| C-04 | 顧客一覧画面はCustomersClient.getAll()で顧客一覧取得 | E-06 | ○ |
| C-05 | 顧客一覧画面は行クリックでCustomersClient.get(id)を呼び出し | E-06, E-07 | ○ |
| C-06 | 顧客詳細モーダルは親画面から渡されたデータを表示 | E-08 | ○ |
| C-07 | ログイン画面はAuthorizeServiceでOIDC認証 | E-09 | ○ |
| C-08 | ログアウト画面はAuthorizeServiceでログアウト処理 | E-10 | ○ |
| C-09 | サーバーログイン画面はSignInManager.PasswordSignInAsync使用 | E-11 | ○ |
| C-10 | サーバーログイン画面は確認メール再送信機能あり | E-11 | ○ |
| C-11 | 新規登録画面はUserManager.CreateAsync使用 | E-12 | ○ |
| C-12 | 新規登録画面は登録後に確認メール送信 | E-12 | ○ |
| C-13 | エラー画面はCustomExceptionHandlerMiddlewareと連携 | E-13, E-02 | ○ |
| C-14 | 画面No・機能Noは画面一覧.csvと機能一覧.csvと整合 | E-01, E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に対して根拠が確認できました
- 特に不足情報はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての画面機能マッピングがソースコードで確認できています

## 6) レビュアーチェックリスト（最小）
- [ ] 各画面の「主機能」が画面の主目的と一致しているか確認
- [ ] 「遷移先機能」が画面遷移図と整合しているか確認
- [ ] 「補助機能」の呼び出し条件（ボタン押下等）が正確か確認
- [ ] 画面No・機能Noが画面一覧.csv・機能一覧.csvと一致しているか確認
