# 画面設計書 1-ホーム画面

## 概要

本ドキュメントは、Northwind Tradersアプリケーションのホーム画面（トップページ）の設計仕様を記載したものである。

### 本画面の処理概要

ホーム画面は、Northwind Tradersアプリケーションのランディングページとして機能する静的コンテンツ表示画面である。アプリケーションにアクセスした際に最初に表示される画面であり、会社紹介と主要機能へのナビゲーションを提供する。

**業務上の目的・背景**：本画面は、Northwind Tradersという架空の輸入食品会社のウェブアプリケーションにおいて、ユーザーに対してサービスの概要を伝え、各種業務機能（商品管理、顧客管理など）へのアクセスポイントを提供するために存在する。初めてアクセスするユーザーに対してアプリケーションの目的を明確に伝える役割を担う。

**画面へのアクセス方法**：ブラウザでアプリケーションのルートURL（/）にアクセスすることで表示される。また、ヘッダーやサイドメニューの「Home」リンクをクリックすることでも遷移可能。

**主要な操作・処理内容**：
1. 会社紹介テキストの閲覧
2. 「Learn more」ボタンをクリックして外部リンク（YouTube動画）へ遷移
3. ヘッダーナビゲーションを使用して他の画面（Products、Customers）へ遷移
4. ログイン/ログアウト操作（ヘッダーのログインメニューから）

**画面遷移**：
- 遷移元：ログアウト画面（ログアウト完了後）、ログイン画面（認証成功後）、任意の画面（ナビゲーションから）
- 遷移先：商品一覧画面、顧客一覧画面、ログイン画面、ログアウト画面

**権限による表示制御**：本画面は公開画面であり、認証不要でアクセス可能。ただし、ヘッダーのログインメニューは認証状態に応じて「Login」または「Logout」の表示が切り替わる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 静的コンテンツのみを表示。バックエンド機能との連携なし。 |

## 画面種別

トップページ / ランディングページ

## URL/ルーティング

| パス | 説明 |
|------|------|
| `/` | ホーム画面（ルートパス） |

## 入出力項目

本画面は静的コンテンツのみを表示するため、入出力項目は存在しない。

## 表示項目

| 項目名 | 項目種別 | 説明 |
|--------|----------|------|
| タイトル | テキスト（h1） | 「Northwind Traders」と表示 |
| 説明文 | テキスト（p） | 架空の輸入食品会社の説明文 |
| Learn moreボタン | リンクボタン | 外部YouTube動画へのリンク |
| セクション見出し | テキスト（h2） | 「Heading」（3つ） |
| セクション説明文 | テキスト（p） | 各セクションのダミーテキスト |
| View detailsボタン | リンクボタン | 各セクションの詳細リンク（#） |

## イベント仕様

### 1-Learn moreボタン押下

外部リンク（https://youtu.be/_lwCVE_XgqI）を新しいタブで開く。

### 2-View detailsボタン押下

現時点では「#」（ページ内アンカー）がリンク先として設定されており、機能未実装。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースへのアクセスを行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

本画面では、特定のメッセージ表示機能は実装されていない。

## 例外処理

本画面は静的コンテンツのみを表示するため、アプリケーションレベルの例外処理は発生しない。ただし、アプリケーション全体のエラーハンドリングにより、予期しないエラーが発生した場合はエラー画面へリダイレクトされる。

## 備考

- 本画面はBootstrapのJumbotronコンポーネントを使用したレスポンシブデザインを採用
- 3カラムのグリッドレイアウトにより、中型以上のデバイスでは横並び表示となる
- Angular SPAの一部として実装されており、サーバーサイドレンダリングにも対応

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面は静的コンテンツのみを表示するため、特別なデータ構造は使用しない。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | home.component.ts | `Src/WebUI/ClientApp/src/app/home/home.component.ts` | コンポーネントクラスの定義を確認。プロパティやメソッドがないシンプルな構造 |

**読解のコツ**: Angularコンポーネントの基本構造（@Componentデコレータ、templateUrl、styleUrls）を理解すること。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | app.routing.module.ts | `Src/WebUI/ClientApp/src/app/app.routing.module.ts` | ルートパス（''）がHomeComponentにマッピングされている点を確認 |

**主要処理フロー**:
1. **行10**: `{ path: '', component: HomeComponent, pathMatch: 'full' }` - ルートパスへのアクセス時にHomeComponentを表示

#### Step 3: テンプレート構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | home.component.html | `Src/WebUI/ClientApp/src/app/home/home.component.html` | HTML構造とBootstrapクラスの使用方法を確認 |

**主要処理フロー**:
- **行1-10**: Jumbotronセクション - タイトルと説明文、Learn moreボタン
- **行12-40**: 3カラムのグリッドレイアウト - 各セクションの見出しと説明

### プログラム呼び出し階層図

```
AppComponent
    │
    └─ RouterOutlet
           │
           └─ HomeComponent (path: '/')
                  │
                  └─ home.component.html (テンプレート表示)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ルートURL (/) ───▶ Angular Router ───▶ HomeComponent表示
                      │
                      └─▶ 静的HTMLレンダリング
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| home.component.ts | `Src/WebUI/ClientApp/src/app/home/home.component.ts` | ソース | ホーム画面コンポーネントクラス定義 |
| home.component.html | `Src/WebUI/ClientApp/src/app/home/home.component.html` | テンプレート | ホーム画面のHTMLテンプレート |
| home.component.css | `Src/WebUI/ClientApp/src/app/home/home.component.css` | スタイル | ホーム画面固有のスタイル定義 |
| app.routing.module.ts | `Src/WebUI/ClientApp/src/app/app.routing.module.ts` | ソース | ルーティング設定 |
| app.module.ts | `Src/WebUI/ClientApp/src/app/app.module.ts` | ソース | アプリケーションモジュール定義 |
