# 画面設計書 2-商品一覧画面

## 概要

本ドキュメントは、Northwind Tradersアプリケーションの商品一覧画面の設計仕様を記載したものである。

### 本画面の処理概要

商品一覧画面は、システムに登録されている全商品の一覧を表形式で表示する画面である。商品ID、商品名を一覧表示し、CSVエクスポート機能を提供する。バックエンドAPIから商品データを取得して動的に表示する。

**業務上の目的・背景**：本画面は、Northwind Tradersが取り扱う輸入食品の商品マスタを参照するために使用される。従業員や管理者が商品情報を一覧で確認し、必要に応じてCSV形式でデータをエクスポートすることで、在庫管理や発注業務、レポート作成などの業務を支援する。

**画面へのアクセス方法**：ヘッダーまたはサイドメニューの「Products」リンクをクリック、またはURL `/products` に直接アクセスすることで表示される。

**主要な操作・処理内容**：
1. 画面表示時に商品一覧APIを呼び出し、全商品データを取得
2. 商品一覧をテーブル形式で表示（商品ID、商品名）
3. Exportボタンをクリックして商品一覧をCSV形式でダウンロード
4. ナビゲーションを使用して他の画面へ遷移

**画面遷移**：
- 遷移元：ホーム画面、顧客一覧画面（ナビゲーションから）
- 遷移先：ホーム画面、顧客一覧画面、ログイン画面、ログアウト画面

**権限による表示制御**：本画面は公開画面であり、認証不要でアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | 商品一覧取得 | 主機能 | 画面初期表示時にProductsClient.getAll()を呼び出し、全商品の一覧を取得・表示する。 |
| 14 | 商品一覧ダウンロード | 補助機能 | Exportボタン押下時に/api/products/downloadエンドポイントを呼び出し、CSV形式で商品一覧をダウンロードする。 |

## 画面種別

一覧

## URL/ルーティング

| パス | 説明 |
|------|------|
| `/products` | 商品一覧画面 |

## 入出力項目

本画面には入力項目はなく、APIから取得したデータを出力として表示する。

## 表示項目

| 項目名 | 項目種別 | データ型 | 説明 |
|--------|----------|----------|------|
| 画面タイトル | テキスト（h1） | - | 「Products」と表示 |
| セクション見出し | テキスト（h2） | - | 「All Products」と表示 |
| Exportボタン | リンクボタン | - | CSVダウンロードリンク |
| Id | テキスト（テーブル列） | number | 商品ID（productId） |
| Name | テキスト（テーブル列） | string | 商品名（productName） |

## イベント仕様

### 1-画面初期表示

画面が読み込まれた際に、ProductsClient.getAll()メソッドを呼び出して全商品データを取得する。

**処理フロー**：
1. ProductsComponentのコンストラクタが実行される
2. ProductsClient.getAll()を呼び出し（GET /api/Products/GetAll）
3. レスポンス（ProductsListVm）をproductsListVmプロパティに格納
4. *ngForディレクティブにより商品一覧がテーブルに描画される

### 2-Exportボタン押下

CSVファイルのダウンロードを開始する。

**処理フロー**：
1. `/api/products/download` へのGETリクエストが発行される
2. サーバーからCSVファイルがレスポンスとして返却される
3. ブラウザの標準ダウンロード機能によりファイルが保存される

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータの参照のみを行い、更新操作は行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面初期表示 | Products | SELECT | 全商品データを取得 |
| Exportボタン押下 | Products | SELECT | CSV出力用に全商品データを取得 |

### テーブル別更新項目詳細

#### Products（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | productId | 全件取得 | 商品ID |
| SELECT | productName | 全件取得 | 商品名 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| エラー | コンソールにエラー出力 | API呼び出しエラー時 |

## 例外処理

| 例外状態 | 対処 |
|---------|------|
| API呼び出しエラー | console.error()でエラーをコンソールに出力。画面上はデータなし状態で表示 |
| サーバー接続エラー | ブラウザのネットワークエラーハンドリングに委ねる |

## 備考

- APIクライアント（ProductsClient）はNSwagによって自動生成されている
- 商品一覧の取得にはProductsListVmビューモデルが使用される
- 現在の実装では、商品IDと商品名のみが表示され、単価やカテゴリなどの詳細情報は表示されない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | northwind-traders-api.ts | `Src/WebUI/ClientApp/src/app/northwind-traders-api.ts` | ProductsListVm、ProductDtoクラスの定義を確認（行1846-1956） |

**読解のコツ**: NSwagで自動生成されたAPIクライアントコード。ProductsListVmはproducts配列とcreateEnabledフラグを持つ。ProductDtoは商品の詳細情報を持つが、画面ではproductIdとproductNameのみ使用。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | app.routing.module.ts | `Src/WebUI/ClientApp/src/app/app.routing.module.ts` | '/products'パスがProductsComponentにマッピングされている点を確認（行12） |

**主要処理フロー**:
1. **行12**: `{ path: 'products', component: ProductsComponent }` - /productsパスへのアクセス時にProductsComponentを表示

#### Step 3: コンポーネントロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | products.component.ts | `Src/WebUI/ClientApp/src/app/products/products.component.ts` | コンストラクタでAPIを呼び出してデータを取得する処理を確認 |

**主要処理フロー**:
- **行9**: `productsListVm: ProductsListVm = new ProductsListVm()` - 商品一覧データを保持するプロパティ
- **行11-14**: コンストラクタでProductsClient.getAll()を呼び出し、結果をproductsListVmに格納

#### Step 4: テンプレート構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | products.component.html | `Src/WebUI/ClientApp/src/app/products/products.component.html` | テーブル構造とExportボタンの実装を確認 |

**主要処理フロー**:
- **行5**: `<a href="/api/products/download" class="btn btn-sm btn-outline-secondary">Export</a>` - CSVダウンロードリンク
- **行21-24**: `*ngFor="let product of productsListVm.products"` - 商品一覧のループ表示

### プログラム呼び出し階層図

```
ProductsComponent
    │
    ├─ constructor()
    │      │
    │      └─ ProductsClient.getAll()
    │             │
    │             └─ HTTP GET /api/Products/GetAll
    │                    │
    │                    └─ ProductsListVm (レスポンス)
    │
    └─ products.component.html
           │
           ├─ Exportボタン → /api/products/download
           │
           └─ *ngFor → 商品テーブル描画
```

### データフロー図

```
[入力]               [処理]                    [出力]

/products URL ───▶ Angular Router ───▶ ProductsComponent生成
                                              │
                                              ▼
                   ProductsClient.getAll() ───▶ HTTP GET /api/Products/GetAll
                                              │
                                              ▼
                   ProductsListVm ───▶ productsListVm プロパティ
                                              │
                                              ▼
                   *ngFor ───▶ テーブル表示

Exportボタン ───▶ /api/products/download ───▶ CSVファイルダウンロード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| products.component.ts | `Src/WebUI/ClientApp/src/app/products/products.component.ts` | ソース | 商品一覧画面コンポーネントクラス定義 |
| products.component.html | `Src/WebUI/ClientApp/src/app/products/products.component.html` | テンプレート | 商品一覧画面のHTMLテンプレート |
| northwind-traders-api.ts | `Src/WebUI/ClientApp/src/app/northwind-traders-api.ts` | ソース | APIクライアント（ProductsClient、ProductsListVm、ProductDto） |
| app.routing.module.ts | `Src/WebUI/ClientApp/src/app/app.routing.module.ts` | ソース | ルーティング設定 |
| app.module.ts | `Src/WebUI/ClientApp/src/app/app.module.ts` | ソース | アプリケーションモジュール定義、ProductsClientのプロバイダー登録 |
