# 画面設計書 3-顧客一覧画面

## 概要

本ドキュメントは、Northwind Tradersアプリケーションの顧客一覧画面の設計仕様を記載したものである。

### 本画面の処理概要

顧客一覧画面は、システムに登録されている全顧客の一覧を表形式で表示する画面である。顧客ID、顧客名を一覧表示し、行クリックで顧客詳細モーダルを表示する機能を提供する。認証が必要な画面であり、未認証ユーザーはログイン画面にリダイレクトされる。

**業務上の目的・背景**：本画面は、Northwind Tradersの取引先である顧客情報を管理するために使用される。営業担当者や管理者が顧客情報を一覧で確認し、詳細情報を閲覧することで、顧客対応や取引管理などの業務を支援する。顧客情報は機密性が高いため、認証済みユーザーのみがアクセス可能となっている。

**画面へのアクセス方法**：ヘッダーまたはサイドメニューの「Customers」リンクをクリック、またはURL `/customers` に直接アクセスすることで表示される。ただし、認証済みである必要がある。

**主要な操作・処理内容**：
1. 画面表示時に顧客一覧APIを呼び出し、全顧客データを取得
2. 顧客一覧をテーブル形式で表示（顧客ID、顧客名）
3. テーブル行をクリックして顧客詳細モーダルを表示
4. ナビゲーションを使用して他の画面へ遷移

**画面遷移**：
- 遷移元：ホーム画面、商品一覧画面（ナビゲーションから）
- 遷移先：顧客詳細モーダル（行クリック）、ホーム画面、商品一覧画面、ログイン画面（未認証時リダイレクト）、ログアウト画面

**権限による表示制御**：本画面は認証必須画面であり、AuthorizeGuardによって保護されている。未認証ユーザーがアクセスした場合、ログイン画面へリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | 顧客一覧取得 | 主機能 | 画面初期表示時にCustomersClient.getAll()を呼び出し、全顧客の一覧を取得・表示する。 |
| 5 | 顧客詳細取得 | 遷移先機能 | 顧客行クリック時にCustomersClient.get(id)を呼び出し、顧客詳細モーダルに表示するデータを取得する。 |

## 画面種別

一覧

## URL/ルーティング

| パス | 説明 |
|------|------|
| `/customers` | 顧客一覧画面（認証必須） |

## 入出力項目

本画面には入力項目はなく、APIから取得したデータを出力として表示する。

## 表示項目

| 項目名 | 項目種別 | データ型 | 説明 |
|--------|----------|----------|------|
| 画面タイトル | テキスト（h1） | - | 「Customers」と表示 |
| セクション見出し | テキスト（h2） | - | 「All Customers」と表示 |
| Shareボタン | ボタン | - | 共有機能（未実装） |
| Exportボタン | ボタン | - | エクスポート機能（未実装） |
| # | テキスト（テーブル列） | string | 顧客ID |
| Name | テキスト（テーブル列） | string | 顧客名 |

## イベント仕様

### 1-画面初期表示

画面が読み込まれた際に、CustomersClient.getAll()メソッドを呼び出して全顧客データを取得する。

**処理フロー**：
1. AuthorizeGuardが認証状態をチェック
2. 未認証の場合、ログイン画面へリダイレクト
3. 認証済みの場合、CustomersComponentのコンストラクタが実行される
4. CustomersClient.getAll()を呼び出し（GET /api/Customers/GetAll）
5. レスポンス（CustomersListVm）をvmプロパティに格納
6. *ngForディレクティブにより顧客一覧がテーブルに描画される

### 2-顧客行クリック

選択した顧客の詳細情報をモーダルダイアログで表示する。

**処理フロー**：
1. テーブル行のクリックイベントでcustomerDetail(id)メソッドが呼び出される
2. CustomersClient.get(id)を呼び出し（GET /api/Customers/Get/{id}）
3. レスポンス（CustomerDetailVm）を取得
4. BsModalServiceを使用してCustomerDetailComponentをモーダルとして表示
5. 取得した顧客詳細データをモーダルに渡す（initialState）

### 3-Shareボタン押下

現時点では機能未実装。ボタンのみ表示。

### 4-Exportボタン押下

現時点では機能未実装。ボタンのみ表示。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータの参照のみを行い、更新操作は行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面初期表示 | Customers | SELECT | 全顧客データを取得 |
| 顧客行クリック | Customers | SELECT | 指定IDの顧客詳細データを取得 |

### テーブル別更新項目詳細

#### Customers（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT（一覧） | id | 全件取得 | 顧客ID |
| SELECT（一覧） | name | 全件取得 | 顧客名（CompanyName） |
| SELECT（詳細） | 全項目 | WHERE id = {指定ID} | 顧客詳細情報 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| エラー | コンソールにエラー出力 | API呼び出しエラー時 |

## 例外処理

| 例外状態 | 対処 |
|---------|------|
| 未認証アクセス | AuthorizeGuardによりログイン画面へリダイレクト |
| API呼び出しエラー | console.error()でエラーをコンソールに出力。画面上はデータなし状態で表示 |
| 顧客詳細取得エラー | console.error()でエラーをコンソールに出力。モーダルは表示されない |

## 備考

- APIクライアント（CustomersClient）はNSwagによって自動生成されている
- 顧客一覧の取得にはCustomersListVmビューモデルが使用される
- モーダル表示にはngx-bootstrapのBsModalServiceを使用
- テーブル行にはcursor: pointerスタイルが適用されており、クリック可能であることを示す

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | northwind-traders-api.ts | `Src/WebUI/ClientApp/src/app/northwind-traders-api.ts` | CustomersListVm、CustomerLookupDto、CustomerDetailVmクラスの定義を確認（行1230-1388） |

**読解のコツ**: CustomersListVmはcustomers配列（CustomerLookupDto[]）を持つ。CustomerLookupDtoはidとnameのみ。CustomerDetailVmは住所や電話番号などの詳細情報を含む。

#### Step 2: 認証ガードを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | authorize.guard.ts | `Src/WebUI/ClientApp/src/api-authorization/authorize.guard.ts` | AuthorizeGuardの実装を確認。canActivateメソッドで認証状態をチェック |

**主要処理フロー**:
- **行14-18**: canActivateメソッドでAuthorizeService.isAuthenticated()をチェック
- **行21-28**: 未認証の場合、ログイン画面へナビゲート

#### Step 3: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | app.routing.module.ts | `Src/WebUI/ClientApp/src/app/app.routing.module.ts` | '/customers'パスがCustomersComponentにマッピングされ、AuthorizeGuardが適用されている点を確認（行11） |

**主要処理フロー**:
1. **行11**: `{ path: 'customers', component: CustomersComponent, canActivate: [AuthorizeGuard] }` - 認証ガード付きルート

#### Step 4: コンポーネントロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | customers.component.ts | `Src/WebUI/ClientApp/src/app/customers/customers.component.ts` | コンストラクタでの一覧取得と、customerDetailメソッドでのモーダル表示を確認 |

**主要処理フロー**:
- **行12**: `vm: CustomersListVm = new CustomersListVm()` - 顧客一覧データを保持するプロパティ
- **行15-18**: コンストラクタでCustomersClient.getAll()を呼び出し
- **行21-27**: customerDetailメソッドで詳細取得とモーダル表示

#### Step 5: テンプレート構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | customers.component.html | `Src/WebUI/ClientApp/src/app/customers/customers.component.html` | テーブル構造と行クリックイベントの実装を確認 |

**主要処理フロー**:
- **行22**: `(click)="customerDetail(customer.id)"` - 行クリック時のイベントバインディング
- **行22**: `style="cursor: pointer;"` - クリック可能を示すカーソルスタイル

### プログラム呼び出し階層図

```
CustomersComponent
    │
    ├─ AuthorizeGuard.canActivate()
    │      │
    │      └─ AuthorizeService.isAuthenticated()
    │             │
    │             └─ [未認証] → ログイン画面へリダイレクト
    │
    ├─ constructor()
    │      │
    │      └─ CustomersClient.getAll()
    │             │
    │             └─ HTTP GET /api/Customers/GetAll
    │                    │
    │                    └─ CustomersListVm (レスポンス)
    │
    └─ customerDetail(id)
           │
           └─ CustomersClient.get(id)
                  │
                  └─ HTTP GET /api/Customers/Get/{id}
                         │
                         └─ CustomerDetailVm (レスポンス)
                                │
                                └─ BsModalService.show(CustomerDetailComponent)
```

### データフロー図

```
[入力]               [処理]                    [出力]

/customers URL ───▶ AuthorizeGuard ───▶ [未認証] → ログイン画面
                          │
                          ▼ [認証済み]
                    CustomersComponent生成
                          │
                          ▼
                    CustomersClient.getAll() ───▶ HTTP GET /api/Customers/GetAll
                          │
                          ▼
                    CustomersListVm ───▶ vm プロパティ
                          │
                          ▼
                    *ngFor ───▶ テーブル表示

行クリック ───▶ customerDetail(id) ───▶ CustomersClient.get(id)
                                              │
                                              ▼
                                       CustomerDetailVm
                                              │
                                              ▼
                                       モーダル表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| customers.component.ts | `Src/WebUI/ClientApp/src/app/customers/customers.component.ts` | ソース | 顧客一覧画面コンポーネントクラス定義 |
| customers.component.html | `Src/WebUI/ClientApp/src/app/customers/customers.component.html` | テンプレート | 顧客一覧画面のHTMLテンプレート |
| customer-detail.component.ts | `Src/WebUI/ClientApp/src/app/customer-detail/customer-detail.component.ts` | ソース | 顧客詳細モーダルコンポーネント |
| customer-detail.component.html | `Src/WebUI/ClientApp/src/app/customer-detail/customer-detail.component.html` | テンプレート | 顧客詳細モーダルのHTMLテンプレート |
| authorize.guard.ts | `Src/WebUI/ClientApp/src/api-authorization/authorize.guard.ts` | ソース | 認証ガード |
| northwind-traders-api.ts | `Src/WebUI/ClientApp/src/app/northwind-traders-api.ts` | ソース | APIクライアント（CustomersClient、CustomersListVm、CustomerDetailVm） |
| app.routing.module.ts | `Src/WebUI/ClientApp/src/app/app.routing.module.ts` | ソース | ルーティング設定（認証ガード適用） |
| app.module.ts | `Src/WebUI/ClientApp/src/app/app.module.ts` | ソース | アプリケーションモジュール定義、CustomersClientのプロバイダー登録 |
