# 画面設計書 4-顧客詳細モーダル

## 概要

本ドキュメントは、Northwind Tradersアプリケーションの顧客詳細モーダルの設計仕様を記載したものである。

### 本画面の処理概要

顧客詳細モーダルは、顧客一覧画面から起動されるモーダルダイアログであり、選択した顧客の詳細情報を表示する。顧客の住所、連絡先、担当者情報などの詳細データを一覧形式で表示する。

**業務上の目的・背景**：本モーダルは、顧客一覧画面で選択した顧客の詳細情報を迅速に確認するために使用される。営業担当者が顧客への連絡先情報を確認したり、配送先住所を確認したりする際に利用される。一覧画面から画面遷移せずにモーダルとして詳細を確認できるため、業務効率が向上する。

**画面へのアクセス方法**：顧客一覧画面のテーブル行をクリックすることで表示される。単独でURLアクセスすることはできない。

**主要な操作・処理内容**：
1. 顧客詳細情報の閲覧（住所、連絡先、担当者情報など）
2. Closeボタンまたはxボタンをクリックしてモーダルを閉じる

**画面遷移**：
- 遷移元：顧客一覧画面（行クリック）
- 遷移先：顧客一覧画面（モーダルクローズ）

**権限による表示制御**：本モーダルは顧客一覧画面から起動されるため、親画面の認証要件（認証必須）が継承される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 顧客詳細取得 | 主機能 | 顧客一覧画面から渡された顧客詳細情報を表示する。データ取得は親画面で実行済み。 |

## 画面種別

詳細（モーダル）

## URL/ルーティング

本モーダルは独立したURLを持たず、顧客一覧画面から動的に表示される。

## 入出力項目

### 入力

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| customer | CustomerDetailVm | 親画面から渡される顧客詳細情報オブジェクト |

### 出力

本モーダルは顧客詳細情報を表示するのみで、出力データはない。

## 表示項目

| 項目名 | 項目種別 | データ型 | 説明 |
|--------|----------|----------|------|
| モーダルタイトル | テキスト（h4） | string | 「{顧客ID} Detail」と表示 |
| 閉じるボタン（x） | ボタン | - | モーダル右上のxボタン |
| 詳細項目ラベル | テキスト（b） | string | 各項目名（キャメルケースからテキストに変換） |
| 詳細項目値 | テキスト | string | 各項目の値 |
| Closeボタン | ボタン | - | モーダルフッターの閉じるボタン |

### 動的に表示される詳細項目

CustomerDetailVmの以下のプロパティが表示される（idを除く）：

| プロパティ名 | 表示ラベル | 説明 |
|-------------|-----------|------|
| address | Address | 住所 |
| city | City | 市区町村 |
| companyName | Company Name | 会社名 |
| contactName | Contact Name | 担当者名 |
| contactTitle | Contact Title | 担当者役職 |
| country | Country | 国 |
| fax | Fax | FAX番号 |
| phone | Phone | 電話番号 |
| postalCode | Postal Code | 郵便番号 |
| region | Region | 地域 |

## イベント仕様

### 1-モーダル表示

モーダルが表示された際の初期化処理。

**処理フロー**：
1. ngOnInit()が呼び出される
2. customerオブジェクトのキーを取得し、'id'を除外してdetailKeysに格納
3. *ngForディレクティブにより各詳細項目が描画される
4. camelCaseToTextパイプにより項目名がキャメルケースからスペース区切りテキストに変換される

### 2-閉じるボタン（x）クリック

モーダル右上のxボタンをクリックしてモーダルを閉じる。

**処理フロー**：
1. closeModal()メソッドが呼び出される
2. BsModalRef.hide()によりモーダルが非表示になる
3. 顧客一覧画面に戻る

### 3-Closeボタンクリック

モーダルフッターのCloseボタンをクリックしてモーダルを閉じる。

**処理フロー**：
1. closeModal()メソッドが呼び出される
2. BsModalRef.hide()によりモーダルが非表示になる
3. 顧客一覧画面に戻る

## データベース更新仕様

### 操作別データベース影響一覧

本モーダルはデータベースへの直接アクセスを行わない。データは親画面（顧客一覧画面）から渡される。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし（データは親画面から受け渡し） |

## メッセージ仕様

本モーダルでは、特定のメッセージ表示機能は実装されていない。

## 例外処理

| 例外状態 | 対処 |
|---------|------|
| customerオブジェクトがnull | 詳細項目が表示されない（エラーにはならない） |
| 項目値がnull/undefined | *ngIfにより該当項目行が非表示になる |

## 備考

- ChangeDetectionStrategy.OnPushを使用しており、パフォーマンスが最適化されている
- camelCaseToTextパイプを使用してプロパティ名を人間が読みやすい形式に変換
- ngx-bootstrapのBsModalRefを使用してモーダルの制御を行う
- 動的にプロパティを列挙する設計のため、CustomerDetailVmに新しいプロパティが追加された場合も自動的に表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | northwind-traders-api.ts | `Src/WebUI/ClientApp/src/app/northwind-traders-api.ts` | CustomerDetailVmクラスの定義を確認（行1314-1388） |

**読解のコツ**: CustomerDetailVmには顧客の詳細情報（住所、連絡先など）が含まれる。すべてのプロパティはオプショナル（undefined可）。

#### Step 2: 親画面からの呼び出しを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | customers.component.ts | `Src/WebUI/ClientApp/src/app/customers/customers.component.ts` | customerDetailメソッドでモーダルを表示する処理を確認（行21-27） |

**主要処理フロー**:
- **行22**: CustomersClient.get(id)で詳細データを取得
- **行23-25**: initialStateとしてcustomerオブジェクトをモーダルに渡す
- **行26**: BsModalService.show()でモーダルを表示

#### Step 3: コンポーネントロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | customer-detail.component.ts | `Src/WebUI/ClientApp/src/app/customer-detail/customer-detail.component.ts` | ngOnInitでプロパティキーを抽出し、closeModalでモーダルを閉じる |

**主要処理フロー**:
- **行11**: `customer: CustomerDetailVm` - 親画面から渡される顧客詳細データ
- **行12**: `detailKeys: string[]` - 表示するプロパティ名の配列
- **行16-19**: ngOnInit()でcustomerオブジェクトのキーを取得し、'id'を除外
- **行22-24**: closeModal()でBsModalRef.hide()を呼び出してモーダルを閉じる

#### Step 4: テンプレート構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | customer-detail.component.html | `Src/WebUI/ClientApp/src/app/customer-detail/customer-detail.component.html` | モーダル構造と動的項目表示を確認 |

**主要処理フロー**:
- **行2**: モーダルタイトルに顧客IDを表示
- **行3**: xボタンでcloseModal()を呼び出し
- **行8-14**: detailKeysをループして各詳細項目を表示
- **行10**: `*ngIf="customer[detailKey]"`で値がある項目のみ表示
- **行11**: `camelCaseToText`パイプでラベルを変換
- **行18**: CloseボタンでcloseModal()を呼び出し

#### Step 5: パイプを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | camel-case-to-text.ts | `Src/WebUI/ClientApp/src/pipes/camel-case-to-text.ts` | キャメルケースをスペース区切りテキストに変換するパイプ |

### プログラム呼び出し階層図

```
CustomersComponent.customerDetail(id)
    │
    └─ CustomersClient.get(id)
           │
           └─ HTTP GET /api/Customers/Get/{id}
                  │
                  └─ CustomerDetailVm (レスポンス)
                         │
                         └─ BsModalService.show(CustomerDetailComponent, {initialState})
                                │
                                └─ CustomerDetailComponent
                                       │
                                       ├─ ngOnInit()
                                       │      └─ Object.keys(customer).filter()
                                       │
                                       └─ customer-detail.component.html
                                              │
                                              ├─ *ngFor="let detailKey of detailKeys"
                                              │      └─ camelCaseToText パイプ
                                              │
                                              └─ closeModal()
                                                     └─ BsModalRef.hide()
```

### データフロー図

```
[入力]               [処理]                    [出力]

顧客一覧画面 ───▶ customerDetail(id) ───▶ API呼び出し
   行クリック                                    │
                                                ▼
                                         CustomerDetailVm
                                                │
                                                ▼
                                    BsModalService.show()
                                                │
                                                ▼
                                    CustomerDetailComponent
                                                │
                                    ngOnInit() ───▶ detailKeys抽出
                                                │
                                                ▼
                                    *ngFor ───▶ モーダル表示
                                                │
                                    closeModal() ───▶ モーダル非表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| customer-detail.component.ts | `Src/WebUI/ClientApp/src/app/customer-detail/customer-detail.component.ts` | ソース | 顧客詳細モーダルコンポーネントクラス定義 |
| customer-detail.component.html | `Src/WebUI/ClientApp/src/app/customer-detail/customer-detail.component.html` | テンプレート | 顧客詳細モーダルのHTMLテンプレート |
| camel-case-to-text.ts | `Src/WebUI/ClientApp/src/pipes/camel-case-to-text.ts` | ソース | キャメルケース変換パイプ |
| customers.component.ts | `Src/WebUI/ClientApp/src/app/customers/customers.component.ts` | ソース | 親画面（顧客一覧）- モーダル呼び出し元 |
| northwind-traders-api.ts | `Src/WebUI/ClientApp/src/app/northwind-traders-api.ts` | ソース | APIクライアント（CustomerDetailVm） |
| app.module.ts | `Src/WebUI/ClientApp/src/app/app.module.ts` | ソース | アプリケーションモジュール定義、entryComponentsへの登録 |
