# 画面設計書 5-ログイン画面

## 概要

本ドキュメントは、Northwind TradersアプリケーションのAngular SPAにおけるログイン画面の設計仕様を記載したものである。

### 本画面の処理概要

ログイン画面は、AngularのSPA側でユーザーのログイン処理を制御するコンポーネントである。AuthorizeServiceを通じてIdentityServerと連携し、OAuth2/OIDC認証フローによるログイン処理を行う。認証状態に応じてサイレント認証、ポップアップ認証、リダイレクト認証の3つの方式を段階的に試行する。

**業務上の目的・背景**：本画面は、Northwind Tradersアプリケーションのセキュリティを確保するための認証機能を提供する。認証が必要な画面（顧客一覧など）にアクセスする際に、ユーザーを適切に認証することで、機密情報へのアクセス制御を実現する。

**画面へのアクセス方法**：
- ヘッダーのログインメニューから「Login」をクリック
- 認証が必要な画面（/customers）に未認証状態でアクセスした場合の自動リダイレクト
- URL `/authentication/login` に直接アクセス

**主要な操作・処理内容**：
1. ログインアクション（login）: サイレント認証を試行し、失敗した場合はIdentityServerへリダイレクト
2. ログインコールバック（login-callback）: IdentityServerからの認証レスポンスを処理
3. ログイン失敗（login-failed）: エラーメッセージを表示
4. プロフィール（profile）: IdentityServerのプロフィール管理画面へリダイレクト
5. 登録（register）: IdentityServerの新規登録画面へリダイレクト

**画面遷移**：
- 遷移元：任意の画面（ログインボタン、未認証時のリダイレクト）
- 遷移先：IdentityServerログイン画面（サーバー）、元の画面（認証成功後）、新規登録画面

**権限による表示制御**：本画面は公開画面であり、認証不要でアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | ログイン | 主機能 | AuthorizeServiceを通じてIdentityServerと連携し、OAuth2/OIDC認証フローによるログイン処理を行う。 |

## 画面種別

認証

## URL/ルーティング

| パス | 説明 |
|------|------|
| `/authentication/login` | ログイン処理開始 |
| `/authentication/login-callback` | IdentityServerからのコールバック処理 |
| `/authentication/login-failed` | ログイン失敗時のエラー表示 |
| `/authentication/profile` | プロフィール管理へのリダイレクト |
| `/authentication/register` | 新規登録へのリダイレクト |

## 入出力項目

### 入力（クエリパラメータ）

| パラメータ名 | データ型 | 説明 |
|-------------|----------|------|
| returnUrl | string | 認証成功後のリダイレクト先URL |
| message | string | エラーメッセージ（login-failed時） |

### 出力

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| message | Observable\<string\> | 画面に表示するメッセージ（非同期） |

## 表示項目

| 項目名 | 項目種別 | 説明 |
|--------|----------|------|
| メッセージ | テキスト（p） | 処理状態やエラーメッセージを表示（async パイプ使用） |

## イベント仕様

### 1-ログイン処理（login）

ユーザーをIdentityServerで認証する処理。

**処理フロー**：
1. ngOnInit()でURLパスからアクションを判定
2. login()メソッドを呼び出し
3. AuthorizeService.signIn()を実行
4. サイレント認証を試行
5. 失敗した場合、ポップアップ認証を試行（デフォルトで無効）
6. 失敗した場合、IdentityServerへリダイレクト
7. 認証成功の場合、returnUrlへナビゲート
8. 認証失敗の場合、login-failed画面へナビゲート

### 2-ログインコールバック処理（login-callback）

IdentityServerからの認証レスポンスを処理する。

**処理フロー**：
1. ngOnInit()でURLパスからアクションを判定
2. processLoginCallback()メソッドを呼び出し
3. AuthorizeService.completeSignIn()を実行
4. 認証成功の場合、stateに保存されたreturnUrlへナビゲート
5. 認証失敗の場合、エラーメッセージを表示

### 3-ログイン失敗処理（login-failed）

エラーメッセージを表示する。

**処理フロー**：
1. ngOnInit()でURLパスからアクションを判定
2. クエリパラメータからmessageを取得
3. messageをBehaviorSubjectに設定して画面に表示

### 4-プロフィールへのリダイレクト（profile）

IdentityServerのプロフィール管理画面へリダイレクトする。

**処理フロー**：
1. ngOnInit()でURLパスからアクションを判定
2. redirectToApiAuthorizationPath()を呼び出し
3. /Identity/Account/Manage へリダイレクト

### 5-新規登録へのリダイレクト（register）

IdentityServerの新規登録画面へリダイレクトする。

**処理フロー**：
1. ngOnInit()でURLパスからアクションを判定
2. redirectToRegister()を呼び出し
3. /Identity/Account/Register へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

本画面はフロントエンドのみで動作し、直接データベースへのアクセスは行わない。認証処理はIdentityServerを通じて行われる。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 直接のデータベース操作なし（IdentityServer経由） |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| エラー | (クエリパラメータから取得) | login-failed時 |
| エラー | 'The user closed the window.' | ポップアップが閉じられた時 |
| エラー | 'Invalid return url...' | 不正なreturnURL時 |
| 情報 | コンソールにログ出力 | 各認証方式の失敗時 |

## 例外処理

| 例外状態 | 対処 |
|---------|------|
| サイレント認証失敗 | ポップアップまたはリダイレクト認証へフォールバック |
| ポップアップ認証失敗 | リダイレクト認証へフォールバック |
| リダイレクト認証失敗 | login-failed画面へナビゲート |
| 不正なreturnUrl | エラーをスロー（オープンリダイレクト防止） |
| 不正なアクション | エラーをスロー |

## 備考

- oidc-clientライブラリを使用してOIDC認証を実装
- ポップアップ認証はデフォルトで無効（Edge対応のため）
- BehaviorSubjectを使用して非同期メッセージを管理
- returnUrlのバリデーションによりオープンリダイレクト攻撃を防止

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 定数と設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | api-authorization.constants.ts | `Src/WebUI/ClientApp/src/api-authorization/api-authorization.constants.ts` | LoginActions、ApplicationPathsの定義を確認 |

**読解のコツ**: LoginActionsにはlogin、login-callback、login-failed、profile、registerの5つのアクションが定義されている。ApplicationPathsでURLパスが構成される。

#### Step 2: ルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | api-authorization.module.ts | `Src/WebUI/ClientApp/src/api-authorization/api-authorization.module.ts` | LoginComponentが複数のパスにマッピングされている点を確認（行16-20） |

**主要処理フロー**:
- **行16**: Register → LoginComponent
- **行17**: Profile → LoginComponent
- **行18**: Login → LoginComponent
- **行19**: LoginFailed → LoginComponent
- **行20**: LoginCallback → LoginComponent

#### Step 3: コンポーネントロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | login.component.ts | `Src/WebUI/ClientApp/src/api-authorization/login/login.component.ts` | ngOnInitでアクションを判定し、各処理を実行 |

**主要処理フロー**:
- **行24-46**: ngOnInit()でURLパスからアクションを判定してswitch文で分岐
- **行49-71**: login()メソッドでサイレント→ポップアップ→リダイレクト認証を試行
- **行73-87**: processLoginCallback()でIdentityServerからのレスポンスを処理
- **行106-119**: returnUrlのバリデーション（オープンリダイレクト防止）

#### Step 4: 認証サービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | authorize.service.ts | `Src/WebUI/ClientApp/src/api-authorization/authorize.service.ts` | signIn、completeSignInメソッドの実装を確認 |

**主要処理フロー**:
- **行85-122**: signIn()メソッド - サイレント→ポップアップ→リダイレクト認証の順で試行
- **行131-155**: completeSignIn()メソッド - 認証コールバックの処理
- **行228-247**: ensureUserManagerInitialized() - OIDCクライアントの初期化

### プログラム呼び出し階層図

```
LoginComponent.ngOnInit()
    │
    ├─ [login] login(returnUrl)
    │      │
    │      └─ AuthorizeService.signIn(state)
    │             │
    │             ├─ signinSilent() [試行1]
    │             │
    │             ├─ signinPopup() [試行2: 無効]
    │             │
    │             └─ createSigninRequest() [試行3]
    │                    │
    │                    └─ リダイレクト → IdentityServer
    │
    ├─ [login-callback] processLoginCallback()
    │      │
    │      └─ AuthorizeService.completeSignIn(url)
    │             │
    │             └─ signinRedirectCallback()
    │                    │
    │                    └─ navigateToReturnUrl()
    │
    ├─ [login-failed] message.next(message)
    │
    ├─ [profile] redirectToApiAuthorizationPath()
    │      │
    │      └─ window.location.replace(/Identity/Account/Manage)
    │
    └─ [register] redirectToRegister()
           │
           └─ window.location.replace(/Identity/Account/Register)
```

### データフロー図

```
[入力]               [処理]                    [出力]

/authentication/login
    ↓
LoginComponent.ngOnInit()
    ↓
login(returnUrl)
    ↓
AuthorizeService.signIn()
    ↓
[サイレント認証失敗]
    ↓
[ポップアップ認証失敗/無効]
    ↓
createSigninRequest()
    ↓
window.location.replace() ───▶ IdentityServer ログイン画面

IdentityServer認証完了
    ↓
/authentication/login-callback
    ↓
processLoginCallback()
    ↓
completeSignIn(url)
    ↓
navigateToReturnUrl() ───▶ 元の画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| login.component.ts | `Src/WebUI/ClientApp/src/api-authorization/login/login.component.ts` | ソース | ログイン画面コンポーネント |
| login.component.html | `Src/WebUI/ClientApp/src/api-authorization/login/login.component.html` | テンプレート | ログイン画面のHTMLテンプレート（メッセージ表示のみ） |
| authorize.service.ts | `Src/WebUI/ClientApp/src/api-authorization/authorize.service.ts` | ソース | 認証サービス（OIDC処理） |
| api-authorization.constants.ts | `Src/WebUI/ClientApp/src/api-authorization/api-authorization.constants.ts` | ソース | 認証関連の定数定義 |
| api-authorization.module.ts | `Src/WebUI/ClientApp/src/api-authorization/api-authorization.module.ts` | ソース | 認証モジュール（ルーティング設定） |
| authorize.guard.ts | `Src/WebUI/ClientApp/src/api-authorization/authorize.guard.ts` | ソース | 認証ガード（ログインへのリダイレクト） |
