# 画面設計書 6-ログアウト画面

## 概要

本ドキュメントは、Northwind TradersアプリケーションのAngular SPAにおけるログアウト画面の設計仕様を記載したものである。

### 本画面の処理概要

ログアウト画面は、AngularのSPA側でユーザーのログアウト処理を制御するコンポーネントである。AuthorizeServiceを通じてログアウト処理を実行し、セッションを終了する。ログアウト完了後はメッセージを表示し、ホーム画面へのリダイレクトを行う。

**業務上の目的・背景**：本画面は、認証済みユーザーが安全にセッションを終了するための機能を提供する。複数人で共有する端末を使用する場合や、業務終了時に確実にログアウトすることで、セキュリティリスクを軽減する。

**画面へのアクセス方法**：ヘッダーのログインメニューから「Logout」をクリック。ページ内からの操作によってのみ起動され、通常のリンクからのアクセスは拒否される（セキュリティ対策）。

**主要な操作・処理内容**：
1. ログアウト処理（logout）: 認証状態を確認し、IdentityServerと連携してログアウト処理を実行
2. ログアウトコールバック（logout-callback）: IdentityServerからのログアウトレスポンスを処理
3. ログアウト完了（logged-out）: ログアウト完了メッセージを表示

**画面遷移**：
- 遷移元：任意の認証済み画面（ログアウトボタン）
- 遷移先：ホーム画面（ログアウト完了後）

**権限による表示制御**：本画面は認証済みユーザーが使用することを前提としているが、アクセス自体は制限されていない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | ログイン | 主機能 | AuthorizeServiceを通じてログアウト処理を実行し、セッションを終了する。 |

## 画面種別

認証

## URL/ルーティング

| パス | 説明 |
|------|------|
| `/authentication/logout` | ログアウト処理開始 |
| `/authentication/logout-callback` | IdentityServerからのコールバック処理 |
| `/authentication/logged-out` | ログアウト完了メッセージ表示 |

## 入出力項目

### 入力（ナビゲーション状態）

| パラメータ名 | データ型 | 説明 |
|-------------|----------|------|
| window.history.state.local | boolean | ページ内操作からのログアウトかどうか |
| returnUrl | string | ログアウト後のリダイレクト先URL |

### 出力

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| message | Observable\<string\> | 画面に表示するメッセージ（非同期） |

## 表示項目

| 項目名 | 項目種別 | 説明 |
|--------|----------|------|
| メッセージ | テキスト（p） | 処理状態やログアウト完了メッセージを表示（async パイプ使用） |

## イベント仕様

### 1-ログアウト処理（logout）

ユーザーのセッションを終了する処理。

**処理フロー**：
1. ngOnInit()でURLパスからアクションを判定
2. window.history.state.localをチェック
3. ページ内操作からのログアウトでない場合、エラーメッセージを表示して終了（セキュリティ対策）
4. logout()メソッドを呼び出し
5. AuthorizeService.isAuthenticated()で認証状態を確認
6. 認証済みの場合、AuthorizeService.signOut()を実行
7. ポップアップでのサインアウトを試行
8. 失敗した場合、IdentityServerへリダイレクト
9. 認証済みでない場合、成功メッセージを表示

### 2-ログアウトコールバック処理（logout-callback）

IdentityServerからのログアウトレスポンスを処理する。

**処理フロー**：
1. ngOnInit()でURLパスからアクションを判定
2. processLogoutCallback()メソッドを呼び出し
3. AuthorizeService.completeSignOut()を実行
4. 成功の場合、stateに保存されたreturnUrlへナビゲート
5. 失敗の場合、エラーメッセージを表示

### 3-ログアウト完了表示（logged-out）

ログアウト完了メッセージを表示する。

**処理フロー**：
1. ngOnInit()でURLパスからアクションを判定
2. 'You successfully logged out!'メッセージをBehaviorSubjectに設定

## データベース更新仕様

### 操作別データベース影響一覧

本画面はフロントエンドのみで動作し、直接データベースへのアクセスは行わない。ログアウト処理はIdentityServerを通じて行われる。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 直接のデータベース操作なし（IdentityServer経由） |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| 成功 | 'You successfully logged out!' | ログアウト成功時 |
| 警告 | 'The logout was not initiated from within the page.' | 外部リンクからのアクセス時 |
| エラー | (AuthorizeServiceから取得) | ログアウト処理失敗時 |

## 例外処理

| 例外状態 | 対処 |
|---------|------|
| 外部リンクからのアクセス | 警告メッセージを表示してログアウト処理を中止 |
| ポップアップサインアウト失敗 | リダイレクトサインアウトへフォールバック |
| リダイレクトサインアウト失敗 | エラーメッセージを表示 |
| 不正なreturnUrl | エラーをスロー（オープンリダイレクト防止） |
| 不正なアクション | エラーをスロー |

## 備考

- ページ内操作からのログアウトのみを許可するセキュリティ対策を実装
- window.history.state.localフラグにより、通常のリンクからのログアウトを防止
- BehaviorSubjectを使用して非同期メッセージを管理
- ログアウト後のデフォルトリダイレクト先は /authentication/logged-out

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 定数と設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | api-authorization.constants.ts | `Src/WebUI/ClientApp/src/api-authorization/api-authorization.constants.ts` | LogoutActions、ApplicationPathsの定義を確認 |

**読解のコツ**: LogoutActionsにはlogout、logout-callback、logged-outの3つのアクションが定義されている。

#### Step 2: ルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | api-authorization.module.ts | `Src/WebUI/ClientApp/src/api-authorization/api-authorization.module.ts` | LogoutComponentが複数のパスにマッピングされている点を確認（行21-23） |

**主要処理フロー**:
- **行21**: LogOut → LogoutComponent
- **行22**: LoggedOut → LogoutComponent
- **行23**: LogOutCallback → LogoutComponent

#### Step 3: コンポーネントロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | logout.component.ts | `Src/WebUI/ClientApp/src/api-authorization/logout/logout.component.ts` | ngOnInitでアクションを判定し、各処理を実行 |

**主要処理フロー**:
- **行24-45**: ngOnInit()でURLパスからアクションを判定してswitch文で分岐
- **行28-33**: logoutアクション時、window.history.state.localをチェックしてセキュリティ検証
- **行47-72**: logout()メソッドで認証状態確認とサインアウト処理
- **行74-91**: processLogoutCallback()でIdentityServerからのレスポンスを処理
- **行99-112**: returnUrlのバリデーション（オープンリダイレクト防止）

#### Step 4: 認証サービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | authorize.service.ts | `Src/WebUI/ClientApp/src/api-authorization/authorize.service.ts` | signOut、completeSignOutメソッドの実装を確認 |

**主要処理フロー**:
- **行162-179**: signOut()メソッド - ポップアップ→リダイレクトサインアウトの順で試行
- **行186-206**: completeSignOut()メソッド - ログアウトコールバックの処理

### プログラム呼び出し階層図

```
LogoutComponent.ngOnInit()
    │
    ├─ [logout] (state.local === true)
    │      │
    │      └─ logout(returnUrl)
    │             │
    │             ├─ AuthorizeService.isAuthenticated()
    │             │
    │             └─ AuthorizeService.signOut(state)
    │                    │
    │                    ├─ signoutPopup() [試行1]
    │                    │
    │                    └─ createSignoutRequest() [試行2]
    │                           │
    │                           └─ リダイレクト → IdentityServer
    │
    ├─ [logout] (state.local !== true)
    │      │
    │      └─ message.next('The logout was not initiated...')
    │
    ├─ [logout-callback] processLogoutCallback()
    │      │
    │      └─ AuthorizeService.completeSignOut(url)
    │             │
    │             └─ signoutRedirectCallback()
    │                    │
    │                    └─ navigateToReturnUrl()
    │
    └─ [logged-out] message.next('You successfully logged out!')
```

### データフロー図

```
[入力]               [処理]                    [出力]

ログアウトボタン ───▶ Router.navigate() with {state: {local: true}}
    クリック                   │
                              ▼
              /authentication/logout
                              │
                              ▼
              LogoutComponent.ngOnInit()
                              │
                              ▼
              state.local チェック
                    │
        ┌──────────┴──────────┐
        ▼                     ▼
    [true]                [false]
        │                     │
        ▼                     ▼
    logout()            警告メッセージ表示
        │
        ▼
    isAuthenticated()
        │
        ├─ [true] signOut() ───▶ IdentityServer
        │
        └─ [false] 成功メッセージ

IdentityServer
        │
        ▼
/authentication/logout-callback
        │
        ▼
processLogoutCallback()
        │
        ▼
navigateToReturnUrl() ───▶ /authentication/logged-out
                                   │
                                   ▼
                            'You successfully logged out!'
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| logout.component.ts | `Src/WebUI/ClientApp/src/api-authorization/logout/logout.component.ts` | ソース | ログアウト画面コンポーネント |
| logout.component.html | `Src/WebUI/ClientApp/src/api-authorization/logout/logout.component.html` | テンプレート | ログアウト画面のHTMLテンプレート（メッセージ表示のみ） |
| authorize.service.ts | `Src/WebUI/ClientApp/src/api-authorization/authorize.service.ts` | ソース | 認証サービス（OIDC処理） |
| api-authorization.constants.ts | `Src/WebUI/ClientApp/src/api-authorization/api-authorization.constants.ts` | ソース | 認証関連の定数定義 |
| api-authorization.module.ts | `Src/WebUI/ClientApp/src/api-authorization/api-authorization.module.ts` | ソース | 認証モジュール（ルーティング設定） |
| login-menu.component.ts | `Src/WebUI/ClientApp/src/api-authorization/login-menu/login-menu.component.ts` | ソース | ログインメニュー（ログアウトボタンの実装元） |
